/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.ProactiveEviction;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.CacheContentsTracker;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheHydration;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapIoDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelFifoCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryLimitedPathCache;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.apache.hadoop.hive.llap.cache.ProactiveEvictingCachePolicy;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.SimpleAllocator;
import org.apache.hadoop.hive.llap.cache.SimpleBufferManager;
import org.apache.hadoop.hive.llap.daemon.impl.LlapPooledIOThread;
import org.apache.hadoop.hive.llap.daemon.impl.StatsRecordingThreadPool;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.impl.LlapCacheMetadataSerializer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.api.impl.LlapRecordReader;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.GenericColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.LlapCacheOnlyInputFormatInterface;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.orc.impl.OrcTail;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapIoImpl
implements LlapIo<VectorizedRowBatch>,
LlapIoDebugDump {
    public static final Logger LOG = LoggerFactory.getLogger((String)"LlapIoImpl");
    public static final Logger ORC_LOGGER = LoggerFactory.getLogger((String)"LlapIoOrc");
    public static final Logger CACHE_LOGGER = LoggerFactory.getLogger((String)"LlapIoCache");
    public static final Logger LOCKING_LOGGER = LoggerFactory.getLogger((String)"LlapIoLocking");
    private static final String MODE_CACHE = "cache";
    private final ColumnVectorProducer orcCvp;
    private final ColumnVectorProducer genericCvp;
    private final ExecutorService executor;
    private final ExecutorService encodeExecutor;
    private final LlapDaemonCacheMetrics cacheMetrics;
    private final LlapDaemonIOMetrics ioMetrics;
    private final boolean useLowLevelCache;
    private ObjectName buddyAllocatorMXBean;
    private final Allocator allocator;
    private final FileMetadataCache fileMetadataCache;
    private final LowLevelCache dataCache;
    private final SerDeLowLevelCacheImpl serdeCache;
    private final BufferUsageManager bufferManager;
    private final Configuration daemonConf;
    private final LowLevelCacheMemoryManager memoryManager;
    private PathCache pathCache;
    private final FixedSizedObjectPool<IoTrace> tracePool;
    private LowLevelCachePolicy realCachePolicy;
    private List<LlapIoDebugDump> debugDumpComponents = new ArrayList<LlapIoDebugDump>();

    /*
     * WARNING - void declaration
     */
    private LlapIoImpl(Configuration conf) throws IOException {
        void var10_16;
        boolean isEncodeEnabled;
        this.daemonConf = conf;
        String ioMode = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MODE);
        this.useLowLevelCache = MODE_CACHE.equalsIgnoreCase(ioMode);
        LOG.info("Initializing LLAP IO in {} mode", (Object)(this.useLowLevelCache ? MODE_CACHE : "none"));
        String displayName = "LlapDaemonCacheMetrics-" + MetricsUtils.getHostName();
        String sessionId = conf.get("llap.daemon.metrics.sessionid");
        this.cacheMetrics = LlapDaemonCacheMetrics.create(displayName, sessionId);
        displayName = "LlapDaemonIOMetrics-" + MetricsUtils.getHostName();
        Object[] strIntervals = HiveConf.getTrimmedStringsVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_DECODING_METRICS_PERCENTILE_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String string : strIntervals) {
                try {
                    intervalList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring IO decoding metrics interval {} from {} as it is invalid", (Object)string, (Object)Arrays.toString(strIntervals));
                }
            }
        }
        this.ioMetrics = LlapDaemonIOMetrics.create(displayName, sessionId, Ints.toArray(intervalList));
        LOG.info("Started llap daemon metrics with displayName: {} sessionId: {}", (Object)displayName, (Object)sessionId);
        MetadataCache metadataCache = null;
        SerDeLowLevelCacheImpl serdeCache = null;
        LowLevelCache bufferManagerOrc = null;
        Object var10_13 = null;
        boolean bl = isEncodeEnabled = this.useLowLevelCache && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_ENABLED);
        if (this.useLowLevelCache) {
            boolean trackUsage;
            boolean useLrfu = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_USE_LRFU);
            long totalMemorySize = HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE);
            int minAllocSize = (int)HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC);
            LowLevelCachePolicy lowLevelCachePolicy = this.realCachePolicy = useLrfu ? new LowLevelLrfuCachePolicy(minAllocSize, totalMemorySize, conf) : new LowLevelFifoCachePolicy();
            if (!(this.realCachePolicy instanceof ProactiveEvictingCachePolicy.Impl)) {
                HiveConf.setBoolVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_ENABLED, (boolean)false);
                LOG.info("Turning off proactive cache eviction, as selected cache policy does not support it.");
            }
            LowLevelCachePolicy cachePolicyWrapper = (trackUsage = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE)) ? new CacheContentsTracker(this.realCachePolicy) : this.realCachePolicy;
            this.memoryManager = new LowLevelCacheMemoryManager(totalMemorySize, cachePolicyWrapper, this.cacheMetrics);
            this.cacheMetrics.setCacheCapacityTotal(totalMemorySize);
            BuddyAllocator allocator = new BuddyAllocator(conf, this.memoryManager, this.cacheMetrics);
            this.allocator = allocator;
            LowLevelCacheImpl cacheImpl = new LowLevelCacheImpl(this.cacheMetrics, cachePolicyWrapper, allocator, true);
            this.dataCache = cacheImpl;
            if (isEncodeEnabled) {
                SerDeLowLevelCacheImpl serdeCacheImpl;
                serdeCache = serdeCacheImpl = new SerDeLowLevelCacheImpl(this.cacheMetrics, cachePolicyWrapper, allocator);
                serdeCacheImpl.setConf(conf);
            }
            boolean useGapCache = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ENABLE_ORC_GAP_CACHE);
            metadataCache = new MetadataCache(allocator, this.memoryManager, cachePolicyWrapper, useGapCache, this.cacheMetrics);
            this.fileMetadataCache = metadataCache;
            EvictionDispatcher e = new EvictionDispatcher(this.dataCache, serdeCache, metadataCache, allocator);
            cachePolicyWrapper.setEvictionListener(e);
            cacheImpl.startThreads();
            bufferManagerOrc = cacheImpl;
            this.bufferManager = bufferManagerOrc;
            SerDeLowLevelCacheImpl serDeLowLevelCacheImpl = serdeCache;
            if (trackUsage) {
                this.debugDumpComponents.add(cachePolicyWrapper);
            }
            this.debugDumpComponents.add(this.realCachePolicy);
            this.debugDumpComponents.add(cacheImpl);
            if (serdeCache != null) {
                this.debugDumpComponents.add(serdeCache);
            }
            if (metadataCache != null) {
                this.debugDumpComponents.add(metadataCache);
            }
            this.debugDumpComponents.add(allocator);
            this.pathCache = new MemoryLimitedPathCache(conf);
        } else {
            SimpleBufferManager sbm;
            SimpleBufferManager simpleBufferManager;
            this.allocator = new SimpleAllocator(conf);
            this.fileMetadataCache = null;
            bufferManagerOrc = simpleBufferManager = (sbm = new SimpleBufferManager(this.allocator, this.cacheMetrics));
            this.bufferManager = simpleBufferManager;
            this.dataCache = sbm;
            this.memoryManager = null;
            this.debugDumpComponents.add(new LlapIoDebugDump(){

                @Override
                public void debugDumpShort(StringBuilder sb) {
                    sb.append("LLAP IO allocator is not in use!");
                }
            });
        }
        this.serdeCache = serdeCache;
        int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        this.executor = new StatsRecordingThreadPool(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-%d").setDaemon(true).setThreadFactory(r -> new LlapPooledIOThread(r)).build());
        this.tracePool = IoTrace.createTracePool((Configuration)conf);
        if (isEncodeEnabled) {
            int encodePoolMultiplier = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_THREADPOOL_MULTIPLIER);
            int encodeThreads = numThreads * encodePoolMultiplier;
            this.encodeExecutor = new StatsRecordingThreadPool(encodeThreads, encodeThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-OrcEncode-%d").setDaemon(true).setThreadFactory(r -> new LlapPooledIOThread(r)).build());
        } else {
            this.encodeExecutor = null;
        }
        this.orcCvp = new OrcColumnVectorProducer(metadataCache, this.dataCache, this.pathCache, (BufferUsageManager)((Object)bufferManagerOrc), conf, this.cacheMetrics, this.ioMetrics, this.tracePool);
        this.genericCvp = isEncodeEnabled ? new GenericColumnVectorProducer(serdeCache, (BufferUsageManager)var10_16, conf, this.cacheMetrics, this.ioMetrics, this.tracePool, this.encodeExecutor) : null;
        LOG.info("LLAP IO initialized");
        this.registerMXBeans();
        LlapCacheHydration.setupAndStartIfEnabled(this.daemonConf);
    }

    private void registerMXBeans() {
        this.buddyAllocatorMXBean = MBeans.register((String)"LlapDaemon", (String)"BuddyAllocatorInfo", (Object)this.allocator);
    }

    public String getMemoryInfo() {
        StringBuilder sb = new StringBuilder();
        this.debugDumpShort(sb);
        return sb.toString();
    }

    public long purge() {
        if (this.memoryManager != null) {
            return this.memoryManager.purge();
        }
        return 0L;
    }

    public long evictEntity(LlapDaemonProtocolProtos.EvictEntityRequestProto protoRequest) {
        if (this.memoryManager == null || !HiveConf.getBoolVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_ENABLED)) {
            return -1L;
        }
        ProactiveEviction.Request request = ProactiveEviction.Request.Builder.create().fromProtoRequest(protoRequest).build();
        Predicate<CacheTag> predicate = tag -> request.isTagMatch(tag);
        boolean isInstantDeallocation = HiveConf.getBoolVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_INSTANT_DEALLOC);
        LOG.debug("Starting proactive eviction.");
        long time = System.currentTimeMillis();
        long markedBytes = this.dataCache.markBuffersForProactiveEviction(predicate, isInstantDeallocation);
        markedBytes += this.fileMetadataCache.markBuffersForProactiveEviction(predicate, isInstantDeallocation);
        if ((markedBytes += this.serdeCache.markBuffersForProactiveEviction(predicate, isInstantDeallocation)) > 0L) {
            this.memoryManager.notifyProactiveEvictionMark();
        }
        time = System.currentTimeMillis() - time;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(markedBytes).append(" bytes marked for eviction from LLAP cache buffers that belong to table(s): ");
            for (String table : ((Map)request.getEntities().get(request.getSingleDbName())).keySet()) {
                sb.append(table).append(" ");
            }
            sb.append(" Duration: ").append(time).append(" ms");
            LOG.debug(sb.toString());
        }
        return markedBytes;
    }

    public InputFormat<NullWritable, VectorizedRowBatch> getInputFormat(InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe) {
        ColumnVectorProducer cvp = this.genericCvp;
        if (sourceInputFormat instanceof OrcInputFormat) {
            cvp = this.orcCvp;
        } else if (cvp == null) {
            LOG.warn("LLAP encode is disabled; cannot use for " + sourceInputFormat.getClass());
            return null;
        }
        return new LlapInputFormat(sourceInputFormat, sourceSerDe, cvp, this.executor, this.daemonConf);
    }

    public void close() {
        LOG.info("Closing LlapIoImpl..");
        if (this.buddyAllocatorMXBean != null) {
            MBeans.unregister((ObjectName)this.buddyAllocatorMXBean);
            this.buddyAllocatorMXBean = null;
        }
        this.executor.shutdownNow();
        if (this.encodeExecutor != null) {
            this.encodeExecutor.shutdownNow();
        }
    }

    public void initCacheOnlyInputFormat(InputFormat<?, ?> inputFormat) {
        LlapCacheOnlyInputFormatInterface cacheIf = (LlapCacheOnlyInputFormatInterface)inputFormat;
        cacheIf.injectCaches(this.fileMetadataCache, (DataCache)new GenericDataCache(this.dataCache, this.bufferManager), this.daemonConf);
    }

    @Override
    public void debugDumpShort(StringBuilder sb) {
        for (LlapIoDebugDump child : this.debugDumpComponents) {
            child.debugDumpShort(sb);
        }
    }

    public OrcTail getOrcTailFromCache(Path path, Configuration jobConf, CacheTag tag, Object fileKey) throws IOException {
        return OrcEncodedDataReader.getOrcTailForPath(path, jobConf, tag, this.daemonConf, (MetadataCache)this.fileMetadataCache, fileKey);
    }

    public RecordReader<NullWritable, VectorizedRowBatch> llapVectorizedOrcReaderForPath(Object fileKey, Path path, CacheTag tag, List<Integer> tableIncludedCols, JobConf conf, long offset, long length, Reporter reporter) throws IOException {
        OrcTail tail = null;
        if (tag != null) {
            tail = this.getOrcTailFromCache(path, (Configuration)conf, tag, fileKey);
        }
        OrcSplit split = new OrcSplit(path, fileKey, offset, length, (String[])null, tail, false, false, (List)Lists.newArrayList(), 0L, length, path.getParent(), null);
        try {
            LlapRecordReader rr = LlapRecordReader.create(conf, (FileSplit)split, tableIncludedCols, HiveStringUtils.getHostname(), this.orcCvp, this.executor, null, null, reporter, this.daemonConf);
            if (rr == null) {
                return null;
            }
            rr.setPartitionValues(null);
            rr.start();
            return rr;
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBufferOrBuffers getParquetFooterBuffersFromCache(Path path, JobConf conf, @Nullable Object fileKey) throws IOException {
        MemoryBufferOrBuffers footerData;
        Preconditions.checkNotNull((Object)this.fileMetadataCache, (Object)"Metadata cache must not be null");
        boolean isReadCacheOnly = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_CACHE_ONLY);
        CacheTag tag = VectorizedParquetRecordReader.cacheTagOfParquetFile((Path)path, (Configuration)this.daemonConf, (JobConf)conf);
        MemoryBufferOrBuffers memoryBufferOrBuffers = footerData = fileKey == null ? null : this.fileMetadataCache.getFileMetadata(fileKey);
        if (footerData != null) {
            LOG.info("Found the footer in cache for " + fileKey);
            try {
                MemoryBufferOrBuffers memoryBufferOrBuffers2 = footerData;
                return memoryBufferOrBuffers2;
            }
            finally {
                this.fileMetadataCache.decRefBuffer(footerData);
            }
        }
        LlapHiveUtils.throwIfCacheOnlyRead((boolean)isReadCacheOnly);
        FileSystem fs = path.getFileSystem((Configuration)conf);
        FileStatus stat = fs.getFileStatus(path);
        Throwable throwable = null;
        try (SeekableInputStream stream = HadoopStreams.wrap((FSDataInputStream)fs.open(path));){
            MemoryBufferOrBuffers memoryBufferOrBuffers3;
            long footerLengthIndex = stat.getLen() - 4L - (long)ParquetFileWriter.MAGIC.length;
            stream.seek(footerLengthIndex);
            int footerLength = BytesUtils.readIntLittleEndian((InputStream)stream);
            stream.seek(footerLengthIndex - (long)footerLength);
            LOG.info("Caching the footer of length " + footerLength + " for " + fileKey);
            footerData = this.fileMetadataCache.putFileMetadata(fileKey, footerLength, (InputStream)stream, tag, null);
            try {
                memoryBufferOrBuffers3 = footerData;
            }
            catch (Throwable throwable2) {
                try {
                    this.fileMetadataCache.decRefBuffer(footerData);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.fileMetadataCache.decRefBuffer(footerData);
            return memoryBufferOrBuffers3;
        }
    }

    public LlapDaemonProtocolProtos.CacheEntryList fetchCachedContentInfo() {
        if (this.useLowLevelCache) {
            GenericDataCache cache = new GenericDataCache(this.dataCache, this.bufferManager);
            LlapCacheMetadataSerializer serializer = new LlapCacheMetadataSerializer(this.fileMetadataCache, cache, this.daemonConf, this.pathCache, this.tracePool, this.realCachePolicy);
            return serializer.fetchCachedContentInfo();
        }
        LOG.warn("Low level cache is disabled.");
        return LlapDaemonProtocolProtos.CacheEntryList.getDefaultInstance();
    }

    public void loadDataIntoCache(LlapDaemonProtocolProtos.CacheEntryList metadata) {
        if (this.useLowLevelCache) {
            GenericDataCache cache = new GenericDataCache(this.dataCache, this.bufferManager);
            LlapCacheMetadataSerializer serializer = new LlapCacheMetadataSerializer(this.fileMetadataCache, cache, this.daemonConf, this.pathCache, this.tracePool, this.realCachePolicy);
            serializer.loadData(metadata);
        } else {
            LOG.warn("Cannot load data into the cache. Low level cache is disabled.");
        }
    }

    public boolean usingLowLevelCache() {
        return this.useLowLevelCache;
    }

    private class GenericDataCache
    implements DataCache,
    Allocator.BufferObjectFactory {
        private final LowLevelCache lowLevelCache;
        private final BufferUsageManager bufferManager;

        public GenericDataCache(LowLevelCache lowLevelCache, BufferUsageManager bufferManager) {
            this.lowLevelCache = lowLevelCache;
            this.bufferManager = bufferManager;
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            return this.lowLevelCache.getFileData(fileKey, range, baseOffset, factory, null, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            return this.putFileData(fileKey, ranges, data, baseOffset, null);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset, CacheTag tag) {
            return this.lowLevelCache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, null, tag);
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return this.bufferManager.getAllocator();
        }

        public Allocator.BufferObjectFactory getDataBufferFactory() {
            return this;
        }

        public MemoryBuffer create() {
            return new LlapDataBuffer();
        }
    }
}

