/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.service.LlapServiceCommandLine;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncTaskCopyConfigs
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncTaskCopyConfigs.class.getName());
    private final LlapServiceCommandLine cl;
    private final HiveConf conf;
    private final Properties directProperties;
    private final FileSystem rawFs;
    private final Path confDir;

    AsyncTaskCopyConfigs(LlapServiceCommandLine cl, HiveConf conf, Properties directProperties, FileSystem rawFs, Path confDir) {
        this.cl = cl;
        this.conf = conf;
        this.directProperties = directProperties;
        this.rawFs = rawFs;
        this.confDir = confDir;
    }

    @Override
    public Void call() throws Exception {
        for (String f : LlapDaemonConfiguration.DAEMON_CONFIGS) {
            this.copyConfig(f);
        }
        for (String f : LlapDaemonConfiguration.SSL_DAEMON_CONFIGS) {
            try {
                this.copyConfig(f);
            }
            catch (Throwable t) {
                LOG.info("Error getting an optional config " + f + "; ignoring: " + t.getMessage());
            }
        }
        this.createLlapDaemonConfig();
        this.setUpLoggerConfig();
        this.setUpMetricsConfig();
        return null;
    }

    private void copyConfig(String f) throws IOException {
        HiveConf.getBoolVar((Configuration)new Configuration(false), (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS);
        this.rawFs.copyFromLocalFile(new Path(this.conf.getResource(f).toString()), this.confDir);
    }

    private void createLlapDaemonConfig() throws IOException {
        FSDataOutputStream confStream = this.rawFs.create(new Path(this.confDir, "llap-daemon-site.xml"));
        Configuration llapDaemonConf = this.resolve();
        llapDaemonConf.writeXml((OutputStream)confStream);
        confStream.close();
    }

    private Configuration resolve() {
        Configuration target = new Configuration(false);
        this.populateConf(target, this.cl.getConfig(), "CLI hiveconf");
        this.populateConf(target, this.directProperties, "CLI direct");
        return target;
    }

    private void populateConf(Configuration target, Properties properties, String source) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = this.conf.get(key);
            if (val == null) continue;
            target.set(key, val, source);
        }
    }

    private void setUpLoggerConfig() throws Exception {
        URL logger = this.conf.getResource("llap-daemon-log4j2.properties");
        if (null == logger) {
            throw new Exception("Unable to find required config file: llap-daemon-log4j2.properties");
        }
        InputStream loggerContent = logger.openStream();
        IOUtils.copyBytes((InputStream)loggerContent, (OutputStream)this.rawFs.create(new Path(this.confDir, "llap-daemon-log4j2.properties"), true), (Configuration)this.conf, (boolean)true);
    }

    private void setUpMetricsConfig() throws IOException {
        String metricsFile = "hadoop-metrics2-llapdaemon.properties";
        URL metrics2 = this.conf.getResource(metricsFile);
        if (metrics2 == null) {
            LOG.warn("hadoop-metrics2-llapdaemon.properties cannot be found. Looking for hadoop-metrics2.properties");
            metricsFile = "hadoop-metrics2.properties";
            metrics2 = this.conf.getResource(metricsFile);
        }
        if (metrics2 != null) {
            InputStream metrics2FileStream = metrics2.openStream();
            IOUtils.copyBytes((InputStream)metrics2FileStream, (OutputStream)this.rawFs.create(new Path(this.confDir, metricsFile), true), (Configuration)this.conf, (boolean)true);
            LOG.info("Copied hadoop metrics2 properties file from " + metrics2);
        } else {
            LOG.warn("Cannot find hadoop-metrics2-llapdaemon.properties or hadoop-metrics2.properties in classpath.");
        }
    }
}

