/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class LlapConfigJsonCreator {
    private static final String CONFIG_CLUSTER_NAME = "private.hive.llap.servicedriver.cluster.name";
    private final HiveConf conf;
    private final FileSystem fs;
    private final Path tmpDir;
    private final long cache;
    private final long xmx;
    private final String javaHome;

    LlapConfigJsonCreator(HiveConf conf, FileSystem fs, Path tmpDir, long cache, long xmx, String javaHome) {
        this.conf = conf;
        this.fs = fs;
        this.tmpDir = tmpDir;
        this.cache = cache;
        this.xmx = xmx;
        this.javaHome = javaHome;
    }

    void createLlapConfigJson() throws Exception {
        JSONObject configs = this.createConfigJson();
        this.writeConfigJson(configs);
    }

    private JSONObject createConfigJson() throws JSONException {
        String clusterHosts;
        JSONObject configs = new JSONObject();
        configs.put("java.home", (Object)this.javaHome);
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, this.conf.getLongVar(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB));
        configs.put(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, this.conf.getSizeVar(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE));
        configs.put(HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT.varname, this.conf.getBoolVar(HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, this.conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE.varname, this.conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, this.conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS));
        if (this.conf.getVar(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME) != null) {
            configs.put(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, (Object)this.conf.getVar(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME));
        }
        if (!StringUtils.isEmpty((CharSequence)(clusterHosts = this.conf.getVar(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS))) && clusterHosts.startsWith("@") && clusterHosts.length() > 1) {
            configs.put(CONFIG_CLUSTER_NAME, (Object)clusterHosts.substring(1));
        }
        configs.put("yarn.scheduler.minimum-allocation-mb", this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1));
        configs.put("yarn.scheduler.minimum-allocation-vcores", this.conf.getInt("yarn.scheduler.minimum-allocation-vcores", -1));
        long maxDirect = this.xmx > 0L && this.cache > 0L && (double)this.xmx < (double)this.cache * 1.25 ? (long)((double)this.cache * 1.25) : -1L;
        configs.put("max_direct_memory", (Object)Long.toString(maxDirect));
        configs.put(HiveConf.ConfVars.LLAP_HDFS_PACKAGE_DIR.varname, (Object)this.conf.getVar(HiveConf.ConfVars.LLAP_HDFS_PACKAGE_DIR));
        return configs;
    }

    private void writeConfigJson(JSONObject configs) throws Exception {
        try (FSDataOutputStream fsdos = this.fs.create(new Path(this.tmpDir, "config.json"));
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)fsdos, Charset.defaultCharset());){
            configs.write((Writer)w);
        }
    }
}

