/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncTaskCreateUdfFile
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncTaskCreateUdfFile.class.getName());
    private final HiveConf conf;
    private final FileSystem fs;
    private final FileSystem rawFs;
    private final Path udfDir;
    private final Path confDir;

    AsyncTaskCreateUdfFile(HiveConf conf, FileSystem fs, FileSystem rawFs, Path udfDir, Path confDir) {
        this.conf = conf;
        this.fs = fs;
        this.rawFs = rawFs;
        this.udfDir = udfDir;
        this.confDir = confDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        Set<Object> allowedUdfs;
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOW_PERMANENT_FNS)) {
            FileSystem fileSystem = this.fs;
            synchronized (fileSystem) {
                allowedUdfs = this.downloadPermanentFunctions();
            }
        } else {
            allowedUdfs = Collections.emptySet();
        }
        FSDataOutputStream os = this.rawFs.create(new Path(this.confDir, "llap-udfs.lst"));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());
        PrintWriter udfStream = new PrintWriter(osw);
        for (String string : allowedUdfs) {
            udfStream.println(string);
        }
        udfStream.close();
        return null;
    }

    private Set<String> downloadPermanentFunctions() throws HiveException, URISyntaxException, IOException {
        HashMap<String, CallSite> udfs = new HashMap<String, CallSite>();
        HiveConf hiveConf = new HiveConf(this.conf);
        hiveConf.setBoolean(MetastoreConf.ConfVars.METRICS_ENABLED.getVarname(), false);
        Hive hive = Hive.getWithFastCheck((HiveConf)hiveConf, (boolean)false);
        ResourceDownloader resourceDownloader = new ResourceDownloader((Configuration)this.conf, this.udfDir.toUri().normalize().getPath());
        List fns = hive.getAllFunctions();
        HashSet<URI> srcUris = new HashSet<URI>();
        for (Function fn : fns) {
            String fqfn = fn.getDbName() + "." + fn.getFunctionName();
            if (udfs.containsKey(fn.getClassName())) {
                LOG.warn("Duplicate function names found for " + fn.getClassName() + " with " + fqfn + " and " + (String)udfs.get(fn.getClassName()));
            }
            udfs.put(fn.getClassName(), (CallSite)((Object)fqfn));
            List resources = fn.getResourceUris();
            if (resources == null || resources.isEmpty()) {
                LOG.warn("Missing resources for " + fqfn);
                continue;
            }
            for (ResourceUri resource : resources) {
                srcUris.add(ResourceDownloader.createURI((String)resource.getUri()));
            }
        }
        for (URI srcUri : srcUris) {
            List localUris = resourceDownloader.downloadExternal(srcUri, null);
            for (URI dst : localUris) {
                LOG.warn("Downloaded " + dst + " from " + srcUri);
            }
        }
        return udfs.keySet();
    }
}

