/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.AddToClassPathAction;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.UDFClassLoader;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.tez.common.TezClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionLocalizer
implements GenericUDFBridge.UdfWhitelistChecker {
    private static final String DIR_NAME = "fnresources";
    private static final Logger LOG = LoggerFactory.getLogger(FunctionLocalizer.class);
    private ResourceDownloader resourceDownloader;
    private final LinkedBlockingQueue<LocalizerWork> workQueue = new LinkedBlockingQueue();
    private volatile boolean isClosed = false;
    private final List<String> recentlyLocalizedJars = new LinkedList<String>();
    private final List<String> recentlyLocalizedClasses = new LinkedList<String>();
    private final Thread workThread;
    private final File localDir;
    private final Configuration conf;
    private final UDFClassLoader executorClassloader;
    private final IdentityHashMap<Class<?>, Boolean> allowedUdfClasses = new IdentityHashMap();
    private final ConcurrentHashMap<String, FnResources> resourcesByFn = new ConcurrentHashMap();
    private final ConcurrentHashMap<URI, RefCountedResource> localFiles = new ConcurrentHashMap();

    public FunctionLocalizer(Configuration conf, String localDir) {
        this.conf = conf;
        this.localDir = new File(localDir, DIR_NAME);
        AddToClassPathAction addAction = new AddToClassPathAction((ClassLoader)TezClassLoader.getInstance(), Collections.emptyList(), true);
        this.executorClassloader = (UDFClassLoader)AccessController.doPrivileged(addAction);
        this.workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FunctionLocalizer.this.runWorkThread();
            }
        });
    }

    public void init() throws IOException {
        if (this.localDir.exists()) {
            FileUtils.deleteDirectory((File)this.localDir);
        }
        this.resourceDownloader = new ResourceDownloader(this.conf, this.localDir.getAbsolutePath());
        this.workThread.start();
    }

    public boolean isUdfAllowed(Class<?> clazz) {
        return FunctionRegistry.isBuiltInFuncClass(clazz) || this.allowedUdfClasses.containsKey(clazz);
    }

    public ClassLoader getClassLoader() {
        return this.executorClassloader;
    }

    public void startLocalizeAllFunctions() throws HiveException {
        Hive hive = Hive.get((boolean)false);
        try {
            hive.getMSC(HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST), true);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
        List fns = hive.getAllFunctions();
        for (Function fn : fns) {
            String fqfn = fn.getDbName() + "." + fn.getFunctionName();
            List resources = fn.getResourceUris();
            if (resources == null || resources.isEmpty()) continue;
            FnResources result = new FnResources();
            this.resourcesByFn.put(fqfn, result);
            this.workQueue.add(new LocalizeFn(fqfn, resources, result, fn.getClassName(), false));
        }
        this.workQueue.add(new RefreshClassloader());
    }

    public void close() {
        this.isClosed = true;
        this.workThread.interrupt();
        try {
            this.workThread.join(1000L);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted during close");
        }
    }

    private void runWorkThread() {
        while (true) {
            if (this.isClosed) {
                this.deleteAllLocalResources();
                return;
            }
            LocalizerWork lw = null;
            try {
                lw = this.workQueue.take();
            }
            catch (InterruptedException ex) {
                LOG.debug("Localizer thread interrupted");
                this.isClosed = true;
            }
            if (this.isClosed) {
                this.deleteAllLocalResources();
                return;
            }
            try {
                lw.run(this);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.debug("Localizer thread interrupted");
                this.isClosed = true;
                continue;
            }
            catch (Exception ex) {
                LOG.error("Failed to run " + lw, (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private void deleteAllLocalResources() {
        try {
            this.executorClassloader.close();
        }
        catch (Exception ex) {
            LOG.info("Failed to close the classloader", (Object)ex.getMessage());
        }
        this.resourcesByFn.clear();
        for (RefCountedResource rcr : this.localFiles.values()) {
            for (FunctionInfo.FunctionResource fr : rcr.resources) {
                File file = new File(fr.getResourceURI());
                try {
                    if (file.delete()) continue;
                    LOG.info("Failed to delete " + file);
                }
                catch (Exception ex) {
                    LOG.info("Failed to delete " + file + ": " + ex.getMessage());
                }
            }
        }
    }

    public void refreshClassloader() throws IOException {
        if (this.recentlyLocalizedJars.isEmpty()) {
            return;
        }
        String[] jars = this.recentlyLocalizedJars.toArray(new String[0]);
        this.recentlyLocalizedJars.clear();
        ClassLoader updatedCl = null;
        try {
            AddToClassPathAction addAction = new AddToClassPathAction((ClassLoader)this.executorClassloader, Arrays.asList(jars));
            updatedCl = (ClassLoader)AccessController.doPrivileged(addAction);
            if (LOG.isInfoEnabled()) {
                LOG.info("Added " + jars.length + " jars to classpath");
            }
        }
        catch (Throwable t) {
            this.logRefreshError("Unable to localize jars: ", jars, t);
            return;
        }
        if (updatedCl != this.executorClassloader) {
            throw new AssertionError((Object)("Classloader was replaced despite using UDFClassLoader: new " + updatedCl + ", old " + this.executorClassloader));
        }
        String[] classNames = this.recentlyLocalizedClasses.toArray(jars);
        this.recentlyLocalizedClasses.clear();
        try {
            for (String className : classNames) {
                this.allowedUdfClasses.put(Class.forName(className, false, (ClassLoader)this.executorClassloader), Boolean.TRUE);
            }
        }
        catch (Throwable t) {
            this.logRefreshError("Unable to instantiate localized classes: ", classNames, t);
            return;
        }
    }

    private void logRefreshError(String what, String[] items, Throwable t) throws IOException {
        for (String item : items) {
            what = (String)what + item + ", ";
        }
        throw new IOException((String)what, t);
    }

    private void localizeFunctionResources(String fqfn, List<ResourceUri> resources, String className, FnResources result, boolean doRefreshClassloader) throws URISyntaxException, IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Localizing " + resources.size() + " resources for " + fqfn);
        }
        for (ResourceUri resource : resources) {
            URI srcUri = ResourceDownloader.createURI((String)resource.getUri());
            SessionState.ResourceType rt = FunctionUtils.getResourceType((ResourceType)resource.getResourceType());
            this.localizeOneResource(fqfn, srcUri, rt, result);
        }
        this.recentlyLocalizedClasses.add(className);
        if (doRefreshClassloader) {
            this.refreshClassloader();
        }
    }

    private void localizeOneResource(String fqfn, URI srcUri, SessionState.ResourceType rt, FnResources result) throws URISyntaxException, IOException {
        RefCountedResource rcr = this.localFiles.get(srcUri);
        if (rcr != null && rcr.refCount > 0) {
            this.logFilesUsed("Reusing", fqfn, srcUri, rcr);
            ++rcr.refCount;
            result.addResources(rcr);
            return;
        }
        rcr = new RefCountedResource();
        List localUris = this.resourceDownloader.downloadExternal(srcUri, fqfn);
        if (localUris == null || localUris.isEmpty()) {
            LOG.error("Cannot download " + srcUri + " for " + fqfn);
            return;
        }
        rcr.resources = new ArrayList<FunctionInfo.FunctionResource>();
        for (URI uri : localUris) {
            String path = uri.getPath();
            rcr.resources.add(new FunctionInfo.FunctionResource(rt, path));
            if (rt != SessionState.ResourceType.JAR) continue;
            this.recentlyLocalizedJars.add(path);
        }
        ++rcr.refCount;
        this.logFilesUsed("Using", fqfn, srcUri, rcr);
        this.localFiles.put(srcUri, rcr);
        result.addResources(rcr);
    }

    private void logFilesUsed(String what, String fqfn, URI srcUri, RefCountedResource rcr) {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        String desc = rcr.resources.size() == 1 ? rcr.resources.get(0).toString() : rcr.resources.size() + " files";
        LOG.info(what + " files [" + desc + "] for [" + srcUri + "] resource for " + fqfn);
    }

    private static class FnResources {
        final List<FunctionInfo.FunctionResource> localResources = new ArrayList<FunctionInfo.FunctionResource>();
        final List<RefCountedResource> originals = new ArrayList<RefCountedResource>();

        private FnResources() {
        }

        public void addResources(RefCountedResource rcr) {
            this.localResources.addAll(rcr.resources);
            this.originals.add(rcr);
        }
    }

    private static class LocalizeFn
    implements LocalizerWork {
        private final List<ResourceUri> resources;
        private final FnResources result;
        private final String fqfn;
        private final boolean doRefreshClassloader;
        private final String className;

        public LocalizeFn(String fqfn, List<ResourceUri> resources, FnResources result, String className, boolean doRefreshClassloader) {
            this.resources = resources;
            this.result = result;
            this.fqfn = fqfn;
            this.className = className;
            this.doRefreshClassloader = doRefreshClassloader;
        }

        @Override
        public void run(FunctionLocalizer parent) throws URISyntaxException, IOException {
            parent.localizeFunctionResources(this.fqfn, this.resources, this.className, this.result, this.doRefreshClassloader);
        }

        public String toString() {
            return "localize " + this.resources.size() + " resources for " + this.fqfn;
        }
    }

    private static class RefreshClassloader
    implements LocalizerWork {
        private RefreshClassloader() {
        }

        @Override
        public void run(FunctionLocalizer parent) throws URISyntaxException, IOException {
            parent.refreshClassloader();
        }

        public String toString() {
            return "load the recently localized jars";
        }
    }

    private static interface LocalizerWork {
        public void run(FunctionLocalizer var1) throws URISyntaxException, IOException, InterruptedException;
    }

    private static class RefCountedResource {
        List<FunctionInfo.FunctionResource> resources;
        int refCount = 0;

        private RefCountedResource() {
        }
    }
}

