/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.metrics;

import org.apache.hadoop.hive.common.JvmMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapTaskSchedulerInfo;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Llap Task Scheduler Metrics", context="scheduler")
public class LlapTaskSchedulerMetrics
implements MetricsSource {
    private final String name;
    private final JvmMetrics jvmMetrics;
    private final String sessionId;
    private final MetricsRegistry registry;
    @Metric
    MutableGaugeInt numExecutors;
    @Metric
    MutableGaugeLong memoryPerInstance;
    @Metric
    MutableGaugeInt cpuCoresPerInstance;
    @Metric
    MutableGaugeInt clusterNodeCount;
    @Metric
    MutableGaugeInt disabledNodeCount;
    @Metric
    MutableCounterInt pendingTasksCount;
    @Metric
    MutableCounterInt schedulableTasksCount;
    @Metric
    MutableCounterInt runningTasksCount;
    @Metric
    MutableCounterInt successfulTasksCount;
    @Metric
    MutableCounterInt preemptedTasksCount;
    @Metric
    MutableCounterInt completedDagcount;
    @Metric
    MutableCounterInt pendingPreemptionTasksCount;

    private LlapTaskSchedulerMetrics(String displayName, JvmMetrics jm, String sessionId) {
        this.name = displayName;
        this.jvmMetrics = jm;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapTaskSchedulerMetricsRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static LlapTaskSchedulerMetrics create(String displayName, String sessionId) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)"LlapDaemon", (String)sessionId, (MetricsSystem)ms);
        return (LlapTaskSchedulerMetrics)ms.register(displayName, "Llap Task Scheduler Metrics", (Object)new LlapTaskSchedulerMetrics(displayName, jm, sessionId));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapTaskSchedulerInfo.SchedulerMetrics).setContext("scheduler").tag((MetricsInfo)MsInfo.ProcessName, "DAGAppMaster").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getTaskSchedulerStats(rb);
    }

    public void setNumExecutors(int value) {
        this.numExecutors.set(value);
    }

    public void setMemoryPerInstance(long value) {
        this.memoryPerInstance.set(value);
    }

    public void setCpuCoresPerInstance(int value) {
        this.cpuCoresPerInstance.set(value);
    }

    public void setClusterNodeCount(int value) {
        this.clusterNodeCount.set(value);
    }

    public void setDisabledNodeCount(int value) {
        this.disabledNodeCount.set(value);
    }

    public void incrPendingTasksCount() {
        this.pendingTasksCount.incr();
    }

    public void decrPendingTasksCount() {
        this.pendingTasksCount.incr(-1);
    }

    public void incrSchedulableTasksCount(int delta) {
        this.schedulableTasksCount.incr(delta);
    }

    public void incrSchedulableTasksCount() {
        this.schedulableTasksCount.incr();
    }

    public void decrSchedulableTasksCount() {
        this.schedulableTasksCount.incr(-1);
    }

    public void incrSuccessfulTasksCount() {
        this.successfulTasksCount.incr();
    }

    public void incrRunningTasksCount() {
        this.runningTasksCount.incr();
    }

    public void decrRunningTasksCount() {
        this.runningTasksCount.incr(-1);
    }

    public void incrPreemptedTasksCount() {
        this.preemptedTasksCount.incr();
    }

    public void incrCompletedDagCount() {
        this.completedDagcount.incr();
    }

    public void incrPendingPreemptionTasksCount() {
        this.pendingPreemptionTasksCount.incr();
    }

    public void decrPendingPreemptionTasksCount() {
        this.pendingPreemptionTasksCount.incr(-1);
    }

    private void getTaskSchedulerStats(MetricsRecordBuilder rb) {
        rb.addGauge((MetricsInfo)LlapTaskSchedulerInfo.SchedulerClusterNodeCount, this.clusterNodeCount.value()).addGauge((MetricsInfo)LlapTaskSchedulerInfo.SchedulerExecutorsPerInstance, this.numExecutors.value()).addGauge((MetricsInfo)LlapTaskSchedulerInfo.SchedulerMemoryPerInstance, this.memoryPerInstance.value()).addGauge((MetricsInfo)LlapTaskSchedulerInfo.SchedulerCpuCoresPerInstance, this.cpuCoresPerInstance.value()).addGauge((MetricsInfo)LlapTaskSchedulerInfo.SchedulerDisabledNodeCount, this.disabledNodeCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerPendingTaskCount, this.pendingTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerSchedulableTaskCount, this.schedulableTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerRunningTaskCount, this.runningTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerSuccessfulTaskCount, this.successfulTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerPendingPreemptionTaskCount, this.pendingPreemptionTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerPreemptedTaskCount, this.preemptedTasksCount.value()).addCounter((MetricsInfo)LlapTaskSchedulerInfo.SchedulerCompletedDagCount, this.completedDagcount.value());
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public String getName() {
        return this.name;
    }
}

