/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.util.StringUtils;

public class CompactionTxnHandler
extends TxnHandler {
    private static final String CLASS_NAME = CompactionTxnHandler.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    public CompactionTxnHandler(HiveConf conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CompactionInfo> findPotentialCompactions(int maxAborted) throws MetaException {
        Connection dbConn = this.getDbConn();
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        try {
            CompactionInfo info;
            Statement stmt = dbConn.createStatement();
            String s = "select distinct ctc_database, ctc_table, ctc_partition from COMPLETED_TXN_COMPONENTS";
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            ResultSet rs = stmt.executeQuery(s);
            while (rs.next()) {
                info = new CompactionInfo();
                info.dbname = rs.getString(1);
                info.tableName = rs.getString(2);
                info.partName = rs.getString(3);
                response.add(info);
            }
            s = "select tc_database, tc_table, tc_partition from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' group by tc_database, tc_table, tc_partition having count(*) > " + maxAborted;
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                info = new CompactionInfo();
                info.dbname = rs.getString(1);
                info.tableName = rs.getString(2);
                info.partName = rs.getString(3);
                info.tooManyAborts = true;
                response.add(info);
            }
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
        }
        catch (SQLException e) {
            LOG.error((Object)("Unable to connect to transaction database " + e.getMessage()));
        }
        finally {
            this.closeDbConn(dbConn);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunAs(long cq_id, String user) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_run_as = '" + user + "' where cq_id = " + cq_id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) != 1) {
                    LOG.error((Object)"Unable to update compaction record");
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                LOG.error((Object)("Unable to update compaction queue, " + e.getMessage()));
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "setRunAs");
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.setRunAs(cq_id, user);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        try {
            CompactionInfo compactionInfo;
            ResultSet rs;
            String s;
            Statement stmt;
            CompactionInfo info;
            Connection dbConn;
            block19: {
                dbConn = this.getDbConn();
                info = new CompactionInfo();
                stmt = dbConn.createStatement();
                s = "select cq_id, cq_database, cq_table, cq_partition, cq_type from COMPACTION_QUEUE where cq_state = 'i' for update";
                LOG.debug((Object)("Going to execute query <" + s + ">"));
                rs = stmt.executeQuery(s);
                if (rs.next()) break block19;
                LOG.debug((Object)"No compactions found ready to compact");
                dbConn.rollback();
                CompactionInfo compactionInfo2 = null;
                this.closeDbConn(dbConn);
                return compactionInfo2;
            }
            try {
                info.id = rs.getLong(1);
                info.dbname = rs.getString(2);
                info.tableName = rs.getString(3);
                info.partName = rs.getString(4);
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        info.type = CompactionType.MAJOR;
                        break;
                    }
                    case 'i': {
                        info.type = CompactionType.MINOR;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                long now = System.currentTimeMillis();
                s = "update COMPACTION_QUEUE set cq_worker_id = '" + workerId + "', " + "cq_start = " + now + ", cq_state = '" + 'w' + "' where cq_id = " + info.id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) != 1) {
                    LOG.error((Object)"Unable to update compaction record");
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
                compactionInfo = info;
            }
            catch (SQLException e) {
                try {
                    try {
                        LOG.error((Object)("Unable to select next element for compaction, " + e.getMessage()));
                        try {
                            LOG.debug((Object)"Going to rollback");
                            dbConn.rollback();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        this.detectDeadlock(e, "findNextToCompact");
                        throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                catch (TxnHandler.DeadlockException e2) {
                    CompactionInfo compactionInfo3 = this.findNextToCompact(workerId);
                    return compactionInfo3;
                }
            }
            this.closeDbConn(dbConn);
            return compactionInfo;
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompacted(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_state = 'r', cq_worker_id = null where cq_id = " + info.id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) != 1) {
                    LOG.error((Object)"Unable to update compaction record");
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to update compaction queue " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "markCompacted");
                throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.markCompacted(info);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    public List<CompactionInfo> findReadyToClean() throws MetaException {
        Connection dbConn = this.getDbConn();
        ArrayList<CompactionInfo> rc = new ArrayList<CompactionInfo>();
        try {
            Statement stmt = dbConn.createStatement();
            String s = "select cq_id, cq_database, cq_table, cq_partition, cq_type, cq_run_as from COMPACTION_QUEUE where cq_state = 'r'";
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            ResultSet rs = stmt.executeQuery(s);
            while (rs.next()) {
                CompactionInfo info = new CompactionInfo();
                info.id = rs.getLong(1);
                info.dbname = rs.getString(2);
                info.tableName = rs.getString(3);
                info.partName = rs.getString(4);
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        info.type = CompactionType.MAJOR;
                        break;
                    }
                    case 'i': {
                        info.type = CompactionType.MINOR;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                info.runAs = rs.getString(6);
                rc.add(info);
            }
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            ArrayList<CompactionInfo> arrayList = rc;
            return arrayList;
        }
        catch (SQLException e) {
            LOG.error((Object)("Unable to select next element for cleaning, " + e.getMessage()));
            try {
                LOG.debug((Object)"Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.closeDbConn(dbConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCleaned(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "delete from COMPACTION_QUEUE where cq_id = " + info.id;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) != 1) {
                    LOG.error((Object)"Unable to delete compaction record");
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                s = "delete from COMPLETED_TXN_COMPONENTS where ctc_database = '" + info.dbname + "' and " + "ctc_table = '" + info.tableName + "'";
                if (info.partName != null) {
                    s = s + " and ctc_partition = '" + info.partName + "'";
                }
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                if (stmt.executeUpdate(s) < 1) {
                    LOG.error((Object)"Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
                }
                s = "select txn_id from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' and tc_database = '" + info.dbname + "' and tc_table = '" + info.tableName + "'";
                if (info.partName != null) {
                    s = s + " and tc_partition = '" + info.partName + "'";
                }
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                ResultSet rs = stmt.executeQuery(s);
                HashSet<Long> txnids = new HashSet<Long>();
                while (rs.next()) {
                    txnids.add(rs.getLong(1));
                }
                if (txnids.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("delete from TXN_COMPONENTS where tc_txnid in (");
                    boolean first = true;
                    Iterator i$ = txnids.iterator();
                    while (i$.hasNext()) {
                        long id = (Long)i$.next();
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(id);
                    }
                    buf.append(") and tc_database = '");
                    buf.append(info.dbname);
                    buf.append("' and tc_table = '");
                    buf.append(info.tableName);
                    buf.append("'");
                    if (info.partName != null) {
                        buf.append(" and tc_partition = '");
                        buf.append(info.partName);
                        buf.append("'");
                    }
                    LOG.debug((Object)("Going to execute update <" + buf.toString() + ">"));
                    int rc = stmt.executeUpdate(buf.toString());
                    LOG.debug((Object)("Removed " + rc + " records from txn_components"));
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to delete from compaction queue " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "markCleaned");
                throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.markCleaned(info);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanEmptyAbortedTxns() throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "select txn_id from TXNS where txn_id not in (select tc_txnid from TXN_COMPONENTS) and txn_state = 'a'";
                LOG.debug((Object)("Going to execute query <" + s + ">"));
                ResultSet rs = stmt.executeQuery(s);
                HashSet<Long> txnids = new HashSet<Long>();
                while (rs.next()) {
                    txnids.add(rs.getLong(1));
                }
                if (txnids.size() > 0) {
                    StringBuffer buf = new StringBuffer("delete from TXNS where txn_id in (");
                    boolean first = true;
                    Iterator i$ = txnids.iterator();
                    while (i$.hasNext()) {
                        long tid = (Long)i$.next();
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(tid);
                    }
                    buf.append(")");
                    LOG.debug((Object)("Going to execute update <" + buf.toString() + ">"));
                    int rc = stmt.executeUpdate(buf.toString());
                    LOG.debug((Object)("Removed " + rc + " records from txns"));
                    LOG.debug((Object)"Going to commit");
                    dbConn.commit();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)("Unable to delete from txns table " + e.getMessage()));
                LOG.debug((Object)"Going to rollback");
                try {
                    dbConn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.detectDeadlock(e, "cleanEmptyAbortedTxns");
                throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.cleanEmptyAbortedTxns();
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_worker_id like '" + hostname + "%'";
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to change dead worker's records back to initiated state " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "revokeFromLocalWorkers");
                throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.revokeFromLocalWorkers(hostname);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            long latestValidStart = System.currentTimeMillis() - timeout;
            try {
                Statement stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_start < " + latestValidStart;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error((Object)("Unable to change dead worker's records back to initiated state " + e.getMessage()));
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "revokeTimedoutWorkers");
                throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.DeadlockException e) {
            this.revokeTimedoutWorkers(timeout);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }
}

