/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.metastore.MetaStoreDirectSql;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;

public class StatObjectConverter {
    public static MTableColumnStatistics convertToMTableColumnStatistics(MTable table, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj) throws NoSuchObjectException, MetaException, InvalidObjectException {
        if (statsObj == null || statsDesc == null) {
            throw new InvalidObjectException("Invalid column stats object");
        }
        MTableColumnStatistics mColStats = new MTableColumnStatistics();
        mColStats.setTable(table);
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? StatObjectConverter.createJdoDecimalString(decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? StatObjectConverter.createJdoDecimalString(decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        }
        return mColStats;
    }

    public static void setFieldsIntoOldStats(MTableColumnStatistics mStatsObj, MTableColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue());
        }
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls());
        }
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
    }

    public static void setFieldsIntoOldStats(MPartitionColumnStatistics mStatsObj, MPartitionColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue());
        }
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls());
        }
    }

    public static ColumnStatisticsObj getTableColumnStatisticsObj(MTableColumnStatistics mStatsObj) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses());
            boolStats.setNumTrues(mStatsObj.getNumTrues());
            boolStats.setNumNulls(mStatsObj.getNumNulls());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsData stringStats = new StringColumnStatsData();
            stringStats.setNumNulls(mStatsObj.getNumNulls());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen());
            stringStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setStringStats(stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint") || colType.equals("timestamp")) {
            Long longLowValue;
            LongColumnStatsData longStats = new LongColumnStatsData();
            longStats.setNumNulls(mStatsObj.getNumNulls());
            Long longHighValue = mStatsObj.getLongHighValue();
            if (longHighValue != null) {
                longStats.setHighValue(longHighValue);
            }
            if ((longLowValue = mStatsObj.getLongLowValue()) != null) {
                longStats.setLowValue(longLowValue);
            }
            longStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setLongStats(longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            Double doubleLowValue;
            DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
            doubleStats.setNumNulls(mStatsObj.getNumNulls());
            Double doubleHighValue = mStatsObj.getDoubleHighValue();
            if (doubleHighValue != null) {
                doubleStats.setHighValue(doubleHighValue);
            }
            if ((doubleLowValue = mStatsObj.getDoubleLowValue()) != null) {
                doubleStats.setLowValue(doubleLowValue);
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setDoubleStats(doubleStats);
        } else if (colType.startsWith("decimal")) {
            String decimalLowValue;
            DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
            decimalStats.setNumNulls(mStatsObj.getNumNulls());
            String decimalHighValue = mStatsObj.getDecimalHighValue();
            if (decimalHighValue != null) {
                decimalStats.setHighValue(StatObjectConverter.createThriftDecimal(decimalHighValue));
            }
            if ((decimalLowValue = mStatsObj.getDecimalLowValue()) != null) {
                decimalStats.setLowValue(StatObjectConverter.createThriftDecimal(decimalLowValue));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setDecimalStats(decimalStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getTableColumnStatisticsDesc(MTableColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(true);
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static MPartitionColumnStatistics convertToMPartitionColumnStatistics(MPartition partition, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj) throws MetaException, NoSuchObjectException {
        if (statsDesc == null || statsObj == null) {
            return null;
        }
        MPartitionColumnStatistics mColStats = new MPartitionColumnStatistics();
        mColStats.setPartition(partition);
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setPartitionName(statsDesc.getPartName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? StatObjectConverter.createJdoDecimalString(decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? StatObjectConverter.createJdoDecimalString(decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        }
        return mColStats;
    }

    public static ColumnStatisticsObj getPartitionColumnStatisticsObj(MPartitionColumnStatistics mStatsObj) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses());
            boolStats.setNumTrues(mStatsObj.getNumTrues());
            boolStats.setNumNulls(mStatsObj.getNumNulls());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsData stringStats = new StringColumnStatsData();
            stringStats.setNumNulls(mStatsObj.getNumNulls());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen());
            stringStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setStringStats(stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("tinyint") || colType.equals("smallint") || colType.equals("int") || colType.equals("bigint") || colType.equals("timestamp")) {
            LongColumnStatsData longStats = new LongColumnStatsData();
            longStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getLongHighValue() != null) {
                longStats.setHighValue(mStatsObj.getLongHighValue());
            }
            if (mStatsObj.getLongLowValue() != null) {
                longStats.setLowValue(mStatsObj.getLongLowValue());
            }
            longStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setLongStats(longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
            doubleStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getDoubleHighValue() != null) {
                doubleStats.setHighValue(mStatsObj.getDoubleHighValue());
            }
            if (mStatsObj.getDoubleLowValue() != null) {
                doubleStats.setLowValue(mStatsObj.getDoubleLowValue());
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setDoubleStats(doubleStats);
        } else if (colType.startsWith("decimal")) {
            DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
            decimalStats.setNumNulls(mStatsObj.getNumNulls());
            if (mStatsObj.getDecimalHighValue() != null) {
                decimalStats.setHighValue(StatObjectConverter.createThriftDecimal(mStatsObj.getDecimalHighValue()));
            }
            if (mStatsObj.getDecimalLowValue() != null) {
                decimalStats.setLowValue(StatObjectConverter.createThriftDecimal(mStatsObj.getDecimalLowValue()));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs());
            colStatsData.setDecimalStats(decimalStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getPartitionColumnStatisticsDesc(MPartitionColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(false);
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setPartName(mStatsObj.getPartitionName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static void fillColumnStatisticsData(String colType, ColumnStatisticsData data, Object llow, Object lhigh, Object dlow, Object dhigh, Object declow, Object dechigh, Object nulls, Object dist, Object avglen, Object maxlen, Object trues, Object falses) throws MetaException {
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(MetaStoreDirectSql.extractSqlLong(falses));
            boolStats.setNumTrues(MetaStoreDirectSql.extractSqlLong(trues));
            boolStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            data.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            StringColumnStatsData stringStats = new StringColumnStatsData();
            stringStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            stringStats.setAvgColLen((Double)avglen);
            stringStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen));
            stringStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist));
            data.setStringStats(stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            binaryStats.setAvgColLen((Double)avglen);
            binaryStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen));
            data.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint") || colType.equals("timestamp")) {
            LongColumnStatsData longStats = new LongColumnStatsData();
            longStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            if (lhigh != null) {
                longStats.setHighValue(MetaStoreDirectSql.extractSqlLong(lhigh));
            }
            if (llow != null) {
                longStats.setLowValue(MetaStoreDirectSql.extractSqlLong(llow));
            }
            longStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist));
            data.setLongStats(longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
            doubleStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            if (dhigh != null) {
                doubleStats.setHighValue((Double)dhigh);
            }
            if (dlow != null) {
                doubleStats.setLowValue((Double)dlow);
            }
            doubleStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist));
            data.setDoubleStats(doubleStats);
        } else if (colType.startsWith("decimal")) {
            DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
            decimalStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            if (dechigh != null) {
                decimalStats.setHighValue(StatObjectConverter.createThriftDecimal((String)dechigh));
            }
            if (declow != null) {
                decimalStats.setLowValue(StatObjectConverter.createThriftDecimal((String)declow));
            }
            decimalStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist));
            data.setDecimalStats(decimalStats);
        }
    }

    private static Decimal createThriftDecimal(String s) {
        BigDecimal d = new BigDecimal(s);
        return new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale());
    }

    private static String createJdoDecimalString(Decimal d) {
        return new BigDecimal(new BigInteger(d.getUnscaled()), d.getScale()).toString();
    }
}

