/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.BinaryColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.BooleanColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.DecimalColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.DoubleColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.LongColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.hbase.stats.StringColumnStatsAggregator;

public class ColumnStatsAggregatorFactory {
    private ColumnStatsAggregatorFactory() {
    }

    public static ColumnStatsAggregator getColumnStatsAggregator(ColumnStatisticsData._Fields type) {
        switch (type) {
            case BOOLEAN_STATS: {
                return new BooleanColumnStatsAggregator();
            }
            case LONG_STATS: {
                return new LongColumnStatsAggregator();
            }
            case DOUBLE_STATS: {
                return new DoubleColumnStatsAggregator();
            }
            case STRING_STATS: {
                return new StringColumnStatsAggregator();
            }
            case BINARY_STATS: {
                return new BinaryColumnStatsAggregator();
            }
            case DECIMAL_STATS: {
                return new DecimalColumnStatsAggregator();
            }
        }
        throw new RuntimeException("Woh, bad.  Unknown stats type " + type.toString());
    }

    public static ColumnStatisticsObj newColumnStaticsObj(String colName, String colType, ColumnStatisticsData._Fields type) {
        ColumnStatisticsObj cso = new ColumnStatisticsObj();
        ColumnStatisticsData csd = new ColumnStatisticsData();
        cso.setColName(colName);
        cso.setColType(colType);
        switch (type) {
            case BOOLEAN_STATS: {
                csd.setBooleanStats(new BooleanColumnStatsData());
                break;
            }
            case LONG_STATS: {
                csd.setLongStats(new LongColumnStatsData());
                break;
            }
            case DOUBLE_STATS: {
                csd.setDoubleStats(new DoubleColumnStatsData());
                break;
            }
            case STRING_STATS: {
                csd.setStringStats(new StringColumnStatsData());
                break;
            }
            case BINARY_STATS: {
                csd.setBinaryStats(new BinaryColumnStatsData());
                break;
            }
            case DECIMAL_STATS: {
                csd.setDecimalStats(new DecimalColumnStatsData());
                break;
            }
            default: {
                throw new RuntimeException("Woh, bad.  Unknown stats type!");
            }
        }
        cso.setStatsData(csd);
        return cso;
    }
}

