/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;

public class DoubleColumnStatsAggregator
implements ColumnStatsAggregator {
    @Override
    public void aggregate(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        DoubleColumnStatsData aggregateData = aggregateColStats.getStatsData().getDoubleStats();
        DoubleColumnStatsData newData = newColStats.getStatsData().getDoubleStats();
        aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
        aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
    }
}

