/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.CompressionCodec;

public final class DataReaderProperties {
    private final FileSystem fileSystem;
    private final Path path;
    private final CompressionCodec codec;
    private final boolean zeroCopy;

    private DataReaderProperties(Builder builder) {
        this.fileSystem = builder.fileSystem;
        this.path = builder.path;
        this.codec = builder.codec;
        this.zeroCopy = builder.zeroCopy;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Path getPath() {
        return this.path;
    }

    @Nullable
    public CompressionCodec getCodec() {
        return this.codec;
    }

    public boolean getZeroCopy() {
        return this.zeroCopy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FileSystem fileSystem;
        private Path path;
        private CompressionCodec codec;
        private boolean zeroCopy;

        private Builder() {
        }

        public Builder withFileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withCodec(CompressionCodec codec) {
            this.codec = codec;
            return this;
        }

        public Builder withZeroCopy(boolean zeroCopy) {
            this.zeroCopy = zeroCopy;
            return this;
        }

        public DataReaderProperties build() {
            Preconditions.checkNotNull((Object)this.fileSystem);
            Preconditions.checkNotNull((Object)this.path);
            return new DataReaderProperties(this);
        }
    }
}

