/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BitFieldReader;
import org.apache.orc.impl.ConvertTreeReaderFactory;
import org.apache.orc.impl.DynamicByteArray;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.IntegerReader;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RunLengthByteReader;
import org.apache.orc.impl.RunLengthIntegerReader;
import org.apache.orc.impl.RunLengthIntegerReaderV2;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.SerializationUtils;
import org.apache.orc.impl.StreamName;

public class TreeReaderFactory {
    public static TreeReader createTreeReader(TypeDescription readerType, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
        TypeDescription fileType = evolution.getFileType(readerType);
        if (fileType == null || included != null && !included[readerType.getId()]) {
            return new NullTreeReader(0);
        }
        TypeDescription.Category readerTypeCategory = readerType.getCategory();
        if (!fileType.getCategory().equals((Object)readerTypeCategory) && readerTypeCategory != TypeDescription.Category.STRUCT && readerTypeCategory != TypeDescription.Category.MAP && readerTypeCategory != TypeDescription.Category.LIST && readerTypeCategory != TypeDescription.Category.UNION) {
            return ConvertTreeReaderFactory.createConvertTreeReader(readerType, evolution, included, skipCorrupt);
        }
        switch (readerTypeCategory) {
            case BOOLEAN: {
                return new BooleanTreeReader(fileType.getId());
            }
            case BYTE: {
                return new ByteTreeReader(fileType.getId());
            }
            case DOUBLE: {
                return new DoubleTreeReader(fileType.getId());
            }
            case FLOAT: {
                return new FloatTreeReader(fileType.getId());
            }
            case SHORT: {
                return new ShortTreeReader(fileType.getId());
            }
            case INT: {
                return new IntTreeReader(fileType.getId());
            }
            case LONG: {
                return new LongTreeReader(fileType.getId(), skipCorrupt);
            }
            case STRING: {
                return new StringTreeReader(fileType.getId());
            }
            case CHAR: {
                return new CharTreeReader(fileType.getId(), readerType.getMaxLength());
            }
            case VARCHAR: {
                return new VarcharTreeReader(fileType.getId(), readerType.getMaxLength());
            }
            case BINARY: {
                return new BinaryTreeReader(fileType.getId());
            }
            case TIMESTAMP: {
                return new TimestampTreeReader(fileType.getId(), skipCorrupt);
            }
            case DATE: {
                return new DateTreeReader(fileType.getId());
            }
            case DECIMAL: {
                return new DecimalTreeReader(fileType.getId(), readerType.getPrecision(), readerType.getScale());
            }
            case STRUCT: {
                return new StructTreeReader(fileType.getId(), readerType, evolution, included, skipCorrupt);
            }
            case LIST: {
                return new ListTreeReader(fileType.getId(), readerType, evolution, included, skipCorrupt);
            }
            case MAP: {
                return new MapTreeReader(fileType.getId(), readerType, evolution, included, skipCorrupt);
            }
            case UNION: {
                return new UnionTreeReader(fileType.getId(), readerType, evolution, included, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerTypeCategory));
    }

    public static class MapTreeReader
    extends TreeReader {
        protected final TreeReader keyReader;
        protected final TreeReader valueReader;
        protected IntegerReader lengths = null;

        protected MapTreeReader(int fileColumn, TypeDescription readerSchema, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
            super(fileColumn);
            TypeDescription keyType = readerSchema.getChildren().get(0);
            TypeDescription valueType = readerSchema.getChildren().get(1);
            this.keyReader = TreeReaderFactory.createTreeReader(keyType, evolution, included, skipCorrupt);
            this.valueReader = TreeReaderFactory.createTreeReader(valueType, evolution, included, skipCorrupt);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.keyReader.seek(index);
            this.valueReader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previous, boolean[] isNull, int batchSize) throws IOException {
            MapColumnVector result = (MapColumnVector)previous;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            if (result.noNulls || !result.isRepeating || !result.isNull[0]) {
                this.lengths.nextVector((ColumnVector)result, result.lengths, batchSize);
                result.isRepeating = false;
                result.childCount = 0;
                for (int r = 0; r < batchSize; ++r) {
                    if (!result.noNulls && result.isNull[r]) continue;
                    result.offsets[r] = result.childCount;
                    result.childCount = (int)((long)result.childCount + result.lengths[r]);
                }
                result.keys.ensureSize(result.childCount, false);
                result.values.ensureSize(result.childCount, false);
                this.keyReader.nextVector(result.keys, null, result.childCount);
                this.valueReader.nextVector(result.values, null, result.childCount);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.lengths = MapTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
            if (this.keyReader != null) {
                this.keyReader.startStripe(streams, stripeFooter);
            }
            if (this.valueReader != null) {
                this.valueReader.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.keyReader.skipRows(childSkip);
            this.valueReader.skipRows(childSkip);
        }
    }

    public static class ListTreeReader
    extends TreeReader {
        protected final TreeReader elementReader;
        protected IntegerReader lengths = null;

        protected ListTreeReader(int fileColumn, TypeDescription readerSchema, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
            super(fileColumn);
            TypeDescription elementType = readerSchema.getChildren().get(0);
            this.elementReader = TreeReaderFactory.createTreeReader(elementType, evolution, included, skipCorrupt);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.elementReader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previous, boolean[] isNull, int batchSize) throws IOException {
            ListColumnVector result = (ListColumnVector)previous;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            if (result.noNulls || !result.isRepeating || !result.isNull[0]) {
                this.lengths.nextVector((ColumnVector)result, result.lengths, batchSize);
                result.isRepeating = false;
                result.childCount = 0;
                for (int r = 0; r < batchSize; ++r) {
                    if (!result.noNulls && result.isNull[r]) continue;
                    result.offsets[r] = result.childCount;
                    result.childCount = (int)((long)result.childCount + result.lengths[r]);
                }
                result.child.ensureSize(result.childCount, false);
                this.elementReader.nextVector(result.child, null, result.childCount);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.lengths = ListTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
            if (this.elementReader != null) {
                this.elementReader.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.elementReader.skipRows(childSkip);
        }
    }

    public static class UnionTreeReader
    extends TreeReader {
        protected final TreeReader[] fields;
        protected RunLengthByteReader tags;

        protected UnionTreeReader(int fileColumn, TypeDescription readerSchema, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
            super(fileColumn);
            List<TypeDescription> childrenTypes = readerSchema.getChildren();
            int fieldCount = childrenTypes.size();
            this.fields = new TreeReader[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                TypeDescription subtype = childrenTypes.get(i);
                this.fields[i] = TreeReaderFactory.createTreeReader(subtype, evolution, included, skipCorrupt);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.tags.seek(index[this.columnId]);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            UnionColumnVector result = (UnionColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            if (result.noNulls || !result.isRepeating || !result.isNull[0]) {
                result.isRepeating = false;
                this.tags.nextVector(result.noNulls ? null : result.isNull, result.tags, batchSize);
                boolean[] ignore = new boolean[batchSize];
                for (int f = 0; f < result.fields.length; ++f) {
                    for (int r = 0; r < batchSize; ++r) {
                        ignore[r] = !result.noNulls && result.isNull[r] || result.tags[r] != f;
                    }
                    this.fields[f].nextVector(result.fields[f], ignore, batchSize);
                }
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long[] counts = new long[this.fields.length];
            int i = 0;
            while ((long)i < items) {
                byte by = this.tags.next();
                counts[by] = counts[by] + 1L;
                ++i;
            }
            for (i = 0; i < counts.length; ++i) {
                this.fields[i].skipRows(counts[i]);
            }
        }
    }

    protected static class StructTreeReader
    extends TreeReader {
        protected final TreeReader[] fields;

        protected StructTreeReader(int columnId, TypeDescription readerSchema, SchemaEvolution evolution, boolean[] included, boolean skipCorrupt) throws IOException {
            super(columnId);
            List<TypeDescription> childrenTypes = readerSchema.getChildren();
            this.fields = new TreeReader[childrenTypes.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                TypeDescription subtype = childrenTypes.get(i);
                this.fields[i] = TreeReaderFactory.createTreeReader(subtype, evolution, included, skipCorrupt);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            for (TreeReader kid : this.fields) {
                if (kid == null) continue;
                kid.seek(index);
            }
        }

        @Override
        public void nextBatch(VectorizedRowBatch batch, int batchSize) throws IOException {
            for (int i = 0; i < this.fields.length && (this.vectorColumnCount == -1 || i < this.vectorColumnCount); ++i) {
                batch.cols[i].reset();
                batch.cols[i].ensureSize(batchSize, false);
                this.fields[i].nextVector(batch.cols[i], null, batchSize);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            super.nextVector(previousVector, isNull, batchSize);
            StructColumnVector result = (StructColumnVector)previousVector;
            if (result.noNulls || !result.isRepeating || !result.isNull[0]) {
                result.isRepeating = false;
                boolean[] mask = result.noNulls ? null : result.isNull;
                for (int f = 0; f < this.fields.length; ++f) {
                    if (this.fields[f] == null) continue;
                    this.fields[f].nextVector(result.fields[f], mask, batchSize);
                }
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.skipRows(items);
            }
        }
    }

    public static class VarcharTreeReader
    extends StringTreeReader {
        int maxLength;

        VarcharTreeReader(int columnId, int maxLength) throws IOException {
            this(columnId, maxLength, null, null, null, null, null);
        }

        protected VarcharTreeReader(int columnId, int maxLength, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, dictionary, encoding);
            this.maxLength = maxLength;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block5: {
                BytesColumnVector result;
                block4: {
                    int adjustedDownLen;
                    super.nextVector(previousVector, isNull, batchSize);
                    result = (BytesColumnVector)previousVector;
                    if (!result.isRepeating) break block4;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.truncate((byte[])result.vector[0], (int)result.start[0], (int)result.length[0], (int)this.maxLength)) >= result.length[0]) break block5;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block5;
                }
                if (result.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        int adjustedDownLen = StringExpr.truncate((byte[])result.vector[i], (int)result.start[i], (int)result.length[i], (int)this.maxLength);
                        if (adjustedDownLen >= result.length[i]) continue;
                        result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        int adjustedDownLen;
                        if (result.isNull[i] || (adjustedDownLen = StringExpr.truncate((byte[])result.vector[i], (int)result.start[i], (int)result.length[i], (int)this.maxLength)) >= result.length[i]) continue;
                        result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                    }
                }
            }
        }
    }

    public static class CharTreeReader
    extends StringTreeReader {
        int maxLength;

        CharTreeReader(int columnId, int maxLength) throws IOException {
            this(columnId, maxLength, null, null, null, null, null);
        }

        protected CharTreeReader(int columnId, int maxLength, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, dictionary, encoding);
            this.maxLength = maxLength;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block5: {
                BytesColumnVector result;
                block4: {
                    int adjustedDownLen;
                    super.nextVector(previousVector, isNull, batchSize);
                    result = (BytesColumnVector)previousVector;
                    if (!result.isRepeating) break block4;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.rightTrimAndTruncate((byte[])result.vector[0], (int)result.start[0], (int)result.length[0], (int)this.maxLength)) >= result.length[0]) break block5;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block5;
                }
                if (result.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        int adjustedDownLen = StringExpr.rightTrimAndTruncate((byte[])result.vector[i], (int)result.start[i], (int)result.length[i], (int)this.maxLength);
                        if (adjustedDownLen >= result.length[i]) continue;
                        result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        int adjustedDownLen;
                        if (result.isNull[i] || (adjustedDownLen = StringExpr.rightTrimAndTruncate((byte[])result.vector[i], (int)result.start[i], (int)result.length[i], (int)this.maxLength)) >= result.length[i]) continue;
                        result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                    }
                }
            }
        }
    }

    public static class StringDictionaryTreeReader
    extends TreeReader {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private DynamicByteArray dictionaryBuffer;
        private int[] dictionaryOffsets;
        protected IntegerReader reader;
        private byte[] dictionaryBufferInBytesCache = null;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDictionaryTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null, null);
        }

        protected StringDictionaryTreeReader(int columnId, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.reader = StringDictionaryTreeReader.createIntegerReader(encoding.getKind(), data, false, false);
            }
            if (dictionary != null && encoding != null) {
                this.readDictionaryStream(dictionary);
            }
            if (length != null && encoding != null) {
                this.readDictionaryLengthStream(length, encoding);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
            InStream in = streams.get(name);
            this.readDictionaryStream(in);
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
            in = streams.get(name);
            this.readDictionaryLengthStream(in, stripeFooter.getColumnsList().get(this.columnId));
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = StringDictionaryTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), false, false);
        }

        private void readDictionaryLengthStream(InStream in, OrcProto.ColumnEncoding encoding) throws IOException {
            int dictionarySize = encoding.getDictionarySize();
            if (in != null) {
                IntegerReader lenReader = StringDictionaryTreeReader.createIntegerReader(encoding.getKind(), in, false, false);
                int offset = 0;
                if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < dictionarySize + 1) {
                    this.dictionaryOffsets = new int[dictionarySize + 1];
                }
                for (int i = 0; i < dictionarySize; ++i) {
                    this.dictionaryOffsets[i] = offset;
                    offset += (int)lenReader.next();
                }
                this.dictionaryOffsets[dictionarySize] = offset;
                in.close();
            }
        }

        private void readDictionaryStream(InStream in) throws IOException {
            if (in != null) {
                if (in.available() > 0) {
                    this.dictionaryBuffer = new DynamicByteArray(64, in.available());
                    this.dictionaryBuffer.readAll(in);
                    this.dictionaryBufferInBytesCache = null;
                }
                in.close();
            } else {
                this.dictionaryBuffer = null;
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            BytesColumnVector result = (BytesColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            if (this.dictionaryBuffer != null) {
                if (this.dictionaryBufferInBytesCache == null) {
                    this.dictionaryBufferInBytesCache = this.dictionaryBuffer.get();
                }
                this.scratchlcv.isNull = result.isNull;
                this.scratchlcv.ensureSize(batchSize, false);
                this.reader.nextVector((ColumnVector)this.scratchlcv, this.scratchlcv.vector, batchSize);
                if (!this.scratchlcv.isRepeating) {
                    for (int i = 0; i < batchSize; ++i) {
                        if (!this.scratchlcv.isNull[i]) {
                            int offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[i]];
                            int length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[i], offset);
                            result.setRef(i, this.dictionaryBufferInBytesCache, offset, length);
                            continue;
                        }
                        result.setRef(i, this.dictionaryBufferInBytesCache, 0, 0);
                    }
                } else {
                    int offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[0]];
                    int length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[0], offset);
                    result.setRef(0, this.dictionaryBufferInBytesCache, offset, length);
                }
                result.isRepeating = this.scratchlcv.isRepeating;
            } else if (this.dictionaryOffsets == null) {
                result.isRepeating = true;
                result.noNulls = false;
                result.isNull[0] = true;
                result.setRef(0, EMPTY_BYTE_ARRAY, 0, 0);
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (result.isNull[i]) continue;
                    result.setRef(i, EMPTY_BYTE_ARRAY, 0, 0);
                }
            }
        }

        int getDictionaryEntryLength(int entry, int offset) {
            int length = entry < this.dictionaryOffsets.length - 1 ? this.dictionaryOffsets[entry + 1] - offset : this.dictionaryBuffer.size() - offset;
            return length;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        public IntegerReader getReader() {
            return this.reader;
        }
    }

    public static class StringDirectTreeReader
    extends TreeReader {
        private static final HadoopShims SHIMS = HadoopShims.Factory.get();
        protected InStream stream;
        protected HadoopShims.TextReaderShim data;
        protected IntegerReader lengths;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDirectTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null);
        }

        protected StringDirectTreeReader(int columnId, InStream present, InStream data, InStream length, OrcProto.ColumnEncoding.Kind encoding) throws IOException {
            super(columnId, present);
            this.stream = data;
            if (length != null && encoding != null) {
                this.lengths = StringDirectTreeReader.createIntegerReader(encoding, length, false, false);
                this.data = SHIMS.getTextReaderShim(this.stream);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.data = SHIMS.getTextReaderShim(this.stream);
            this.lengths = StringDirectTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
            this.lengths.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            BytesColumnVector result = (BytesColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            while (lengthToSkip > 0L) {
                lengthToSkip -= this.stream.skip(lengthToSkip);
            }
        }

        public IntegerReader getLengths() {
            return this.lengths;
        }

        public InStream getStream() {
            return this.stream;
        }
    }

    public static class BytesColumnVectorUtil {
        private static byte[] commonReadByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, int batchSize) throws IOException {
            scratchlcv.isNull = result.isNull;
            lengths.nextVector((ColumnVector)scratchlcv, scratchlcv.vector, batchSize);
            int totalLength = 0;
            if (!scratchlcv.isRepeating) {
                for (int i = 0; i < batchSize; ++i) {
                    if (scratchlcv.isNull[i]) continue;
                    totalLength += (int)scratchlcv.vector[i];
                }
            } else if (!scratchlcv.isNull[0]) {
                totalLength = (int)((long)batchSize * scratchlcv.vector[0]);
            }
            byte[] allBytes = new byte[totalLength];
            int offset = 0;
            int len = totalLength;
            while (len > 0) {
                int bytesRead = stream.read(allBytes, offset, len);
                if (bytesRead < 0) {
                    throw new EOFException("Can't finish byte read from " + stream);
                }
                len -= bytesRead;
                offset += bytesRead;
            }
            return allBytes;
        }

        public static void readOrcByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, int batchSize) throws IOException {
            block6: {
                if (!result.noNulls && result.isRepeating && result.isNull[0]) break block6;
                byte[] allBytes = BytesColumnVectorUtil.commonReadByteArrays(stream, lengths, scratchlcv, result, batchSize);
                result.isRepeating = false;
                int offset = 0;
                if (!scratchlcv.isRepeating) {
                    for (int i = 0; i < batchSize; ++i) {
                        if (!scratchlcv.isNull[i]) {
                            result.setRef(i, allBytes, offset, (int)scratchlcv.vector[i]);
                            offset = (int)((long)offset + scratchlcv.vector[i]);
                            continue;
                        }
                        result.setRef(i, allBytes, 0, 0);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (!scratchlcv.isNull[i]) {
                            result.setRef(i, allBytes, offset, (int)scratchlcv.vector[0]);
                            offset = (int)((long)offset + scratchlcv.vector[0]);
                            continue;
                        }
                        result.setRef(i, allBytes, 0, 0);
                    }
                }
            }
        }
    }

    public static class StringTreeReader
    extends TreeReader {
        protected TreeReader reader;

        StringTreeReader(int columnId) throws IOException {
            super(columnId);
        }

        protected StringTreeReader(int columnId, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (encoding != null) {
                switch (encoding.getKind()) {
                    case DIRECT_V2: 
                    case DIRECT: {
                        this.reader = new StringDirectTreeReader(columnId, present, data, length, encoding.getKind());
                        break;
                    }
                    case DICTIONARY_V2: 
                    case DICTIONARY: {
                        this.reader = new StringDictionaryTreeReader(columnId, present, data, length, dictionary, encoding);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)encoding.getKind()));
                    }
                }
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.reader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            switch (stripeFooter.getColumnsList().get(this.columnId).getKind()) {
                case DIRECT_V2: 
                case DIRECT: {
                    this.reader = new StringDirectTreeReader(this.columnId);
                    break;
                }
                case DICTIONARY_V2: 
                case DICTIONARY: {
                    this.reader = new StringDictionaryTreeReader(this.columnId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)stripeFooter.getColumnsList().get(this.columnId).getKind()));
                }
            }
            this.reader.startStripe(streams, stripeFooter);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            this.reader.nextVector(previousVector, isNull, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skipRows(items);
        }
    }

    public static class DecimalTreeReader
    extends TreeReader {
        protected InStream valueStream;
        protected IntegerReader scaleReader = null;
        private int[] scratchScaleVector;
        private final int precision;
        private final int scale;

        DecimalTreeReader(int columnId, int precision, int scale) throws IOException {
            this(columnId, precision, scale, null, null, null, null);
        }

        protected DecimalTreeReader(int columnId, int precision, int scale, InStream present, InStream valueStream, InStream scaleStream, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            this.precision = precision;
            this.scale = scale;
            this.scratchScaleVector = new int[1024];
            this.valueStream = valueStream;
            if (scaleStream != null && encoding != null) {
                this.checkEncoding(encoding);
                this.scaleReader = DecimalTreeReader.createIntegerReader(encoding.getKind(), scaleStream, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.valueStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA));
            this.scaleReader = DecimalTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.valueStream.seek(index);
            this.scaleReader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block4: {
                DecimalColumnVector result;
                block3: {
                    result = (DecimalColumnVector)previousVector;
                    super.nextVector((ColumnVector)result, isNull, batchSize);
                    if (batchSize > this.scratchScaleVector.length) {
                        this.scratchScaleVector = new int[batchSize];
                    }
                    this.scaleReader.nextVector((ColumnVector)result, this.scratchScaleVector, batchSize);
                    if (!result.noNulls) break block3;
                    for (int r = 0; r < batchSize; ++r) {
                        BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                        HiveDecimal dec = HiveDecimal.create((BigInteger)bInt, (int)this.scratchScaleVector[r]);
                        result.set(r, dec);
                    }
                    break block4;
                }
                if (result.isRepeating && result.isNull[0]) break block4;
                for (int r = 0; r < batchSize; ++r) {
                    if (result.isNull[r]) continue;
                    BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                    HiveDecimal dec = HiveDecimal.create((BigInteger)bInt, (int)this.scratchScaleVector[r]);
                    result.set(r, dec);
                }
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readBigInteger(this.valueStream);
                ++i;
            }
            this.scaleReader.skip(items);
        }
    }

    public static class DateTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        DateTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        protected DateTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = DateTreeReader.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = DateTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector((ColumnVector)result, result.vector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    public static class TimestampTreeReader
    extends TreeReader {
        protected IntegerReader data = null;
        protected IntegerReader nanos = null;
        private final boolean skipCorrupt;
        private Map<String, Long> baseTimestampMap;
        private long base_timestamp;
        private final TimeZone readerTimeZone;
        private TimeZone writerTimeZone;
        private boolean hasSameTZRules;

        TimestampTreeReader(int columnId, boolean skipCorrupt) throws IOException {
            this(columnId, null, null, null, null, skipCorrupt);
        }

        protected TimestampTreeReader(int columnId, InStream presentStream, InStream dataStream, InStream nanosStream, OrcProto.ColumnEncoding encoding, boolean skipCorrupt) throws IOException {
            super(columnId, presentStream);
            this.skipCorrupt = skipCorrupt;
            this.baseTimestampMap = new HashMap<String, Long>();
            this.writerTimeZone = this.readerTimeZone = TimeZone.getDefault();
            this.hasSameTZRules = this.writerTimeZone.hasSameRules(this.readerTimeZone);
            this.base_timestamp = this.getBaseTimestamp(this.readerTimeZone.getID());
            if (encoding != null) {
                this.checkEncoding(encoding);
                if (dataStream != null) {
                    this.data = TimestampTreeReader.createIntegerReader(encoding.getKind(), dataStream, true, skipCorrupt);
                }
                if (nanosStream != null) {
                    this.nanos = TimestampTreeReader.createIntegerReader(encoding.getKind(), nanosStream, false, skipCorrupt);
                }
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.data = TimestampTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true, this.skipCorrupt);
            this.nanos = TimestampTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), false, this.skipCorrupt);
            this.base_timestamp = this.getBaseTimestamp(stripeFooter.getWriterTimezone());
        }

        private long getBaseTimestamp(String timeZoneId) throws IOException {
            if (timeZoneId == null || timeZoneId.isEmpty()) {
                timeZoneId = this.readerTimeZone.getID();
            }
            if (!this.baseTimestampMap.containsKey(timeZoneId)) {
                this.writerTimeZone = TimeZone.getTimeZone(timeZoneId);
                this.hasSameTZRules = this.writerTimeZone.hasSameRules(this.readerTimeZone);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setTimeZone(this.writerTimeZone);
                try {
                    long epoch = sdf.parse("2015-01-01 00:00:00").getTime() / 1000L;
                    this.baseTimestampMap.put(timeZoneId, epoch);
                    long l = epoch;
                    return l;
                }
                catch (ParseException e) {
                    throw new IOException("Unable to create base timestamp", e);
                }
                finally {
                    sdf.setTimeZone(this.readerTimeZone);
                }
            }
            return this.baseTimestampMap.get(timeZoneId);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.data.seek(index);
            this.nanos.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            TimestampColumnVector result = (TimestampColumnVector)previousVector;
            super.nextVector(previousVector, isNull, batchSize);
            for (int i = 0; i < batchSize; ++i) {
                if (!result.noNulls && result.isNull[i]) continue;
                long millis = this.data.next() + this.base_timestamp;
                int newNanos = TimestampTreeReader.parseNanos(this.nanos.next());
                if (millis < 0L && newNanos != 0) {
                    --millis;
                }
                millis *= 1000L;
                long offset = 0L;
                if (!this.hasSameTZRules) {
                    offset = this.writerTimeZone.getOffset(millis) - this.readerTimeZone.getOffset(millis);
                }
                long adjustedMillis = millis + offset;
                if (!this.hasSameTZRules && this.readerTimeZone.getOffset(millis) != this.readerTimeZone.getOffset(adjustedMillis)) {
                    long newOffset = this.writerTimeZone.getOffset(millis) - this.readerTimeZone.getOffset(adjustedMillis);
                    adjustedMillis = millis + newOffset;
                }
                result.time[i] = adjustedMillis;
                result.nanos[i] = newNanos;
                if (!result.isRepeating || i == 0 || result.time[0] == result.time[i] && result.nanos[0] == result.nanos[i]) continue;
                result.isRepeating = false;
            }
        }

        private static int parseNanos(long serialized) {
            int zeros = 7 & (int)serialized;
            int result = (int)(serialized >>> 3);
            if (zeros != 0) {
                for (int i = 0; i <= zeros; ++i) {
                    result *= 10;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.data.skip(items);
            this.nanos.skip(items);
        }
    }

    public static class BinaryTreeReader
    extends TreeReader {
        protected InStream stream;
        protected IntegerReader lengths = null;
        protected final LongColumnVector scratchlcv = new LongColumnVector();

        BinaryTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null);
        }

        protected BinaryTreeReader(int columnId, InStream present, InStream data, InStream length, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            this.stream = data;
            if (length != null && encoding != null) {
                this.checkEncoding(encoding);
                this.lengths = BinaryTreeReader.createIntegerReader(encoding.getKind(), length, false, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = BinaryTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
            this.lengths.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            BytesColumnVector result = (BytesColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            while (lengthToSkip > 0L) {
                lengthToSkip -= this.stream.skip(lengthToSkip);
            }
        }
    }

    public static class DoubleTreeReader
    extends TreeReader {
        protected InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        DoubleTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        protected DoubleTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.stream = data;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            boolean hasNulls;
            DoubleColumnVector result = (DoubleColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            boolean allNulls = hasNulls = !result.noNulls;
            if (hasNulls) {
                int i;
                for (i = 0; i < batchSize && batchSize <= result.isNull.length; ++i) {
                    allNulls &= result.isNull[i];
                }
                if (allNulls) {
                    result.vector[0] = Double.NaN;
                    result.isRepeating = true;
                } else {
                    result.isRepeating = false;
                    for (i = 0; batchSize <= result.isNull.length && batchSize <= result.vector.length && i < batchSize; ++i) {
                        result.vector[i] = !result.isNull[i] ? this.utils.readDouble(this.stream) : Double.NaN;
                    }
                }
            } else {
                double d1;
                boolean repeating = batchSize > 1;
                result.vector[0] = d1 = this.utils.readDouble(this.stream);
                for (int i = 1; i < batchSize && batchSize <= result.vector.length; ++i) {
                    double d2 = this.utils.readDouble(this.stream);
                    repeating = repeating && d1 == d2;
                    result.vector[i] = d2;
                }
                result.isRepeating = repeating;
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (long len = items * 8L; len > 0L; len -= this.stream.skip(len)) {
            }
        }
    }

    public static class FloatTreeReader
    extends TreeReader {
        protected InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        FloatTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        protected FloatTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.stream = data;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            boolean hasNulls;
            DoubleColumnVector result = (DoubleColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            boolean allNulls = hasNulls = !result.noNulls;
            if (hasNulls) {
                int i;
                for (i = 0; batchSize <= result.isNull.length && i < batchSize; ++i) {
                    allNulls &= result.isNull[i];
                }
                if (allNulls) {
                    result.vector[0] = Double.NaN;
                    result.isRepeating = true;
                } else {
                    result.isRepeating = false;
                    for (i = 0; batchSize <= result.isNull.length && batchSize <= result.vector.length && i < batchSize; ++i) {
                        result.vector[i] = !result.isNull[i] ? (double)this.utils.readFloat(this.stream) : Double.NaN;
                    }
                }
            } else {
                boolean repeating = batchSize > 1;
                float f1 = this.utils.readFloat(this.stream);
                result.vector[0] = f1;
                for (int i = 1; i < batchSize && batchSize <= result.vector.length; ++i) {
                    float f2 = this.utils.readFloat(this.stream);
                    repeating = repeating && f1 == f2;
                    result.vector[i] = f2;
                }
                result.isRepeating = repeating;
            }
        }

        @Override
        protected void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                this.utils.readFloat(this.stream);
                ++i;
            }
        }
    }

    public static class LongTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        LongTreeReader(int columnId, boolean skipCorrupt) throws IOException {
            this(columnId, null, null, null, skipCorrupt);
        }

        protected LongTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding, boolean skipCorrupt) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = LongTreeReader.createIntegerReader(encoding.getKind(), data, true, skipCorrupt);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = LongTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector((ColumnVector)result, result.vector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    public static class IntTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        IntTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        protected IntTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = IntTreeReader.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = IntTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector((ColumnVector)result, result.vector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    public static class ShortTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        ShortTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        protected ShortTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = ShortTreeReader.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = ShortTreeReader.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector((ColumnVector)result, result.vector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    public static class ByteTreeReader
    extends TreeReader {
        protected RunLengthByteReader reader = null;

        ByteTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        protected ByteTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.reader = new RunLengthByteReader(data);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector((ColumnVector)result, result.vector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    public static class BooleanTreeReader
    extends TreeReader {
        protected BitFieldReader reader = null;

        BooleanTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        protected BooleanTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            if (data != null) {
                this.reader = new BitFieldReader(data, 1);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), 1);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            LongColumnVector result = (LongColumnVector)previousVector;
            super.nextVector((ColumnVector)result, isNull, batchSize);
            this.reader.nextVector(result, batchSize);
        }
    }

    public static class NullTreeReader
    extends TreeReader {
        public NullTreeReader(int columnId) throws IOException {
            super(columnId);
        }

        @Override
        public void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter footer) {
        }

        @Override
        void skipRows(long rows) {
        }

        @Override
        public void seek(PositionProvider position) {
        }

        @Override
        public void seek(PositionProvider[] position) {
        }

        @Override
        public void nextVector(ColumnVector vector, boolean[] isNull, int size) {
            vector.noNulls = false;
            vector.isNull[0] = true;
            vector.isRepeating = true;
        }
    }

    public static abstract class TreeReader {
        protected final int columnId;
        protected BitFieldReader present = null;
        protected boolean valuePresent = false;
        protected int vectorColumnCount;

        TreeReader(int columnId) throws IOException {
            this(columnId, null);
        }

        protected TreeReader(int columnId, InStream in) throws IOException {
            this.columnId = columnId;
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
            this.vectorColumnCount = -1;
        }

        void setVectorColumnCount(int vectorColumnCount) {
            this.vectorColumnCount = vectorColumnCount;
        }

        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        static IntegerReader createIntegerReader(OrcProto.ColumnEncoding.Kind kind, InStream in, boolean signed, boolean skipCorrupt) throws IOException {
            switch (kind) {
                case DIRECT_V2: 
                case DICTIONARY_V2: {
                    return new RunLengthIntegerReaderV2(in, signed, skipCorrupt);
                }
                case DIRECT: 
                case DICTIONARY: {
                    return new RunLengthIntegerReader(in, signed);
                }
            }
            throw new IllegalArgumentException("Unknown encoding " + (Object)((Object)kind));
        }

        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            this.checkEncoding(stripeFooter.getColumnsList().get(this.columnId));
            InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                this.present.seek(index);
            }
        }

        protected long countNonNulls(long rows) throws IOException {
            if (this.present != null) {
                long result = 0L;
                for (long c = 0L; c < rows; ++c) {
                    if (this.present.next() != 1) continue;
                    ++result;
                }
                return result;
            }
            return rows;
        }

        abstract void skipRows(long var1) throws IOException;

        public void nextBatch(VectorizedRowBatch batch, int batchSize) throws IOException {
            batch.cols[0].reset();
            batch.cols[0].ensureSize(batchSize, false);
            this.nextVector(batch.cols[0], null, batchSize);
        }

        public void nextVector(ColumnVector previous, boolean[] isNull, int batchSize) throws IOException {
            if (this.present != null || isNull != null) {
                previous.noNulls = true;
                boolean allNull = true;
                for (int i = 0; i < batchSize; ++i) {
                    if (isNull == null || !isNull[i]) {
                        if (this.present != null && this.present.next() != 1) {
                            previous.noNulls = false;
                            previous.isNull[i] = true;
                            continue;
                        }
                        previous.isNull[i] = false;
                        allNull = false;
                        continue;
                    }
                    previous.noNulls = false;
                    previous.isNull[i] = true;
                }
                previous.isRepeating = !previous.noNulls && allNull;
            } else {
                previous.noNulls = true;
                for (int i = 0; i < batchSize; ++i) {
                    previous.isNull[i] = false;
                }
            }
        }

        public BitFieldReader getPresent() {
            return this.present;
        }
    }
}

