/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hive.orc.impl.InStream;
import org.apache.hive.orc.impl.PositionProvider;

public class RunLengthByteReader {
    private InStream input;
    private final byte[] literals = new byte[128];
    private int numLiterals = 0;
    private int used = 0;
    private boolean repeat = false;

    public RunLengthByteReader(InStream input) throws IOException {
        this.input = input;
    }

    public void setInStream(InStream input) {
        this.input = input;
    }

    private void readValues(boolean ignoreEof) throws IOException {
        int control = this.input.read();
        this.used = 0;
        if (control == -1) {
            if (!ignoreEof) {
                throw new EOFException("Read past end of buffer RLE byte from " + this.input);
            }
            this.numLiterals = 0;
            this.used = 0;
            return;
        }
        if (control < 128) {
            this.repeat = true;
            this.numLiterals = control + 3;
            int val = this.input.read();
            if (val == -1) {
                throw new EOFException("Reading RLE byte got EOF");
            }
            this.literals[0] = (byte)val;
        } else {
            int result;
            this.repeat = false;
            this.numLiterals = 256 - control;
            for (int bytes = 0; bytes < this.numLiterals; bytes += result) {
                result = this.input.read(this.literals, bytes, this.numLiterals - bytes);
                if (result != -1) continue;
                throw new EOFException("Reading RLE byte literal got EOF in " + this);
            }
        }
    }

    public boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    public byte next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues(false);
        }
        byte result = this.repeat ? this.literals[0] : this.literals[this.used];
        ++this.used;
        return result;
    }

    public void nextVector(ColumnVector previous, long[] data, long size) throws IOException {
        previous.isRepeating = true;
        int i = 0;
        while ((long)i < size) {
            data[i] = !previous.isNull[i] ? (long)this.next() : 1L;
            if (previous.isRepeating && i > 0 && (data[0] != data[i] || previous.isNull[0] != previous.isNull[i])) {
                previous.isRepeating = false;
            }
            ++i;
        }
    }

    public void nextVector(boolean[] isNull, int[] data, long size) throws IOException {
        if (isNull == null) {
            int i = 0;
            while ((long)i < size) {
                data[i] = this.next();
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < size) {
                if (!isNull[i]) {
                    data[i] = this.next();
                }
                ++i;
            }
        }
    }

    public void seek(PositionProvider index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = (int)index.getNext(); consumed > 0; consumed -= this.numLiterals) {
                this.readValues(false);
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues(false);
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }

    public String toString() {
        return "byte rle " + (this.repeat ? "repeat" : "literal") + " used: " + this.used + "/" + this.numLiterals + " from " + this.input;
    }
}

