/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;
import org.apache.hadoop.hive.ql.parse.ImmutableCommonToken;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ASTNode
extends CommonTree
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient StringBuilder astStr;
    private transient ASTNodeOrigin origin;
    private transient int startIndx = -1;
    private transient int endIndx = -1;
    private transient ASTNode rootNode;
    private transient boolean isValidASTStr;
    private transient boolean visited = false;
    private transient TypeInfo typeInfo;
    private static final Interner<ImmutableCommonToken> TOKEN_CACHE = Interners.newWeakInterner();

    public ASTNode() {
    }

    public ASTNode(Token t) {
        super(ASTNode.internToken(t));
    }

    public ASTNode(ASTNode node) {
        super((CommonTree)node);
        this.origin = node.origin;
    }

    public Tree dupNode() {
        return new ASTNode(this);
    }

    public List<Node> getChildren() {
        if (super.getChildCount() == 0) {
            return null;
        }
        assert (this.children.get(0) instanceof Node);
        List nodeList = this.children;
        return Collections.unmodifiableList(nodeList);
    }

    public String getName() {
        return String.valueOf(super.getToken().getType());
    }

    public void setUnknownTokenBoundaries() {
        ASTNode next;
        ArrayDeque<ASTNode> stack1 = new ArrayDeque<ASTNode>();
        ArrayDeque<ASTNode> stack2 = new ArrayDeque<ASTNode>();
        stack1.push(this);
        while (!stack1.isEmpty()) {
            next = (ASTNode)stack1.pop();
            stack2.push(next);
            if (next.children == null) continue;
            for (int i = next.children.size() - 1; i >= 0; --i) {
                stack1.push((ASTNode)next.children.get(i));
            }
        }
        while (!stack2.isEmpty()) {
            next = (ASTNode)stack2.pop();
            if (next.children == null) {
                if (next.startIndex >= 0 && next.stopIndex >= 0) continue;
                next.startIndex = next.stopIndex = next.token.getTokenIndex();
                continue;
            }
            if (next.startIndex >= 0 && next.stopIndex >= 0 || next.children.size() <= 0) continue;
            ASTNode firstChild = (ASTNode)next.children.get(0);
            ASTNode lastChild = (ASTNode)next.children.get(next.children.size() - 1);
            next.startIndex = firstChild.getTokenStartIndex();
            next.stopIndex = lastChild.getTokenStopIndex();
        }
    }

    public ASTNodeOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(ASTNodeOrigin origin) {
        this.origin = origin;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("\n");
        this.dump(sb);
        return sb.toString();
    }

    private StringBuilder dump(StringBuilder sb) {
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
        stack.push(this);
        int tabLength = 0;
        while (!stack.isEmpty()) {
            ASTNode next = (ASTNode)stack.peek();
            if (!next.visited) {
                sb.append(StringUtils.repeat((String)" ", (int)(tabLength * 3)));
                sb.append(next.toString());
                sb.append("\n");
                if (next.children != null) {
                    for (int i = next.children.size() - 1; i >= 0; --i) {
                        stack.push((ASTNode)next.children.get(i));
                    }
                }
                ++tabLength;
                next.visited = true;
                continue;
            }
            --tabLength;
            next.visited = false;
            stack.pop();
        }
        return sb;
    }

    private void getRootNodeWithValidASTStr() {
        if (this.rootNode != null && this.rootNode.parent == null && this.rootNode.hasValidMemoizedString()) {
            return;
        }
        ASTNode retNode = this;
        while (retNode.parent != null) {
            retNode = (ASTNode)retNode.parent;
        }
        this.rootNode = retNode;
        if (!this.rootNode.isValidASTStr) {
            this.rootNode.astStr = new StringBuilder();
            this.rootNode.toStringTree(this.rootNode);
            this.rootNode.isValidASTStr = true;
        }
    }

    private boolean hasValidMemoizedString() {
        return this.isValidASTStr && this.astStr != null;
    }

    private void resetRootInformation() {
        if (this.rootNode != null) {
            this.rootNode.astStr = null;
            this.rootNode.isValidASTStr = false;
        }
    }

    private int getMemoizedStringLen() {
        return this.astStr == null ? 0 : this.astStr.length();
    }

    private String getMemoizedSubString(int start, int end) {
        return this.astStr == null || start < 0 || end > this.astStr.length() || start >= end ? null : this.astStr.subSequence(start, end).toString();
    }

    private void addtoMemoizedString(String string) {
        if (this.astStr == null) {
            this.astStr = new StringBuilder();
        }
        this.astStr.append(string);
    }

    public void setParent(Tree t) {
        super.setParent(t);
        this.resetRootInformation();
    }

    public void addChild(Tree t) {
        super.addChild(t);
        this.resetRootInformation();
    }

    public void addChildren(List kids) {
        super.addChildren(kids);
        this.resetRootInformation();
    }

    public void setChild(int i, Tree t) {
        super.setChild(i, t);
        this.resetRootInformation();
    }

    public void insertChild(int i, Object t) {
        super.insertChild(i, t);
        this.resetRootInformation();
    }

    public Object deleteChild(int i) {
        Object ret = super.deleteChild(i);
        this.resetRootInformation();
        return ret;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        super.replaceChildren(startChildIndex, stopChildIndex, t);
        this.resetRootInformation();
    }

    protected List createChildrenList() {
        return new ArrayList(2);
    }

    public String toStringTree() {
        this.getRootNodeWithValidASTStr();
        if (this.startIndx >= 0 && this.endIndx <= this.rootNode.getMemoizedStringLen()) {
            return this.rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
        }
        return this.toStringTree(this.rootNode);
    }

    private String toStringTree(ASTNode rootNode) {
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            ASTNode next = (ASTNode)stack.peek();
            if (!next.visited) {
                String str;
                if (next.parent != null && next.parent.getChildCount() > 1 && next != next.parent.getChild(0)) {
                    rootNode.addtoMemoizedString(" ");
                }
                next.rootNode = rootNode;
                next.startIndx = rootNode.getMemoizedStringLen();
                if (next.children == null || next.children.size() == 0) {
                    str = next.toString();
                    rootNode.addtoMemoizedString(next.getType() != 416 ? str.toLowerCase() : str);
                    next.endIndx = rootNode.getMemoizedStringLen();
                    stack.pop();
                    continue;
                }
                if (!next.isNil()) {
                    rootNode.addtoMemoizedString("(");
                    str = next.toString();
                    rootNode.addtoMemoizedString(next.getType() == 416 || null == str ? str : str.toLowerCase());
                    rootNode.addtoMemoizedString(" ");
                }
                if (next.children != null) {
                    for (int i = next.children.size() - 1; i >= 0; --i) {
                        stack.push((ASTNode)next.children.get(i));
                    }
                }
                next.visited = true;
                continue;
            }
            if (!next.isNil()) {
                rootNode.addtoMemoizedString(")");
            }
            next.endIndx = rootNode.getMemoizedStringLen();
            next.visited = false;
            stack.pop();
        }
        return rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
    }

    private static Token internToken(Token t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ImmutableCommonToken) {
            return (Token)TOKEN_CACHE.intern((Object)((ImmutableCommonToken)t));
        }
        t.setText(StringInternUtils.internIfNotNull((String)t.getText()));
        return t;
    }
}

