/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hive.service.cli.Handle;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.thrift.TOperationHandle;

public class OperationHandle
extends Handle {
    private OperationType opType = OperationType.EXECUTE_STATEMENT;
    private boolean hasResultSet = false;

    public OperationHandle() {
    }

    public OperationHandle(OperationType opType) {
        this.opType = opType;
    }

    public OperationHandle(TOperationHandle tOperationHandle) {
        super(tOperationHandle.getOperationId());
        this.opType = OperationType.getOperationType(tOperationHandle.getOperationType());
        this.hasResultSet = tOperationHandle.isHasResultSet();
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public TOperationHandle toTOperationHandle() {
        TOperationHandle tOperationHandle = new TOperationHandle();
        tOperationHandle.setOperationId(this.getHandleIdentifier().toTHandleIdentifier());
        tOperationHandle.setOperationType(this.opType.toTOperationType());
        tOperationHandle.setHasResultSet(this.hasResultSet);
        return tOperationHandle;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.opType == null ? 0 : this.opType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OperationHandle)) {
            return false;
        }
        OperationHandle other = (OperationHandle)obj;
        return this.opType == other.opType;
    }

    @Override
    public String toString() {
        return "OperationHandle [opType=" + (Object)((Object)this.opType) + ", getHandleIdentifier()=" + this.getHandleIdentifier() + "]";
    }
}

