/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import com.google.common.base.Strings;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.Query;

public final class QueryFactory {
    private final String guidAttr;
    private final String groupClassAttr;
    private final String groupMembershipAttr;

    public QueryFactory(HiveConf conf) {
        this.guidAttr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GUIDKEY);
        this.groupClassAttr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPCLASS_KEY);
        this.groupMembershipAttr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPMEMBERSHIP_KEY);
    }

    public Query findGroupDnById(String groupId) {
        return Query.builder().filter("(&(objectClass=<groupClassAttr>)(<guidAttr>=<groupID>))").map("guidAttr", this.guidAttr).map("groupClassAttr", this.groupClassAttr).map("groupID", groupId).limit(2).build();
    }

    public Query findUserDnByRdn(String userRdn) {
        return Query.builder().filter("(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(<userRdn>))").limit(2).map("userRdn", userRdn).build();
    }

    public Query findDnByPattern(String rdn) {
        return Query.builder().filter("(<rdn>)").map("rdn", rdn).limit(2).build();
    }

    public Query findUserDnByName(String userName) {
        return Query.builder().filter("(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(|(uid=<userName>)(sAMAccountName=<userName>)))").map("userName", userName).limit(2).build();
    }

    public Query findGroupsForUser(String userName, String userDn) {
        return Query.builder().filter("(&(objectClass=<groupClassAttr>)(|(<groupMembershipAttr>=<userDn>)(<groupMembershipAttr>=<userName>)))").map("groupClassAttr", this.groupClassAttr).map("groupMembershipAttr", this.groupMembershipAttr).map("userName", userName).map("userDn", userDn).build();
    }

    public Query customQuery(String searchFilter) {
        Query.QueryBuilder builder = Query.builder();
        builder.filter(searchFilter);
        if (!Strings.isNullOrEmpty((String)this.groupMembershipAttr)) {
            builder.returnAttribute(this.groupMembershipAttr);
        }
        return builder.build();
    }
}

