/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Operation {
    public static final String SESSIONID_LOG_KEY = "sessionId";
    public static final String QUERYID_LOG_KEY = "queryId";
    protected final HiveSession parentSession;
    private volatile OperationState state = OperationState.INITIALIZED;
    private volatile MetricsScope currentStateScope;
    private final OperationHandle opHandle;
    public static final FetchOrientation DEFAULT_FETCH_ORIENTATION = FetchOrientation.FETCH_NEXT;
    public static final Logger LOG = LoggerFactory.getLogger((String)Operation.class.getName());
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;
    protected volatile HiveSQLException operationException;
    protected volatile Future<?> backgroundHandle;
    protected OperationLog operationLog;
    protected boolean isOperationLogEnabled;
    protected Map<String, String> confOverlay = new HashMap<String, String>();
    private long operationTimeout;
    private volatile long lastAccessTime;
    private final long beginTime;
    protected long operationStart;
    protected long operationComplete;
    protected final QueryState queryState;
    protected static final EnumSet<FetchOrientation> DEFAULT_FETCH_ORIENTATION_SET = EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST);
    protected static Set<OperationState> scopeStates = Sets.immutableEnumSet((Enum)OperationState.INITIALIZED, (Enum[])new OperationState[]{OperationState.PENDING, OperationState.RUNNING});
    protected static Set<OperationState> terminalStates = Sets.immutableEnumSet((Enum)OperationState.CLOSED, (Enum[])new OperationState[]{OperationState.CANCELED, OperationState.FINISHED, OperationState.ERROR, OperationState.UNKNOWN});

    protected Operation(HiveSession parentSession, OperationType opType) {
        this(parentSession, null, opType);
    }

    protected Operation(HiveSession parentSession, Map<String, String> confOverlay, OperationType opType) {
        this(parentSession, confOverlay, opType, false);
    }

    protected Operation(HiveSession parentSession, Map<String, String> confOverlay, OperationType opType, boolean isAsyncQueryState) {
        this.parentSession = parentSession;
        if (confOverlay != null) {
            this.confOverlay = confOverlay;
        }
        this.opHandle = new OperationHandle(opType, parentSession.getProtocolVersion());
        this.lastAccessTime = this.beginTime = System.currentTimeMillis();
        this.operationTimeout = HiveConf.getTimeVar((Configuration)parentSession.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.setMetrics(this.state);
        this.queryState = new QueryState(parentSession.getHiveConf(), confOverlay, isAsyncQueryState);
    }

    public Future<?> getBackgroundHandle() {
        return this.backgroundHandle;
    }

    protected void setBackgroundHandle(Future<?> backgroundHandle) {
        this.backgroundHandle = backgroundHandle;
    }

    public boolean shouldRunAsync() {
        return false;
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.opHandle.getProtocolVersion();
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationStatus getStatus() {
        String taskStatus = null;
        try {
            taskStatus = this.getTaskStatus();
        }
        catch (HiveSQLException sqlException) {
            LOG.error("Error getting task status for " + this.opHandle.toString(), (Throwable)sqlException);
        }
        return new OperationStatus(this.state, taskStatus, this.operationStart, this.operationComplete, this.operationException);
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    public OperationLog getOperationLog() {
        return this.operationLog;
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        OperationState prevState = this.state;
        this.state = newState;
        this.setMetrics(this.state);
        this.onNewState(this.state, prevState);
        this.lastAccessTime = System.currentTimeMillis();
        return this.state;
    }

    public boolean isTimedOut(long current) {
        if (this.operationTimeout == 0L) {
            return false;
        }
        if (this.operationTimeout > 0L) {
            return this.state.isTerminal() && this.lastAccessTime + this.operationTimeout <= current;
        }
        return this.lastAccessTime + -this.operationTimeout <= current;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    protected void setOperationException(HiveSQLException operationException) {
        this.operationException = operationException;
    }

    protected final void assertState(List<OperationState> states) throws HiveSQLException {
        if (!states.contains((Object)this.state)) {
            throw new HiveSQLException("Expected states: " + states.toString() + ", but found " + (Object)((Object)this.state));
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isRunning() {
        return OperationState.RUNNING.equals((Object)this.state);
    }

    public boolean isFinished() {
        return OperationState.FINISHED.equals((Object)this.state);
    }

    public boolean isCanceled() {
        return OperationState.CANCELED.equals((Object)this.state);
    }

    public boolean isFailed() {
        return OperationState.ERROR.equals((Object)this.state);
    }

    protected void createOperationLog() {
        if (this.parentSession.isOperationLogEnabled()) {
            File operationLogFile = new File(this.parentSession.getOperationLogSessionDir(), this.opHandle.getHandleIdentifier().toString());
            this.isOperationLogEnabled = true;
            try {
                if (operationLogFile.exists()) {
                    LOG.warn("The operation log file should not exist, but it is already there: " + operationLogFile.getAbsolutePath());
                    operationLogFile.delete();
                }
                if (!(operationLogFile.createNewFile() || operationLogFile.canRead() && operationLogFile.canWrite())) {
                    LOG.warn("The already existed operation log file cannot be recreated, and it cannot be read or written: " + operationLogFile.getAbsolutePath());
                    this.isOperationLogEnabled = false;
                    return;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to create operation log file: " + operationLogFile.getAbsolutePath(), (Throwable)e);
                this.isOperationLogEnabled = false;
                return;
            }
            try {
                this.operationLog = new OperationLog(this.opHandle.toString(), operationLogFile, this.parentSession.getHiveConf());
            }
            catch (FileNotFoundException e) {
                LOG.warn("Unable to instantiate OperationLog object for operation: " + this.opHandle, (Throwable)e);
                this.isOperationLogEnabled = false;
                return;
            }
            OperationLog.setCurrentOperationLog((OperationLog)this.operationLog);
        }
    }

    protected void unregisterOperationLog() {
        if (this.isOperationLogEnabled) {
            OperationLog.removeCurrentOperationLog();
        }
    }

    protected void beforeRun() {
        this.createOperationLog();
        this.registerLoggingContext();
    }

    protected void registerLoggingContext() {
        ThreadContext.put((String)SESSIONID_LOG_KEY, (String)SessionState.get().getSessionId());
        ThreadContext.put((String)QUERYID_LOG_KEY, (String)this.confOverlay.get(HiveConf.ConfVars.HIVEQUERYID.varname));
    }

    protected void unregisterLoggingContext() {
        ThreadContext.clearAll();
    }

    protected void afterRun() {
        this.unregisterLoggingContext();
        this.unregisterOperationLog();
    }

    protected abstract void runInternal() throws HiveSQLException;

    public void run() throws HiveSQLException {
        this.beforeRun();
        try {
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.incrementCounter("open_operations");
                }
                catch (Exception e) {
                    LOG.warn("Error Reporting open operation to Metrics system", (Throwable)e);
                }
            }
            this.runInternal();
        }
        finally {
            this.afterRun();
        }
    }

    protected synchronized void cleanupOperationLog() {
        if (this.isOperationLogEnabled) {
            if (this.opHandle == null) {
                LOG.warn("Operation seems to be in invalid state, opHandle is null");
                return;
            }
            if (this.operationLog == null) {
                LOG.warn("Operation [ " + this.opHandle.getHandleIdentifier() + " ] logging is enabled, but its OperationLog object cannot be found. Perhaps the operation has already terminated.");
            } else {
                this.operationLog.close();
            }
        }
    }

    public abstract void cancel(OperationState var1) throws HiveSQLException;

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }

    public String getTaskStatus() throws HiveSQLException {
        return null;
    }

    protected void validateDefaultFetchOrientation(FetchOrientation orientation) throws HiveSQLException {
        this.validateFetchOrientation(orientation, DEFAULT_FETCH_ORIENTATION_SET);
    }

    protected void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        if (!supportedOrientations.contains((Object)orientation)) {
            throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
        }
    }

    protected HiveSQLException toSQLException(String prefix, CommandProcessorResponse response) {
        HiveSQLException ex = new HiveSQLException(prefix + ": " + response.getErrorMessage(), response.getSQLState(), response.getResponseCode());
        if (response.getException() != null) {
            ex.initCause(response.getException());
        }
        return ex;
    }

    private void setMetrics(OperationState state) {
        this.currentStateScope = Operation.setMetrics(this.currentStateScope, "hs2_operation_", "hs2_completed_operation_", state);
    }

    protected static MetricsScope setMetrics(MetricsScope stateScope, String operationPrefix, String completedOperationPrefix, OperationState state) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                if (stateScope != null) {
                    metrics.endScope(stateScope);
                    stateScope = null;
                }
                if (scopeStates.contains((Object)state)) {
                    stateScope = metrics.createScope(operationPrefix + (Object)((Object)state));
                }
                if (terminalStates.contains((Object)state)) {
                    metrics.incrementCounter(completedOperationPrefix + (Object)((Object)state));
                }
            }
            catch (IOException e) {
                LOG.warn("Error metrics", (Throwable)e);
            }
        }
        return stateScope;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected OperationState getState() {
        return this.state;
    }

    protected void onNewState(OperationState state, OperationState prevState) {
        switch (state) {
            case RUNNING: {
                this.markOperationStartTime();
                break;
            }
            case ERROR: 
            case FINISHED: 
            case CANCELED: {
                this.markOperationCompletedTime();
            }
        }
    }

    public long getOperationComplete() {
        return this.operationComplete;
    }

    public long getOperationStart() {
        return this.operationStart;
    }

    protected void markOperationStartTime() {
        this.operationStart = System.currentTimeMillis();
    }

    protected void markOperationCompletedTime() {
        this.operationComplete = System.currentTimeMillis();
    }
}

