/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.AuthType;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.saml.HiveSamlHttpServlet;
import org.apache.hive.service.auth.saml.HiveSamlUtils;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpFilter;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThriftHttpCLIService
extends ThriftCLIService {
    private static final String APPLICATION_THRIFT = "application/x-thrift";
    protected Server server;

    public ThriftHttpCLIService(CLIService cliService) {
        super(cliService, ThriftHttpCLIService.class.getSimpleName());
    }

    @Override
    protected HiveServer2TransportMode getTransportMode() {
        return HiveServer2TransportMode.http;
    }

    @Override
    protected void initServer() {
        try {
            ServerConnector connector;
            String schemeName;
            String threadPoolName = "HiveServer2-HttpHandler-Pool";
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue(), new ThreadFactoryWithGarbageCleanup(threadPoolName)){

                @Override
                public void setThreadFactory(ThreadFactory threadFactory) {
                    ThriftCLIService.LOG.warn("Ignore setting the thread factory as the pool has already provided his own: {}", (Object)this.getThreadFactory());
                }
            };
            ExecutorThreadPool threadPool = new ExecutorThreadPool(executorService);
            this.server = new Server((ThreadPool)threadPool);
            HttpConfiguration conf = new HttpConfiguration();
            int requestHeaderSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_REQUEST_HEADER_SIZE);
            int responseHeaderSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_RESPONSE_HEADER_SIZE);
            conf.setRequestHeaderSize(requestHeaderSize);
            conf.setResponseHeaderSize(responseHeaderSize);
            HttpConnectionFactory http = new HttpConnectionFactory(conf){

                public Connection newConnection(Connector connector, EndPoint endPoint) {
                    Connection connection = super.newConnection(connector, endPoint);
                    connection.addListener(new Connection.Listener(){

                        public void onOpened(Connection connection) {
                            ThriftHttpCLIService.this.openConnection();
                        }

                        public void onClosed(Connection connection) {
                            ThriftHttpCLIService.this.closeConnection();
                        }
                    });
                    return connection;
                }
            };
            boolean useSsl = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                HashSet excludeCS;
                int eSize;
                String keyStoreAlgorithm;
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword((Configuration)this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                String keyStoreType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_TYPE).trim();
                if (keyStoreType.isEmpty()) {
                    keyStoreType = KeyStore.getDefaultType();
                }
                if ((keyStoreAlgorithm = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYMANAGERFACTORY_ALGORITHM).trim()).isEmpty()) {
                    keyStoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                }
                SslContextFactory sslContextFactory = new SslContextFactory();
                Object[] excludedProtocols = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",");
                LOG.info("HTTP Server SSL: adding excluded protocols: " + Arrays.toString(excludedProtocols));
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols);
                LOG.info("HTTP Server SSL: SslContextFactory.getExcludeProtocols = " + Arrays.toString(sslContextFactory.getExcludeProtocols()));
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                sslContextFactory.setKeyStoreType(keyStoreType);
                sslContextFactory.setKeyManagerFactoryAlgorithm(keyStoreAlgorithm);
                String excludeCiphersuites = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_HTTP_EXCLUDE_CIPHERSUITES).trim();
                if (!excludeCiphersuites.trim().isEmpty() && (eSize = (excludeCS = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)excludeCiphersuites.trim()))).size()) > 0) {
                    sslContextFactory.setExcludeCipherSuites(excludeCS.toArray(new String[eSize]));
                }
                connector = new ServerConnector(this.server, sslContextFactory, new ConnectionFactory[]{http});
            } else {
                connector = new ServerConnector(this.server, new ConnectionFactory[]{http});
            }
            connector.setPort(this.portNum);
            connector.setReuseAddress(true);
            int maxIdleTime = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME, TimeUnit.MILLISECONDS);
            connector.setIdleTimeout((long)maxIdleTime);
            connector.setAcceptQueueSize(this.maxWorkerThreads);
            this.server.addConnector((Connector)connector);
            this.hiveAuthFactory = new HiveAuthFactory(this.hiveConf, true);
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            UserGroupInformation serviceUGI = this.cliService.getServiceUGI();
            UserGroupInformation httpUGI = this.cliService.getHttpUGI();
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, serviceUGI, httpUGI, this.hiveAuthFactory, this.hiveConf);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            if (this.hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false)) {
                LOG.debug("XSRF filter enabled");
            } else {
                LOG.warn("XSRF filter disabled");
            }
            String httpPath = this.getHttpPath(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
            if (HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COMPRESSION_ENABLED)) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{"POST"});
                gzipHandler.addIncludedMimeTypes(new String[]{APPLICATION_THRIFT});
                this.server.setHandler((Handler)gzipHandler);
            } else {
                this.server.setHandler((Handler)context);
            }
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            if (this.isHttpFilteringEnabled(this.hiveConf)) {
                ThriftHttpFilter thriftHttpFilter = new ThriftHttpFilter(this.hiveConf);
                context.addFilter(new FilterHolder((Filter)thriftHttpFilter), httpPath, EnumSet.of(DispatcherType.REQUEST));
            }
            if (AuthType.isSamlAuthMode((Configuration)this.hiveConf)) {
                String ssoPath = HiveSamlUtils.getCallBackPath(this.hiveConf);
                context.addServlet(new ServletHolder((Servlet)new HiveSamlHttpServlet(this.hiveConf)), ssoPath);
            }
            this.constrainHttpMethods(context, false);
            this.server.start();
            String msg = "Started " + ThriftHttpCLIService.class.getSimpleName() + " in " + schemeName + " mode on port " + this.portNum + " path=" + httpPath + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init HttpServer", e);
        }
    }

    private void openConnection() {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                metrics.incrementCounter("open_connections");
                metrics.incrementCounter("cumulative_connection_count");
            }
            catch (Exception e) {
                LOG.warn("Error reporting HS2 open connection operation to Metrics system", (Throwable)e);
            }
        }
    }

    private void closeConnection() {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                metrics.decrementCounter("open_connections");
            }
            catch (Exception e) {
                LOG.warn("Error reporting HS2 close connection operation to Metrics system", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.server.join();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                LOG.info("Caught " + t.getClass().getSimpleName() + ". Shutting down thrift server.");
            }
            LOG.error("Exception caught by " + ThriftHttpCLIService.class.getSimpleName() + ". Exiting.", t);
            System.exit(-1);
        }
    }

    private String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }

    public boolean isHttpFilteringEnabled(HiveConf hiveConf) {
        return hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false) || hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, false);
    }

    public void constrainHttpMethods(ServletContextHandler ctxHandler, boolean allowOptionsMethod) {
        Constraint c = new Constraint();
        c.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(c);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        if (!allowOptionsMethod) {
            ConstraintMapping cmo = new ConstraintMapping();
            cmo.setConstraint(c);
            cmo.setMethod("OPTIONS");
            cmo.setPathSpec("/*");
            securityHandler.setConstraintMappings(new ConstraintMapping[]{cmt, cmo});
        } else {
            securityHandler.setConstraintMappings(new ConstraintMapping[]{cmt});
        }
        ctxHandler.setSecurityHandler((SecurityHandler)securityHandler);
    }

    @Override
    protected void stopServer() {
        if (this.server != null && this.server.isStarted()) {
            try {
                this.server.stop();
                this.server = null;
                LOG.info("Thrift HTTP server has been stopped");
            }
            catch (Exception e) {
                LOG.error("Error stopping HTTP server: ", (Throwable)e);
            }
        }
    }
}

