/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;

public class HiveSQLException
extends SQLException {
    private static final long serialVersionUID = -6095254671958748095L;
    @VisibleForTesting
    public static final List<String> DEFAULT_INFO = Collections.singletonList("Server-side error; please check HS2 logs.");

    public HiveSQLException() {
    }

    public HiveSQLException(String reason) {
        super(reason);
    }

    public HiveSQLException(Throwable cause) {
        super(cause);
    }

    public HiveSQLException(String reason, String sqlState) {
        super(reason, sqlState);
    }

    public HiveSQLException(String reason, Throwable cause) {
        super(reason, cause);
    }

    public HiveSQLException(String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
    }

    public HiveSQLException(String reason, String sqlState, Throwable cause) {
        super(reason, sqlState, cause);
    }

    public HiveSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
    }

    public HiveSQLException(TStatus status) {
        super(status.getErrorMessage(), status.getSqlState(), status.getErrorCode());
    }

    public TStatus toTStatus() {
        TStatus tStatus = new TStatus(TStatusCode.ERROR_STATUS);
        tStatus.setSqlState(this.getSQLState());
        tStatus.setErrorCode(this.getErrorCode());
        tStatus.setErrorMessage(this.getMessage());
        tStatus.setInfoMessages(DEFAULT_INFO);
        return tStatus;
    }

    public static TStatus toTStatus(Exception e) {
        if (e instanceof HiveSQLException) {
            return ((HiveSQLException)e).toTStatus();
        }
        TStatus tStatus = new TStatus(TStatusCode.ERROR_STATUS);
        tStatus.setErrorMessage(e.getMessage());
        tStatus.setInfoMessages(DEFAULT_INFO);
        return tStatus;
    }
}

