// Autogenerated Jamon implementation
// /Users/zdeng/workspace/github/hive/service/src/jamon/org/apache/hive/tmpl/QueryProfileTmpl.jamon

package org.apache.hive.tmpl;

// 24, 1
import java.util.*;
// 25, 1
import org.apache.hadoop.hive.ql.QueryDisplay;
// 26, 1
import org.apache.hadoop.hive.ql.QueryInfo;
// 27, 1
import org.apache.hadoop.hive.conf.HiveConf;
// 28, 1
import org.apache.hive.service.cli.operation.OperationLogManager;

public class QueryProfileTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hive.tmpl.QueryProfileTmpl.Intf

{
  private final QueryInfo queryInfo;
  private final HiveConf hiveConf;
  // 30, 1
  
private boolean showGraph = false;
private boolean showStats = false;

  protected static org.apache.hive.tmpl.QueryProfileTmpl.ImplData __jamon_setOptionalArguments(org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public QueryProfileTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    queryInfo = p_implData.getQueryInfo();
    hiveConf = p_implData.getHiveConf();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 34, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HiveServer2</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hive.css\" rel=\"stylesheet\">\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    ");
    // 52, 5
    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_GRAPH) &&
      hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT) )
    {
      // 53, 82
      jamonWriter.write("\n      ");
      // 54, 7
      showGraph = true; 
      // 55, 7
      if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_STATS) )
      {
        // 55, 83
        jamonWriter.write("\n        ");
        // 56, 9
        showStats = true; 
      }
      // 57, 13
      jamonWriter.write("\n    ");
    }
    // 58, 11
    jamonWriter.write("\n    ");
    // 59, 5
    if (showGraph )
    {
      // 59, 22
      jamonWriter.write("\n      <script type=\"text/javascript\" src=\"/static/js/vis.min.js\"></script>\n      <link href=\"/static/css/query-plan-graph.css\" rel=\"stylesheet\">\n      <script src=\"/static/js/query-plan-graph.js\"></script>\n    ");
    }
    // 63, 11
    jamonWriter.write("\n  </head>\n\n  <body>\n  <div class=\"navbar  navbar-fixed-top navbar-default\">\n      <div class=\"container\">\n          <div class=\"navbar-header\">\n              <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n              </button>\n              <a class=\"navbar-brand\" href=\"/hiveserver2.jsp\"><img src=\"/static/hive_logo.jpeg\" alt=\"Hive Logo\"/></a>\n          </div>\n          <div class=\"collapse navbar-collapse\">\n              <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/conf\">Hive Configuration</a></li>\n                <li><a href=\"/stacks\">Stack Trace</a></li>\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n\n    ");
    // 91, 5
    if (queryInfo == null )
    {
      // 91, 30
      jamonWriter.write("\n         <div class=\"jumbotron\">\n           <p>Query not found.  It may have been deleted, increase <i>hive.server2.webui.max.historic.queries</i>\n              to retain more historic query information.</p>\n         </div>\n    ");
    }
    // 96, 5
    else
    {
      // 96, 12
      jamonWriter.write("\n\n\n    <div class=\"container\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Query Information: ");
      // 102, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
      // 102, 134
      jamonWriter.write("</h1>\n        </div>\n      </div>\n      <div class=\"row\">\n\n\n      <div class=\"tabbable\">\n          <ul class=\"nav nav-pills\">\n              <li class=\"active\"><a href=\"#tab_baseProfile\" data-toggle=\"tab\">Base Profile</a></li>\n              <li class=\"\"><a href=\"#tab_stages\" data-toggle=\"tab\">Stages</a></li>\n              <li class=\"\"><a href=\"#tab_queryPlan\" data-toggle=\"tab\">Query Plan</a></li>\n              <li class=\"\"><a href=\"#tab_perfLogging\" data-toggle=\"tab\">Performance Logging</a></li>\n              <li class=\"\"><a href=\"#tab_operationLog\" data-toggle=\"tab\">Operation Log</a></li>\n          </ul>\n          <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n              <div class=\"tab-pane active\" id=\"tab_baseProfile\">\n                  ");
      // 118, 19
      {
        // 118, 19
        __jamon_innerUnit__baseProfile(jamonWriter, queryInfo );
      }
      // 118, 59
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_stages\">\n                  ");
      // 121, 19
      {
        // 121, 19
        __jamon_innerUnit__stages(jamonWriter, queryInfo );
      }
      // 121, 54
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_queryPlan\">\n                  ");
      // 124, 19
      {
        // 124, 19
        __jamon_innerUnit__queryPlan(jamonWriter, queryInfo );
      }
      // 124, 57
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_perfLogging\">\n                  ");
      // 127, 19
      {
        // 127, 19
        __jamon_innerUnit__perfLogging(jamonWriter, queryInfo );
      }
      // 127, 59
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_operationLog\">\n                  ");
      // 130, 19
      {
        // 130, 19
        __jamon_innerUnit__operationLog(jamonWriter, queryInfo );
      }
      // 130, 60
      jamonWriter.write("\n              </div>\n          </div>\n      </div>\n\n   ");
    }
    // 135, 10
    jamonWriter.write("\n\n</div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n\n");
    // 288, 1
    if (showGraph )
    {
      // 288, 18
      jamonWriter.write("\n  <script type=\"text/javascript\">\n    // reload network to centralize graph upon switching to \"Query Plan\" tab\n    $('a[data-toggle=\"tab\"]').on('shown.bs.tab', function (e) {\n      if (e.target.toString().includes(\"queryPlan\") && typeof network !== 'undefined') {\n        network.fit();\n      }\n    });\n  </script>\n");
    }
    // 297, 7
    jamonWriter.write("\n\n\n</div>\n</div>\n</body>\n</html>\n");
  }
  
  
  // 145, 1
  private void __jamon_innerUnit__baseProfile(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 149, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <td>User Name</td>\n            <td>");
    // 152, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getUserName()), jamonWriter);
    // 152, 46
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Query String</td>\n            <td>");
    // 156, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
    // 156, 117
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Id</td>\n            <td>");
    // 160, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryId()), jamonWriter);
    // 160, 113
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Execution Engine</td>\n            <td>");
    // 164, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getExecutionEngine()), jamonWriter);
    // 164, 53
    jamonWriter.write("\n        </tr>\n        <tr>\n            <td>State</td>\n            <td>");
    // 168, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getState()), jamonWriter);
    // 168, 43
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened Timestamp</td>\n            <td>");
    // 172, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(queryInfo.getBeginTime())), jamonWriter);
    // 172, 57
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened (s)</td>\n            <td>");
    // 176, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getElapsedTime()/1000), jamonWriter);
    // 176, 54
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Closed Timestamp</td>\n            <td>");
    // 180, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getEndTime() == null ? "Open" : new Date(queryInfo.getEndTime())), jamonWriter);
    // 180, 97
    jamonWriter.write("</td>\n        </tr>\n        ");
    // 182, 9
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getErrorMessage() != null )
    {
      // 182, 109
      jamonWriter.write("\n            <tr>\n                <td>Error</td>\n                <td>");
      // 185, 21
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getErrorMessage()), jamonWriter);
      // 185, 72
      jamonWriter.write("</td>\n            </tr>\n        ");
    }
    // 187, 15
    jamonWriter.write("\n        <tr>\n            <td>Latency (s)</td>\n            <td>");
    // 190, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getRuntime() == null ? "Not finished" : queryInfo.getRuntime()/1000), jamonWriter);
    // 190, 100
    jamonWriter.write("</td>\n        </tr>\n    </table>\n");
  }
  
  
  // 381, 1
  private void __jamon_innerUnit__operationLog(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 385, 1
    jamonWriter.write("<div class=\"panel panel-default\">\n     <pre> ");
    // 386, 12
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(OperationLogManager.getOperationLog(queryInfo)), jamonWriter);
    // 386, 64
    jamonWriter.write("</pre>\n</div>\n");
  }
  
  
  // 195, 1
  private void __jamon_innerUnit__stages(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 199, 4
    jamonWriter.write("<table class=\"table table-striped\">\n       <tr>\n           <th>Stage Id</th>\n           <th>Status</th>\n           <th>Begin Time</th>\n           <th>End Time</th>\n           <th>Elapsed Time (s)</th>\n           <th>Requires Lock</th>\n        </tr>\n\n       ");
    // 209, 8
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getTaskDisplays() != null )
    {
      // 209, 108
      jamonWriter.write("\n           ");
      // 210, 12
      for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays() )
      {
        // 210, 105
        jamonWriter.write("\n               <tr>\n                   <td>");
        // 212, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId() + ":" + taskDisplay.getTaskType()), jamonWriter);
        // 212, 87
        jamonWriter.write("</td>\n                   <td>");
        // 213, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatus()), jamonWriter);
        // 213, 53
        jamonWriter.write("</td>\n                   <td>");
        // 214, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getBeginTime() == null ? "" : new Date(taskDisplay.getBeginTime())), jamonWriter);
        // 214, 108
        jamonWriter.write("</td>\n                   <td>");
        // 215, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getEndTime() == null ? "" : new Date(taskDisplay.getEndTime())), jamonWriter);
        // 215, 104
        jamonWriter.write("</td>\n                   <td>");
        // 216, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getElapsedTime() == null ? "" : taskDisplay.getElapsedTime()/1000), jamonWriter);
        // 216, 107
        jamonWriter.write(" (s) </td>\n                   <td>");
        // 217, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.isRequireLock()), jamonWriter);
        // 217, 57
        jamonWriter.write("</td>\n               </tr>\n           ");
      }
      // 219, 19
      jamonWriter.write("\n       ");
    }
    // 220, 14
    jamonWriter.write("\n   </table>\n");
  }
  
  
  // 225, 1
  private void __jamon_innerUnit__queryPlan(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 229, 5
    jamonWriter.write("<div class=\"panel panel-default\">\n      <div class=\"panel-heading\">Explain plan</div>\n      <div class=\"panel-body\">\n        ");
    // 232, 9
    if (showGraph )
    {
      // 232, 26
      jamonWriter.write("\n          ");
      // 233, 11
      if (queryInfo.getQueryDisplay() != null &&
                queryInfo.getQueryDisplay().getExplainPlan() != null &&
                !queryInfo.getQueryDisplay().getExplainPlan().equals("UNKNOWN"))
      {
        // 235, 82
        jamonWriter.write("\n            <div id='plan-visualization'></div>\n            ");
        // 237, 13
        if (showStats )
        {
          // 237, 30
          jamonWriter.write("\n              <div class=\"row\">\n                <div class=\"col-md-6\">\n                  <pre id='stage-info'></pre>\n                </div>\n                <div class=\"col-md-6\">\n                  <pre id='statistics-info'><div id='statistics-info-head'></div><div id='statistics-info-body'></div></pre>\n                </div>\n              </div>\n            ");
        }
        // 246, 13
        else
        {
          // 246, 20
          jamonWriter.write("\n              <pre id='stage-info'></pre>\n            ");
        }
        // 248, 19
        jamonWriter.write("\n            <script type=\"text/javascript\">\n              var jsonPlan = ");
        // 250, 30
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
        // 250, 80
        jamonWriter.write("\n              var jsonStatuses = {};\n              var jsonStatistics = {};\n              var jsonLogs = {};\n              ");
        // 254, 15
        if (queryInfo.getOperationLogLocation() != null )
        {
          // 254, 66
          jamonWriter.write("\n                jsonLogs[\"Operation Log - will be deleted after query completes\"] = \"");
          // 255, 86
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getOperationLogLocation()), jamonWriter);
          // 255, 127
          jamonWriter.write("\"\n              ");
        }
        // 256, 21
        jamonWriter.write("\n              ");
        // 257, 15
        if (queryInfo.getQueryDisplay().getFullLogLocation() != null )
        {
          // 257, 79
          jamonWriter.write("\n                jsonLogs[\"Full Log\"] = \"");
          // 258, 41
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getFullLogLocation()), jamonWriter);
          // 258, 95
          jamonWriter.write("\"\n              ");
        }
        // 259, 21
        jamonWriter.write("\n              ");
        // 260, 15
        for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays() )
        {
          // 260, 108
          jamonWriter.write("\n                jsonStatuses[\"");
          // 261, 31
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId()), jamonWriter);
          // 261, 60
          jamonWriter.write("\"] = \"");
          // 261, 66
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatus()), jamonWriter);
          // 261, 95
          jamonWriter.write("\";\n                ");
          // 262, 17
          if (showStats && taskDisplay.getStatsJsonString() != null )
          {
            // 262, 78
            jamonWriter.write("\n                  jsonStatistics[\"");
            // 263, 35
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId()), jamonWriter);
            // 263, 64
            jamonWriter.write("\"] = ");
            // 263, 69
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatsJsonString()), jamonWriter);
            // 263, 107
            jamonWriter.write(";\n                ");
          }
          // 264, 23
          jamonWriter.write("\n              ");
        }
        // 265, 22
        jamonWriter.write("\n              const MAP_PROGRESS = '");
        // 266, 37
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(QueryDisplay.TaskDisplay.MAP_PROGRESS), jamonWriter);
        // 266, 80
        jamonWriter.write("';\n              const REDUCE_PROGRESS = '");
        // 267, 40
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(QueryDisplay.TaskDisplay.REDUCE_PROGRESS), jamonWriter);
        // 267, 86
        jamonWriter.write("';\n              network = visualizeJsonPlan('plan-visualization', 'stage-info', 'statistics-info', 'statistics-info-head',\n                'statistics-info-body', jsonPlan, jsonStatuses, jsonStatistics, jsonLogs);\n            </script>\n          ");
      }
      // 271, 11
      else
      {
        // 271, 18
        jamonWriter.write("\n            <pre>Query information not available. Query may have failed or plan size may exceed value of config hive.server2.webui.max.graph.size.</pre>\n          ");
      }
      // 273, 17
      jamonWriter.write("\n        ");
    }
    // 274, 9
    else
    {
      // 274, 16
      jamonWriter.write("\n          ");
      // 275, 11
      if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT) )
      {
        // 275, 91
        jamonWriter.write("\n            <pre>\n            ");
        // 277, 13
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
        // 277, 113
        jamonWriter.write("\n            </pre>\n          ");
      }
      // 279, 11
      else
      {
        // 279, 18
        jamonWriter.write("\n            <pre>\n            Set configuration hive.server2.webui.explain.output to true to view future query plans\n            </pre>\n          ");
      }
      // 283, 17
      jamonWriter.write("\n        ");
    }
    // 284, 15
    jamonWriter.write("\n      </div>\n    </div>\n");
  }
  
  
  // 300, 1
  private void __jamon_innerUnit__perfLogging(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 304, 5
    jamonWriter.write("<section>\n      <h3>Compile-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 312, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 312, 139
      jamonWriter.write("\n             ");
      // 313, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION).entrySet() )
      {
        // 313, 138
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 315, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 315, 45
        jamonWriter.write("</td>\n                     <td>");
        // 316, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 316, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 318, 21
      jamonWriter.write("\n         ");
    }
    // 319, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 331, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 331, 137
      jamonWriter.write("\n             ");
      // 332, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION).entrySet() )
      {
        // 332, 136
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 334, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 334, 45
        jamonWriter.write("</td>\n                     <td>");
        // 335, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 335, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 337, 21
      jamonWriter.write("\n         ");
    }
    // 338, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Compile-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Compile-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 350, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 350, 141
      jamonWriter.write("\n             ");
      // 351, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION).entrySet()  )
      {
        // 351, 141
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 353, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 353, 45
        jamonWriter.write("</td>\n                     <td>");
        // 354, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 354, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 356, 21
      jamonWriter.write("\n         ");
    }
    // 357, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Execution-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 369, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 369, 139
      jamonWriter.write("\n             ");
      // 370, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION).entrySet()  )
      {
        // 370, 139
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 372, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 372, 45
        jamonWriter.write("</td>\n                     <td>");
        // 373, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 373, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 375, 21
      jamonWriter.write("\n         ");
    }
    // 376, 16
    jamonWriter.write("\n        </table>\n      </section>\n");
  }
  
  
}
