/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.EncryptionZoneUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.Retry;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplChangeManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplChangeManager.class);
    private static ReplChangeManager instance;
    private static boolean inited;
    private static boolean enabled;
    private static Map<String, String> encryptionZoneToCmrootMapping;
    private static Configuration conf;
    private String msUser;
    private String msGroup;
    private static final String ORIG_LOC_TAG = "user.original-loc";
    static final String REMAIN_IN_TRASH_TAG = "user.remain-in-trash";
    private static final String URI_FRAGMENT_SEPARATOR = "#";
    public static final String SOURCE_OF_REPLICATION = "repl.source.for";
    private static final String TXN_WRITE_EVENT_FILE_SEPARATOR = "]";
    static final String CM_THREAD_NAME_PREFIX = "cmclearer-";
    private static final String NO_ENCRYPTION = "noEncryption";
    private static String cmRootDir;
    private static String encryptedCmRootDir;
    private static String fallbackNonEncryptedCmRootDir;
    private static final PathFilter hiddenFileFilter;
    public static final PathFilter CMROOT_PATH_FILTER;

    public static synchronized ReplChangeManager getInstance(Configuration conf) throws MetaException {
        if (instance == null) {
            instance = new ReplChangeManager(conf);
        }
        return instance;
    }

    public static synchronized ReplChangeManager getInstance() {
        if (!inited) {
            throw new IllegalStateException("Replication Change Manager is not initialized.");
        }
        return instance;
    }

    private ReplChangeManager(Configuration conf) throws MetaException {
        try {
            if (!inited) {
                if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.REPLCMENABLED)) {
                    enabled = true;
                    ReplChangeManager.conf = conf;
                    cmRootDir = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.REPLCMDIR);
                    encryptedCmRootDir = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.REPLCMENCRYPTEDDIR);
                    fallbackNonEncryptedCmRootDir = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.REPLCMFALLBACKNONENCRYPTEDDIR);
                    Path cmRootEncrypted = new Path(encryptedCmRootDir);
                    if (cmRootEncrypted.isAbsolute()) {
                        throw new MetaException(MetastoreConf.ConfVars.REPLCMENCRYPTEDDIR.getHiveName() + " should be a relative path");
                    }
                    Path cmroot = new Path(cmRootDir);
                    ReplChangeManager.createCmRoot(cmroot);
                    FileSystem cmRootFs = cmroot.getFileSystem(conf);
                    if (EncryptionZoneUtils.isPathEncrypted(cmroot, conf)) {
                        String encryptionZonePath = cmRootFs.getUri() + EncryptionZoneUtils.getEncryptionZoneForPath(cmroot, conf).getPath();
                        encryptionZoneToCmrootMapping.put(encryptionZonePath, cmRootDir);
                    } else {
                        encryptionZoneToCmrootMapping.put(NO_ENCRYPTION, cmRootDir);
                    }
                    if (!StringUtils.isEmpty(fallbackNonEncryptedCmRootDir)) {
                        Path cmRootFallback = new Path(fallbackNonEncryptedCmRootDir);
                        if (!cmRootFallback.isAbsolute()) {
                            throw new MetaException(MetastoreConf.ConfVars.REPLCMENCRYPTEDDIR.getHiveName() + " should be absolute path");
                        }
                        ReplChangeManager.createCmRoot(cmRootFallback);
                        if (EncryptionZoneUtils.isPathEncrypted(cmRootFallback, conf)) {
                            throw new MetaException(MetastoreConf.ConfVars.REPLCMFALLBACKNONENCRYPTEDDIR.getHiveName() + " should not be encrypted");
                        }
                    }
                    UserGroupInformation usergroupInfo = UserGroupInformation.getCurrentUser();
                    this.msUser = usergroupInfo.getShortUserName();
                    this.msGroup = usergroupInfo.getPrimaryGroupName();
                }
                inited = true;
            }
        }
        catch (IOException e) {
            throw new MetaException(StringUtils.stringifyException(e));
        }
    }

    public int recycle(final Path path, RecycleType type, boolean ifPurge) throws IOException {
        int count;
        block18: {
            FileSystem fs;
            block17: {
                FileStatus[] files;
                if (!enabled) {
                    return 0;
                }
                count = 0;
                fs = path.getFileSystem(conf);
                if (!fs.isDirectory(path)) break block17;
                for (FileStatus file : files = fs.listStatus(path, hiddenFileFilter)) {
                    count += this.recycle(file.getPath(), type, ifPurge);
                }
                break block18;
            }
            String fileCheckSum = ReplChangeManager.checksumFor(path, fs);
            Path cmRootPath = this.getCmRoot(path);
            String cmRoot = null;
            if (cmRootPath != null) {
                cmRoot = FileUtils.makeQualified(cmRootPath, conf).toString();
            }
            final Path cmPath = ReplChangeManager.getCMPath(conf, path.getName(), fileCheckSum, cmRoot);
            long now = System.currentTimeMillis();
            fs.setTimes(path, now, -1L);
            boolean success = false;
            if (fs.exists(cmPath) && fileCheckSum.equalsIgnoreCase(ReplChangeManager.checksumFor(cmPath, fs))) {
                success = false;
            } else {
                switch (type) {
                    case MOVE: {
                        LOG.info("Moving {} to {}", (Object)path.toString(), (Object)cmPath.toString());
                        Retry<Boolean> retriable = new Retry<Boolean>(IOException.class){

                            @Override
                            public Boolean execute() throws IOException {
                                return fs.rename(path, cmPath);
                            }
                        };
                        try {
                            success = (Boolean)retriable.run();
                            break;
                        }
                        catch (Exception e) {
                            throw new IOException(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                    }
                    case COPY: {
                        LOG.info("Copying {} to {}", (Object)path.toString(), (Object)cmPath.toString());
                        success = FileUtils.copy(fs, path, fs, cmPath, false, true, conf);
                        break;
                    }
                }
            }
            if (success) {
                try {
                    fs.setXAttr(cmPath, ORIG_LOC_TAG, path.toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (UnsupportedOperationException e) {
                    LOG.warn("Error setting xattr for {}", (Object)path.toString());
                }
                ++count;
            } else {
                LOG.debug("A file with the same content of {} already exists, ignore", (Object)path.toString());
                fs.setTimes(cmPath, now, -1L);
            }
            if (type != RecycleType.MOVE || ifPurge) break block18;
            try {
                fs.setXAttr(cmPath, REMAIN_IN_TRASH_TAG, new byte[]{0});
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Error setting xattr for {}", (Object)cmPath.toString());
            }
        }
        return count;
    }

    public static String checksumFor(Path path, FileSystem fs) throws IOException {
        String checksumString = null;
        FileChecksum checksum = fs.getFileChecksum(path);
        if (checksum != null) {
            checksumString = StringUtils.byteToHexString(checksum.getBytes(), 0, checksum.getLength());
        }
        return checksumString;
    }

    static Path getCMPath(Configuration conf, String name, String checkSum, String cmRootUri) {
        String newFileName = name + "_" + checkSum;
        int maxLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 255);
        if (newFileName.length() > maxLength) {
            newFileName = newFileName.substring(0, maxLength - 1);
        }
        return new Path(cmRootUri, newFileName);
    }

    public static FileInfo getFileInfo(Path src, String checksumString, String srcCMRootURI, String subDir, Configuration conf) throws MetaException {
        try {
            String currentChecksumString;
            FileSystem srcFs = src.getFileSystem(conf);
            if (checksumString == null) {
                return new FileInfo(srcFs, src, subDir);
            }
            Path cmPath = ReplChangeManager.getCMPath(conf, src.getName(), checksumString, srcCMRootURI);
            if (!srcFs.exists(src)) {
                return new FileInfo(srcFs, src, cmPath, checksumString, false, subDir);
            }
            try {
                currentChecksumString = ReplChangeManager.checksumFor(src, srcFs);
            }
            catch (IOException ex) {
                return new FileInfo(srcFs, src, cmPath, checksumString, false, subDir);
            }
            if (currentChecksumString == null || checksumString.equals(currentChecksumString)) {
                return new FileInfo(srcFs, src, cmPath, checksumString, true, subDir);
            }
            return new FileInfo(srcFs, src, cmPath, checksumString, false, subDir);
        }
        catch (IOException e) {
            throw new MetaException(StringUtils.stringifyException(e));
        }
    }

    public String encodeFileUri(String fileUriStr, String fileChecksum, String encodedSubDir) throws IOException {
        if (instance == null) {
            throw new IllegalStateException("Uninitialized ReplChangeManager instance.");
        }
        Path cmRootPath = this.getCmRoot(new Path(fileUriStr));
        String cmRoot = null;
        if (cmRootPath != null) {
            cmRoot = FileUtils.makeQualified(cmRootPath, conf).toString();
        }
        return ReplChangeManager.encodeFileUri(fileUriStr, fileChecksum, cmRoot, encodedSubDir);
    }

    public static String encodeFileUri(String fileUriStr, String fileChecksum, String cmRoot, String encodedSubDir) {
        String encodedUri = fileUriStr;
        encodedUri = fileChecksum != null && cmRoot != null ? encodedUri + URI_FRAGMENT_SEPARATOR + fileChecksum + URI_FRAGMENT_SEPARATOR + cmRoot : encodedUri + URI_FRAGMENT_SEPARATOR + URI_FRAGMENT_SEPARATOR;
        encodedUri = encodedUri + URI_FRAGMENT_SEPARATOR + (encodedSubDir != null ? encodedSubDir : "");
        LOG.debug("Encoded URI: " + encodedUri);
        return encodedUri;
    }

    public static String[] decodeFileUri(String fileURIStr) {
        String[] uriAndFragment = fileURIStr.split(URI_FRAGMENT_SEPARATOR);
        String[] result = new String[4];
        result[0] = uriAndFragment[0];
        if (uriAndFragment.length > 1 && !StringUtils.isEmpty(uriAndFragment[1])) {
            result[1] = uriAndFragment[1];
        }
        if (uriAndFragment.length > 2 && !StringUtils.isEmpty(uriAndFragment[2])) {
            result[2] = uriAndFragment[2];
        }
        if (uriAndFragment.length > 3 && !StringUtils.isEmpty(uriAndFragment[3])) {
            result[3] = uriAndFragment[3];
        }
        LOG.debug("Reading Encoded URI: " + result[0] + ":: " + result[1] + ":: " + result[2] + ":: " + result[3]);
        return result;
    }

    public static boolean isCMFileUri(Path fromPath) {
        String[] result = ReplChangeManager.decodeFileUri(fromPath.toString());
        return result[1] != null;
    }

    static void scheduleCMClearer(Configuration conf) {
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.REPLCMENABLED)) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("cmclearer-%d").daemon(true).build());
            executor.scheduleAtFixedRate(new CMClearer(encryptionZoneToCmrootMapping, MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.REPLCMRETIAN, TimeUnit.SECONDS), conf), 0L, MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.REPLCMINTERVAL, TimeUnit.SECONDS), TimeUnit.SECONDS);
        }
    }

    public static boolean shouldEnableCm(Database db, Table table) {
        assert (table != null);
        return ReplChangeManager.isSourceOfReplication(db) && !MetaStoreUtils.isExternalTable(table);
    }

    public static boolean isSourceOfReplication(Database db) {
        assert (db != null);
        String replPolicyIds = ReplChangeManager.getReplPolicyIdString(db);
        return !StringUtils.isEmpty(replPolicyIds);
    }

    public static String getReplPolicyIdString(Database db) {
        if (db != null) {
            Map<String, String> m = db.getParameters();
            if (m != null && m.containsKey(SOURCE_OF_REPLICATION)) {
                String replPolicyId = m.get(SOURCE_OF_REPLICATION);
                LOG.debug("repl policy for database {} is {}", (Object)db.getName(), (Object)replPolicyId);
                return replPolicyId;
            }
            LOG.debug("Repl policy is not set for database: {}", (Object)db.getName());
        }
        return null;
    }

    public static String joinWithSeparator(Iterable<?> strings) {
        return org.apache.hadoop.util.StringUtils.join((CharSequence)TXN_WRITE_EVENT_FILE_SEPARATOR, strings);
    }

    public static String[] getListFromSeparatedString(String commaSeparatedString) {
        return commaSeparatedString.split("\\s*]\\s*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Path getCmRoot(Path path) throws IOException {
        Path cmroot = null;
        String cmrootDir = fallbackNonEncryptedCmRootDir;
        String encryptionZonePath = NO_ENCRYPTION;
        if (enabled) {
            if (EncryptionZoneUtils.isPathEncrypted(path, conf)) {
                encryptionZonePath = path.getFileSystem(conf).getUri() + EncryptionZoneUtils.getEncryptionZoneForPath(path, conf).getPath();
                cmrootDir = encryptionZonePath + "/" + encryptedCmRootDir;
            }
            if (encryptionZoneToCmrootMapping.containsKey(encryptionZonePath)) {
                cmroot = new Path(encryptionZoneToCmrootMapping.get(encryptionZonePath));
            } else {
                cmroot = new Path(cmrootDir);
                ReplChangeManager replChangeManager = instance;
                synchronized (replChangeManager) {
                    if (!encryptionZoneToCmrootMapping.containsKey(encryptionZonePath)) {
                        ReplChangeManager.createCmRoot(cmroot);
                        encryptionZoneToCmrootMapping.put(encryptionZonePath, cmrootDir);
                    }
                }
            }
        }
        return cmroot;
    }

    private static void createCmRoot(final Path cmroot) throws IOException {
        Retry<Void> retriable = new Retry<Void>(IOException.class){

            @Override
            public Void execute() throws IOException {
                FileSystem cmFs = cmroot.getFileSystem(conf);
                if (!cmFs.exists(cmroot)) {
                    cmFs.mkdirs(cmroot);
                    ReplChangeManager.setCmRootPermissions(cmroot);
                }
                return null;
            }
        };
        try {
            retriable.run();
        }
        catch (Exception e) {
            throw new IOException("Failed to createCmRoot", e);
        }
    }

    private static void setCmRootPermissions(Path cmroot) throws IOException {
        FileSystem cmFs = cmroot.getFileSystem(conf);
        cmFs.setPermission(cmroot, new FsPermission("770"));
        try {
            FileStatus warehouseStatus = cmFs.getFileStatus(new Path(MetastoreConf.get(conf, MetastoreConf.ConfVars.WAREHOUSE.getVarname())));
            String warehouseOwner = warehouseStatus.getOwner();
            String warehouseGroup = warehouseStatus.getGroup();
            if (warehouseOwner.equals(cmFs.getFileStatus(cmroot).getOwner())) {
                FsAction whOwnerAction = warehouseStatus.getPermission().getUserAction();
                FsAction whGroupAction = warehouseStatus.getPermission().getGroupAction();
                FsAction whOtherAction = warehouseStatus.getPermission().getOtherAction();
                if (!warehouseGroup.equals(cmFs.getFileStatus(cmroot).getGroup())) {
                    cmFs.setOwner(cmroot, null, warehouseGroup);
                    cmFs.setPermission(cmroot, new FsPermission(whOwnerAction, whGroupAction, whOtherAction));
                }
            } else {
                LOG.warn("Metastore-user is not same as owner of warehouse.");
                if (!warehouseGroup.equals(cmFs.getFileStatus(cmroot).getGroup())) {
                    ArrayList aclList = Lists.newArrayList((Object[])new AclEntry[]{new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(FsAction.ALL).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).setPermission(FsAction.ALL).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(FsAction.NONE).build()});
                    aclList.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).setName(warehouseGroup).setPermission(warehouseStatus.getPermission().getGroupAction()).build());
                    cmFs.setAcl(cmroot, (List)aclList);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Unable to set permissions corresponding to hive-warehouse on CMRoot: ", (Throwable)e);
        }
    }

    @VisibleForTesting
    static void resetReplChangeManagerInstance() {
        inited = false;
        enabled = false;
        instance = null;
        encryptionZoneToCmrootMapping.clear();
    }

    static {
        inited = false;
        enabled = false;
        encryptionZoneToCmrootMapping = new HashMap<String, String>();
        hiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                return !p.getName().startsWith(".");
            }
        };
        CMROOT_PATH_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                if (enabled) {
                    String name = p.getName();
                    return StringUtils.isEmpty(fallbackNonEncryptedCmRootDir) ? !name.contains(cmRootDir) && !name.contains(encryptedCmRootDir) : !name.contains(cmRootDir) && !name.contains(encryptedCmRootDir) && !name.contains(fallbackNonEncryptedCmRootDir);
                }
                return true;
            }
        };
    }

    static class CMClearer
    implements Runnable {
        private Map<String, String> encryptionZones;
        private long secRetain;
        private Configuration conf;

        CMClearer(Map<String, String> encryptionZones, long secRetain, Configuration conf) {
            this.encryptionZones = encryptionZones;
            this.secRetain = secRetain;
            this.conf = conf;
        }

        @Override
        public void run() {
            try {
                LOG.info("CMClearer started");
                for (String cmrootString : this.encryptionZones.values()) {
                    FileStatus[] files;
                    Path cmroot = new Path(cmrootString);
                    long now = System.currentTimeMillis();
                    FileSystem fs = cmroot.getFileSystem(this.conf);
                    for (FileStatus file : files = fs.listStatus(cmroot)) {
                        long modifiedTime = file.getModificationTime();
                        if (now - modifiedTime <= this.secRetain * 1000L) continue;
                        try {
                            boolean succ;
                            if (fs.getXAttrs(file.getPath()).containsKey(ReplChangeManager.REMAIN_IN_TRASH_TAG)) {
                                succ = Trash.moveToAppropriateTrash((FileSystem)fs, (Path)file.getPath(), (Configuration)this.conf);
                                if (succ) {
                                    LOG.debug("Move " + file.toString() + " to trash");
                                    continue;
                                }
                                LOG.warn("Fail to move " + file.toString() + " to trash");
                                continue;
                            }
                            succ = fs.delete(file.getPath(), false);
                            if (succ) {
                                LOG.debug("Remove " + file.toString());
                                continue;
                            }
                            LOG.warn("Fail to remove " + file.toString());
                        }
                        catch (UnsupportedOperationException e) {
                            LOG.warn("Error getting xattr for " + file.getPath().toString());
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Exception when clearing cmroot", (Throwable)e);
            }
        }
    }

    public static class FileInfo {
        private FileSystem srcFs;
        private Path sourcePath;
        private Path cmPath;
        private String checkSum;
        private boolean useSourcePath;
        private String subDir;
        private boolean copyDone;

        public FileInfo(FileSystem srcFs, Path sourcePath, String subDir) {
            this(srcFs, sourcePath, null, null, true, subDir);
        }

        public FileInfo(FileSystem srcFs, Path sourcePath, Path cmPath, String checkSum, boolean useSourcePath, String subDir) {
            this.srcFs = srcFs;
            this.sourcePath = sourcePath;
            this.cmPath = cmPath;
            this.checkSum = checkSum;
            this.useSourcePath = useSourcePath;
            this.subDir = subDir;
            this.copyDone = false;
        }

        public FileSystem getSrcFs() {
            return this.srcFs;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public Path getCmPath() {
            return this.cmPath;
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public boolean isUseSourcePath() {
            return this.useSourcePath;
        }

        public void setIsUseSourcePath(boolean useSourcePath) {
            this.useSourcePath = useSourcePath;
        }

        public String getSubDir() {
            return this.subDir;
        }

        public boolean isCopyDone() {
            return this.copyDone;
        }

        public void setCopyDone(boolean copyDone) {
            this.copyDone = copyDone;
        }

        public Path getEffectivePath() {
            if (this.useSourcePath) {
                return this.sourcePath;
            }
            return this.cmPath;
        }
    }

    public static enum RecycleType {
        MOVE,
        COPY;

    }
}

