/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CreateDatabaseRequest
implements TBase<CreateDatabaseRequest, _Fields>,
Serializable,
Cloneable,
Comparable<CreateDatabaseRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("CreateDatabaseRequest");
    private static final TField DATABASE_NAME_FIELD_DESC = new TField("databaseName", 11, 1);
    private static final TField DESCRIPTION_FIELD_DESC = new TField("description", 11, 2);
    private static final TField LOCATION_URI_FIELD_DESC = new TField("locationUri", 11, 3);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 4);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 12, 5);
    private static final TField OWNER_NAME_FIELD_DESC = new TField("ownerName", 11, 6);
    private static final TField OWNER_TYPE_FIELD_DESC = new TField("ownerType", 8, 7);
    private static final TField CATALOG_NAME_FIELD_DESC = new TField("catalogName", 11, 8);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 9);
    private static final TField MANAGED_LOCATION_URI_FIELD_DESC = new TField("managedLocationUri", 11, 10);
    private static final TField TYPE_FIELD_DESC = new TField("type", 11, 11);
    private static final TField DATA_CONNECTOR_NAME_FIELD_DESC = new TField("dataConnectorName", 11, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new CreateDatabaseRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new CreateDatabaseRequestTupleSchemeFactory();
    @Nullable
    private String databaseName;
    @Nullable
    private String description;
    @Nullable
    private String locationUri;
    @Nullable
    private Map<String, String> parameters;
    @Nullable
    private PrincipalPrivilegeSet privileges;
    @Nullable
    private String ownerName;
    @Nullable
    private PrincipalType ownerType;
    @Nullable
    private String catalogName;
    private int createTime;
    @Nullable
    private String managedLocationUri;
    @Nullable
    private String type;
    @Nullable
    private String dataConnectorName;
    private static final int __CREATETIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DESCRIPTION, _Fields.LOCATION_URI, _Fields.PARAMETERS, _Fields.PRIVILEGES, _Fields.OWNER_NAME, _Fields.OWNER_TYPE, _Fields.CATALOG_NAME, _Fields.CREATE_TIME, _Fields.MANAGED_LOCATION_URI, _Fields.TYPE, _Fields.DATA_CONNECTOR_NAME};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CreateDatabaseRequest() {
    }

    public CreateDatabaseRequest(String databaseName) {
        this();
        this.databaseName = databaseName;
    }

    public CreateDatabaseRequest(CreateDatabaseRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDatabaseName()) {
            this.databaseName = other.databaseName;
        }
        if (other.isSetDescription()) {
            this.description = other.description;
        }
        if (other.isSetLocationUri()) {
            this.locationUri = other.locationUri;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>(other.parameters);
            this.parameters = __this__parameters;
        }
        if (other.isSetPrivileges()) {
            this.privileges = new PrincipalPrivilegeSet(other.privileges);
        }
        if (other.isSetOwnerName()) {
            this.ownerName = other.ownerName;
        }
        if (other.isSetOwnerType()) {
            this.ownerType = other.ownerType;
        }
        if (other.isSetCatalogName()) {
            this.catalogName = other.catalogName;
        }
        this.createTime = other.createTime;
        if (other.isSetManagedLocationUri()) {
            this.managedLocationUri = other.managedLocationUri;
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetDataConnectorName()) {
            this.dataConnectorName = other.dataConnectorName;
        }
    }

    public CreateDatabaseRequest deepCopy() {
        return new CreateDatabaseRequest(this);
    }

    public void clear() {
        this.databaseName = null;
        this.description = null;
        this.locationUri = null;
        this.parameters = null;
        this.privileges = null;
        this.ownerName = null;
        this.ownerType = null;
        this.catalogName = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.managedLocationUri = null;
        this.type = null;
        this.dataConnectorName = null;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
    }

    public void unsetDatabaseName() {
        this.databaseName = null;
    }

    public boolean isSetDatabaseName() {
        return this.databaseName != null;
    }

    public void setDatabaseNameIsSet(boolean value) {
        if (!value) {
            this.databaseName = null;
        }
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void unsetDescription() {
        this.description = null;
    }

    public boolean isSetDescription() {
        return this.description != null;
    }

    public void setDescriptionIsSet(boolean value) {
        if (!value) {
            this.description = null;
        }
    }

    @Nullable
    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(@Nullable String locationUri) {
        this.locationUri = locationUri;
    }

    public void unsetLocationUri() {
        this.locationUri = null;
    }

    public boolean isSetLocationUri() {
        return this.locationUri != null;
    }

    public void setLocationUriIsSet(boolean value) {
        if (!value) {
            this.locationUri = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    @Nullable
    public PrincipalPrivilegeSet getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(@Nullable PrincipalPrivilegeSet privileges) {
        this.privileges = privileges;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean value) {
        if (!value) {
            this.privileges = null;
        }
    }

    @Nullable
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(@Nullable String ownerName) {
        this.ownerName = ownerName;
    }

    public void unsetOwnerName() {
        this.ownerName = null;
    }

    public boolean isSetOwnerName() {
        return this.ownerName != null;
    }

    public void setOwnerNameIsSet(boolean value) {
        if (!value) {
            this.ownerName = null;
        }
    }

    @Nullable
    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(@Nullable PrincipalType ownerType) {
        this.ownerType = ownerType;
    }

    public void unsetOwnerType() {
        this.ownerType = null;
    }

    public boolean isSetOwnerType() {
        return this.ownerType != null;
    }

    public void setOwnerTypeIsSet(boolean value) {
        if (!value) {
            this.ownerType = null;
        }
    }

    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(@Nullable String catalogName) {
        this.catalogName = catalogName;
    }

    public void unsetCatalogName() {
        this.catalogName = null;
    }

    public boolean isSetCatalogName() {
        return this.catalogName != null;
    }

    public void setCatalogNameIsSet(boolean value) {
        if (!value) {
            this.catalogName = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreateTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getManagedLocationUri() {
        return this.managedLocationUri;
    }

    public void setManagedLocationUri(@Nullable String managedLocationUri) {
        this.managedLocationUri = managedLocationUri;
    }

    public void unsetManagedLocationUri() {
        this.managedLocationUri = null;
    }

    public boolean isSetManagedLocationUri() {
        return this.managedLocationUri != null;
    }

    public void setManagedLocationUriIsSet(boolean value) {
        if (!value) {
            this.managedLocationUri = null;
        }
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    @Nullable
    public String getDataConnectorName() {
        return this.dataConnectorName;
    }

    public void setDataConnectorName(@Nullable String dataConnectorName) {
        this.dataConnectorName = dataConnectorName;
    }

    public void unsetDataConnectorName() {
        this.dataConnectorName = null;
    }

    public boolean isSetDataConnectorName() {
        return this.dataConnectorName != null;
    }

    public void setDataConnectorNameIsSet(boolean value) {
        if (!value) {
            this.dataConnectorName = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case DATABASE_NAME: {
                if (value == null) {
                    this.unsetDatabaseName();
                    break;
                }
                this.setDatabaseName((String)value);
                break;
            }
            case DESCRIPTION: {
                if (value == null) {
                    this.unsetDescription();
                    break;
                }
                this.setDescription((String)value);
                break;
            }
            case LOCATION_URI: {
                if (value == null) {
                    this.unsetLocationUri();
                    break;
                }
                this.setLocationUri((String)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case PRIVILEGES: {
                if (value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((PrincipalPrivilegeSet)value);
                break;
            }
            case OWNER_NAME: {
                if (value == null) {
                    this.unsetOwnerName();
                    break;
                }
                this.setOwnerName((String)value);
                break;
            }
            case OWNER_TYPE: {
                if (value == null) {
                    this.unsetOwnerType();
                    break;
                }
                this.setOwnerType((PrincipalType)((Object)value));
                break;
            }
            case CATALOG_NAME: {
                if (value == null) {
                    this.unsetCatalogName();
                    break;
                }
                this.setCatalogName((String)value);
                break;
            }
            case CREATE_TIME: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case MANAGED_LOCATION_URI: {
                if (value == null) {
                    this.unsetManagedLocationUri();
                    break;
                }
                this.setManagedLocationUri((String)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((String)value);
                break;
            }
            case DATA_CONNECTOR_NAME: {
                if (value == null) {
                    this.unsetDataConnectorName();
                    break;
                }
                this.setDataConnectorName((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DATABASE_NAME: {
                return this.getDatabaseName();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
            case LOCATION_URI: {
                return this.getLocationUri();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
            case PRIVILEGES: {
                return this.getPrivileges();
            }
            case OWNER_NAME: {
                return this.getOwnerName();
            }
            case OWNER_TYPE: {
                return this.getOwnerType();
            }
            case CATALOG_NAME: {
                return this.getCatalogName();
            }
            case CREATE_TIME: {
                return this.getCreateTime();
            }
            case MANAGED_LOCATION_URI: {
                return this.getManagedLocationUri();
            }
            case TYPE: {
                return this.getType();
            }
            case DATA_CONNECTOR_NAME: {
                return this.getDataConnectorName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DATABASE_NAME: {
                return this.isSetDatabaseName();
            }
            case DESCRIPTION: {
                return this.isSetDescription();
            }
            case LOCATION_URI: {
                return this.isSetLocationUri();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
            case PRIVILEGES: {
                return this.isSetPrivileges();
            }
            case OWNER_NAME: {
                return this.isSetOwnerName();
            }
            case OWNER_TYPE: {
                return this.isSetOwnerType();
            }
            case CATALOG_NAME: {
                return this.isSetCatalogName();
            }
            case CREATE_TIME: {
                return this.isSetCreateTime();
            }
            case MANAGED_LOCATION_URI: {
                return this.isSetManagedLocationUri();
            }
            case TYPE: {
                return this.isSetType();
            }
            case DATA_CONNECTOR_NAME: {
                return this.isSetDataConnectorName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof CreateDatabaseRequest) {
            return this.equals((CreateDatabaseRequest)that);
        }
        return false;
    }

    public boolean equals(CreateDatabaseRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_databaseName = this.isSetDatabaseName();
        boolean that_present_databaseName = that.isSetDatabaseName();
        if (this_present_databaseName || that_present_databaseName) {
            if (!this_present_databaseName || !that_present_databaseName) {
                return false;
            }
            if (!this.databaseName.equals(that.databaseName)) {
                return false;
            }
        }
        boolean this_present_description = this.isSetDescription();
        boolean that_present_description = that.isSetDescription();
        if (this_present_description || that_present_description) {
            if (!this_present_description || !that_present_description) {
                return false;
            }
            if (!this.description.equals(that.description)) {
                return false;
            }
        }
        boolean this_present_locationUri = this.isSetLocationUri();
        boolean that_present_locationUri = that.isSetLocationUri();
        if (this_present_locationUri || that_present_locationUri) {
            if (!this_present_locationUri || !that_present_locationUri) {
                return false;
            }
            if (!this.locationUri.equals(that.locationUri)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!this.parameters.equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_privileges = this.isSetPrivileges();
        boolean that_present_privileges = that.isSetPrivileges();
        if (this_present_privileges || that_present_privileges) {
            if (!this_present_privileges || !that_present_privileges) {
                return false;
            }
            if (!this.privileges.equals(that.privileges)) {
                return false;
            }
        }
        boolean this_present_ownerName = this.isSetOwnerName();
        boolean that_present_ownerName = that.isSetOwnerName();
        if (this_present_ownerName || that_present_ownerName) {
            if (!this_present_ownerName || !that_present_ownerName) {
                return false;
            }
            if (!this.ownerName.equals(that.ownerName)) {
                return false;
            }
        }
        boolean this_present_ownerType = this.isSetOwnerType();
        boolean that_present_ownerType = that.isSetOwnerType();
        if (this_present_ownerType || that_present_ownerType) {
            if (!this_present_ownerType || !that_present_ownerType) {
                return false;
            }
            if (!this.ownerType.equals((Object)that.ownerType)) {
                return false;
            }
        }
        boolean this_present_catalogName = this.isSetCatalogName();
        boolean that_present_catalogName = that.isSetCatalogName();
        if (this_present_catalogName || that_present_catalogName) {
            if (!this_present_catalogName || !that_present_catalogName) {
                return false;
            }
            if (!this.catalogName.equals(that.catalogName)) {
                return false;
            }
        }
        boolean this_present_createTime = this.isSetCreateTime();
        boolean that_present_createTime = that.isSetCreateTime();
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_managedLocationUri = this.isSetManagedLocationUri();
        boolean that_present_managedLocationUri = that.isSetManagedLocationUri();
        if (this_present_managedLocationUri || that_present_managedLocationUri) {
            if (!this_present_managedLocationUri || !that_present_managedLocationUri) {
                return false;
            }
            if (!this.managedLocationUri.equals(that.managedLocationUri)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
        }
        boolean this_present_dataConnectorName = this.isSetDataConnectorName();
        boolean that_present_dataConnectorName = that.isSetDataConnectorName();
        if (this_present_dataConnectorName || that_present_dataConnectorName) {
            if (!this_present_dataConnectorName || !that_present_dataConnectorName) {
                return false;
            }
            if (!this.dataConnectorName.equals(that.dataConnectorName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDatabaseName() ? 131071 : 524287);
        if (this.isSetDatabaseName()) {
            hashCode = hashCode * 8191 + this.databaseName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDescription() ? 131071 : 524287);
        if (this.isSetDescription()) {
            hashCode = hashCode * 8191 + this.description.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLocationUri() ? 131071 : 524287);
        if (this.isSetLocationUri()) {
            hashCode = hashCode * 8191 + this.locationUri.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParameters() ? 131071 : 524287);
        if (this.isSetParameters()) {
            hashCode = hashCode * 8191 + this.parameters.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPrivileges() ? 131071 : 524287);
        if (this.isSetPrivileges()) {
            hashCode = hashCode * 8191 + this.privileges.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOwnerName() ? 131071 : 524287);
        if (this.isSetOwnerName()) {
            hashCode = hashCode * 8191 + this.ownerName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOwnerType() ? 131071 : 524287);
        if (this.isSetOwnerType()) {
            hashCode = hashCode * 8191 + this.ownerType.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetCatalogName() ? 131071 : 524287);
        if (this.isSetCatalogName()) {
            hashCode = hashCode * 8191 + this.catalogName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCreateTime() ? 131071 : 524287);
        if (this.isSetCreateTime()) {
            hashCode = hashCode * 8191 + this.createTime;
        }
        hashCode = hashCode * 8191 + (this.isSetManagedLocationUri() ? 131071 : 524287);
        if (this.isSetManagedLocationUri()) {
            hashCode = hashCode * 8191 + this.managedLocationUri.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDataConnectorName() ? 131071 : 524287);
        if (this.isSetDataConnectorName()) {
            hashCode = hashCode * 8191 + this.dataConnectorName.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(CreateDatabaseRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDatabaseName(), other.isSetDatabaseName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDatabaseName() && (lastComparison = TBaseHelper.compareTo((String)this.databaseName, (String)other.databaseName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDescription(), other.isSetDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDescription() && (lastComparison = TBaseHelper.compareTo((String)this.description, (String)other.description)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLocationUri(), other.isSetLocationUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLocationUri() && (lastComparison = TBaseHelper.compareTo((String)this.locationUri, (String)other.locationUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParameters(), other.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, other.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPrivileges(), other.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrivileges() && (lastComparison = TBaseHelper.compareTo((Comparable)this.privileges, (Comparable)other.privileges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOwnerName(), other.isSetOwnerName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerName() && (lastComparison = TBaseHelper.compareTo((String)this.ownerName, (String)other.ownerName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOwnerType(), other.isSetOwnerType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.ownerType), (Comparable)((Object)other.ownerType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatalogName(), other.isSetCatalogName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatalogName() && (lastComparison = TBaseHelper.compareTo((String)this.catalogName, (String)other.catalogName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCreateTime(), other.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo((int)this.createTime, (int)other.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetManagedLocationUri(), other.isSetManagedLocationUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetManagedLocationUri() && (lastComparison = TBaseHelper.compareTo((String)this.managedLocationUri, (String)other.managedLocationUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((String)this.type, (String)other.type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDataConnectorName(), other.isSetDataConnectorName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataConnectorName() && (lastComparison = TBaseHelper.compareTo((String)this.dataConnectorName, (String)other.dataConnectorName)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        CreateDatabaseRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        CreateDatabaseRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateDatabaseRequest(");
        boolean first = true;
        sb.append("databaseName:");
        if (this.databaseName == null) {
            sb.append("null");
        } else {
            sb.append(this.databaseName);
        }
        first = false;
        if (this.isSetDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("description:");
            if (this.description == null) {
                sb.append("null");
            } else {
                sb.append(this.description);
            }
            first = false;
        }
        if (this.isSetLocationUri()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("locationUri:");
            if (this.locationUri == null) {
                sb.append("null");
            } else {
                sb.append(this.locationUri);
            }
            first = false;
        }
        if (this.isSetParameters()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parameters:");
            if (this.parameters == null) {
                sb.append("null");
            } else {
                sb.append(this.parameters);
            }
            first = false;
        }
        if (this.isSetPrivileges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("privileges:");
            if (this.privileges == null) {
                sb.append("null");
            } else {
                sb.append(this.privileges);
            }
            first = false;
        }
        if (this.isSetOwnerName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerName:");
            if (this.ownerName == null) {
                sb.append("null");
            } else {
                sb.append(this.ownerName);
            }
            first = false;
        }
        if (this.isSetOwnerType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerType:");
            if (this.ownerType == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.ownerType);
            }
            first = false;
        }
        if (this.isSetCatalogName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catalogName:");
            if (this.catalogName == null) {
                sb.append("null");
            } else {
                sb.append(this.catalogName);
            }
            first = false;
        }
        if (this.isSetCreateTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("createTime:");
            sb.append(this.createTime);
            first = false;
        }
        if (this.isSetManagedLocationUri()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("managedLocationUri:");
            if (this.managedLocationUri == null) {
                sb.append("null");
            } else {
                sb.append(this.managedLocationUri);
            }
            first = false;
        }
        if (this.isSetType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("type:");
            if (this.type == null) {
                sb.append("null");
            } else {
                sb.append(this.type);
            }
            first = false;
        }
        if (this.isSetDataConnectorName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dataConnectorName:");
            if (this.dataConnectorName == null) {
                sb.append("null");
            } else {
                sb.append(this.dataConnectorName);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDatabaseName()) {
            throw new TProtocolException("Required field 'databaseName' is unset! Struct:" + this.toString());
        }
        if (this.privileges != null) {
            this.privileges.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATABASE_NAME, new FieldMetaData("databaseName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DESCRIPTION, new FieldMetaData("description", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LOCATION_URI, new FieldMetaData("locationUri", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PRIVILEGES, new FieldMetaData("privileges", 2, (FieldValueMetaData)new StructMetaData(12, PrincipalPrivilegeSet.class)));
        tmpMap.put(_Fields.OWNER_NAME, new FieldMetaData("ownerName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER_TYPE, new FieldMetaData("ownerType", 2, (FieldValueMetaData)new EnumMetaData(16, PrincipalType.class)));
        tmpMap.put(_Fields.CATALOG_NAME, new FieldMetaData("catalogName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MANAGED_LOCATION_URI, new FieldMetaData("managedLocationUri", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DATA_CONNECTOR_NAME, new FieldMetaData("dataConnectorName", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CreateDatabaseRequest.class, metaDataMap);
    }

    private static class CreateDatabaseRequestTupleScheme
    extends TupleScheme<CreateDatabaseRequest> {
        private CreateDatabaseRequestTupleScheme() {
        }

        public void write(TProtocol prot, CreateDatabaseRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.databaseName);
            BitSet optionals = new BitSet();
            if (struct.isSetDescription()) {
                optionals.set(0);
            }
            if (struct.isSetLocationUri()) {
                optionals.set(1);
            }
            if (struct.isSetParameters()) {
                optionals.set(2);
            }
            if (struct.isSetPrivileges()) {
                optionals.set(3);
            }
            if (struct.isSetOwnerName()) {
                optionals.set(4);
            }
            if (struct.isSetOwnerType()) {
                optionals.set(5);
            }
            if (struct.isSetCatalogName()) {
                optionals.set(6);
            }
            if (struct.isSetCreateTime()) {
                optionals.set(7);
            }
            if (struct.isSetManagedLocationUri()) {
                optionals.set(8);
            }
            if (struct.isSetType()) {
                optionals.set(9);
            }
            if (struct.isSetDataConnectorName()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetDescription()) {
                oprot.writeString(struct.description);
            }
            if (struct.isSetLocationUri()) {
                oprot.writeString(struct.locationUri);
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry _iter1273 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter1273.getKey());
                    oprot.writeString((String)_iter1273.getValue());
                }
            }
            if (struct.isSetPrivileges()) {
                struct.privileges.write((TProtocol)oprot);
            }
            if (struct.isSetOwnerName()) {
                oprot.writeString(struct.ownerName);
            }
            if (struct.isSetOwnerType()) {
                oprot.writeI32(struct.ownerType.getValue());
            }
            if (struct.isSetCatalogName()) {
                oprot.writeString(struct.catalogName);
            }
            if (struct.isSetCreateTime()) {
                oprot.writeI32(struct.createTime);
            }
            if (struct.isSetManagedLocationUri()) {
                oprot.writeString(struct.managedLocationUri);
            }
            if (struct.isSetType()) {
                oprot.writeString(struct.type);
            }
            if (struct.isSetDataConnectorName()) {
                oprot.writeString(struct.dataConnectorName);
            }
        }

        public void read(TProtocol prot, CreateDatabaseRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.databaseName = iprot.readString();
            struct.setDatabaseNameIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.description = iprot.readString();
                struct.setDescriptionIsSet(true);
            }
            if (incoming.get(1)) {
                struct.locationUri = iprot.readString();
                struct.setLocationUriIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map1274 = iprot.readMapBegin((byte)11, (byte)11);
                struct.parameters = new HashMap(2 * _map1274.size);
                for (int _i1277 = 0; _i1277 < _map1274.size; ++_i1277) {
                    String _key1275 = iprot.readString();
                    String _val1276 = iprot.readString();
                    struct.parameters.put(_key1275, _val1276);
                }
                struct.setParametersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.privileges = new PrincipalPrivilegeSet();
                struct.privileges.read((TProtocol)iprot);
                struct.setPrivilegesIsSet(true);
            }
            if (incoming.get(4)) {
                struct.ownerName = iprot.readString();
                struct.setOwnerNameIsSet(true);
            }
            if (incoming.get(5)) {
                struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                struct.setOwnerTypeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.catalogName = iprot.readString();
                struct.setCatalogNameIsSet(true);
            }
            if (incoming.get(7)) {
                struct.createTime = iprot.readI32();
                struct.setCreateTimeIsSet(true);
            }
            if (incoming.get(8)) {
                struct.managedLocationUri = iprot.readString();
                struct.setManagedLocationUriIsSet(true);
            }
            if (incoming.get(9)) {
                struct.type = iprot.readString();
                struct.setTypeIsSet(true);
            }
            if (incoming.get(10)) {
                struct.dataConnectorName = iprot.readString();
                struct.setDataConnectorNameIsSet(true);
            }
        }
    }

    private static class CreateDatabaseRequestTupleSchemeFactory
    implements SchemeFactory {
        private CreateDatabaseRequestTupleSchemeFactory() {
        }

        public CreateDatabaseRequestTupleScheme getScheme() {
            return new CreateDatabaseRequestTupleScheme();
        }
    }

    private static class CreateDatabaseRequestStandardScheme
    extends StandardScheme<CreateDatabaseRequest> {
        private CreateDatabaseRequestStandardScheme() {
        }

        public void read(TProtocol iprot, CreateDatabaseRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.databaseName = iprot.readString();
                            struct.setDatabaseNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.description = iprot.readString();
                            struct.setDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.locationUri = iprot.readString();
                            struct.setLocationUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map1268 = iprot.readMapBegin();
                            struct.parameters = new HashMap(2 * _map1268.size);
                            for (int _i1271 = 0; _i1271 < _map1268.size; ++_i1271) {
                                String _key1269 = iprot.readString();
                                String _val1270 = iprot.readString();
                                struct.parameters.put(_key1269, _val1270);
                            }
                            iprot.readMapEnd();
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.privileges = new PrincipalPrivilegeSet();
                            struct.privileges.read(iprot);
                            struct.setPrivilegesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.ownerName = iprot.readString();
                            struct.setOwnerNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                            struct.setOwnerTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.catalogName = iprot.readString();
                            struct.setCatalogNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.createTime = iprot.readI32();
                            struct.setCreateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.managedLocationUri = iprot.readString();
                            struct.setManagedLocationUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.type = iprot.readString();
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.dataConnectorName = iprot.readString();
                            struct.setDataConnectorNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, CreateDatabaseRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.databaseName != null) {
                oprot.writeFieldBegin(DATABASE_NAME_FIELD_DESC);
                oprot.writeString(struct.databaseName);
                oprot.writeFieldEnd();
            }
            if (struct.description != null && struct.isSetDescription()) {
                oprot.writeFieldBegin(DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.description);
                oprot.writeFieldEnd();
            }
            if (struct.locationUri != null && struct.isSetLocationUri()) {
                oprot.writeFieldBegin(LOCATION_URI_FIELD_DESC);
                oprot.writeString(struct.locationUri);
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null && struct.isSetParameters()) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry _iter1272 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter1272.getKey());
                    oprot.writeString((String)_iter1272.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.privileges != null && struct.isSetPrivileges()) {
                oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
                struct.privileges.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.ownerName != null && struct.isSetOwnerName()) {
                oprot.writeFieldBegin(OWNER_NAME_FIELD_DESC);
                oprot.writeString(struct.ownerName);
                oprot.writeFieldEnd();
            }
            if (struct.ownerType != null && struct.isSetOwnerType()) {
                oprot.writeFieldBegin(OWNER_TYPE_FIELD_DESC);
                oprot.writeI32(struct.ownerType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.catalogName != null && struct.isSetCatalogName()) {
                oprot.writeFieldBegin(CATALOG_NAME_FIELD_DESC);
                oprot.writeString(struct.catalogName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCreateTime()) {
                oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
                oprot.writeI32(struct.createTime);
                oprot.writeFieldEnd();
            }
            if (struct.managedLocationUri != null && struct.isSetManagedLocationUri()) {
                oprot.writeFieldBegin(MANAGED_LOCATION_URI_FIELD_DESC);
                oprot.writeString(struct.managedLocationUri);
                oprot.writeFieldEnd();
            }
            if (struct.type != null && struct.isSetType()) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeString(struct.type);
                oprot.writeFieldEnd();
            }
            if (struct.dataConnectorName != null && struct.isSetDataConnectorName()) {
                oprot.writeFieldBegin(DATA_CONNECTOR_NAME_FIELD_DESC);
                oprot.writeString(struct.dataConnectorName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class CreateDatabaseRequestStandardSchemeFactory
    implements SchemeFactory {
        private CreateDatabaseRequestStandardSchemeFactory() {
        }

        public CreateDatabaseRequestStandardScheme getScheme() {
            return new CreateDatabaseRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DATABASE_NAME(1, "databaseName"),
        DESCRIPTION(2, "description"),
        LOCATION_URI(3, "locationUri"),
        PARAMETERS(4, "parameters"),
        PRIVILEGES(5, "privileges"),
        OWNER_NAME(6, "ownerName"),
        OWNER_TYPE(7, "ownerType"),
        CATALOG_NAME(8, "catalogName"),
        CREATE_TIME(9, "createTime"),
        MANAGED_LOCATION_URI(10, "managedLocationUri"),
        TYPE(11, "type"),
        DATA_CONNECTOR_NAME(12, "dataConnectorName");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATABASE_NAME;
                }
                case 2: {
                    return DESCRIPTION;
                }
                case 3: {
                    return LOCATION_URI;
                }
                case 4: {
                    return PARAMETERS;
                }
                case 5: {
                    return PRIVILEGES;
                }
                case 6: {
                    return OWNER_NAME;
                }
                case 7: {
                    return OWNER_TYPE;
                }
                case 8: {
                    return CATALOG_NAME;
                }
                case 9: {
                    return CREATE_TIME;
                }
                case 10: {
                    return MANAGED_LOCATION_URI;
                }
                case 11: {
                    return TYPE;
                }
                case 12: {
                    return DATA_CONNECTOR_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

