/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RenamePartitionRequest
implements TBase<RenamePartitionRequest, _Fields>,
Serializable,
Cloneable,
Comparable<RenamePartitionRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("RenamePartitionRequest");
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 3);
    private static final TField PART_VALS_FIELD_DESC = new TField("partVals", 15, 4);
    private static final TField NEW_PART_FIELD_DESC = new TField("newPart", 12, 5);
    private static final TField VALID_WRITE_ID_LIST_FIELD_DESC = new TField("validWriteIdList", 11, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new RenamePartitionRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new RenamePartitionRequestTupleSchemeFactory();
    @Nullable
    private String catName;
    @Nullable
    private String dbName;
    @Nullable
    private String tableName;
    @Nullable
    private List<String> partVals;
    @Nullable
    private Partition newPart;
    @Nullable
    private String validWriteIdList;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CAT_NAME, _Fields.VALID_WRITE_ID_LIST};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public RenamePartitionRequest() {
    }

    public RenamePartitionRequest(String dbName, String tableName, List<String> partVals, Partition newPart) {
        this();
        this.dbName = dbName;
        this.tableName = tableName;
        this.partVals = partVals;
        this.newPart = newPart;
    }

    public RenamePartitionRequest(RenamePartitionRequest other) {
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetPartVals()) {
            ArrayList<String> __this__partVals = new ArrayList<String>(other.partVals);
            this.partVals = __this__partVals;
        }
        if (other.isSetNewPart()) {
            this.newPart = new Partition(other.newPart);
        }
        if (other.isSetValidWriteIdList()) {
            this.validWriteIdList = other.validWriteIdList;
        }
    }

    public RenamePartitionRequest deepCopy() {
        return new RenamePartitionRequest(this);
    }

    public void clear() {
        this.catName = null;
        this.dbName = null;
        this.tableName = null;
        this.partVals = null;
        this.newPart = null;
        this.validWriteIdList = null;
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public int getPartValsSize() {
        return this.partVals == null ? 0 : this.partVals.size();
    }

    @Nullable
    public Iterator<String> getPartValsIterator() {
        return this.partVals == null ? null : this.partVals.iterator();
    }

    public void addToPartVals(String elem) {
        if (this.partVals == null) {
            this.partVals = new ArrayList<String>();
        }
        this.partVals.add(elem);
    }

    @Nullable
    public List<String> getPartVals() {
        return this.partVals;
    }

    public void setPartVals(@Nullable List<String> partVals) {
        this.partVals = partVals;
    }

    public void unsetPartVals() {
        this.partVals = null;
    }

    public boolean isSetPartVals() {
        return this.partVals != null;
    }

    public void setPartValsIsSet(boolean value) {
        if (!value) {
            this.partVals = null;
        }
    }

    @Nullable
    public Partition getNewPart() {
        return this.newPart;
    }

    public void setNewPart(@Nullable Partition newPart) {
        this.newPart = newPart;
    }

    public void unsetNewPart() {
        this.newPart = null;
    }

    public boolean isSetNewPart() {
        return this.newPart != null;
    }

    public void setNewPartIsSet(boolean value) {
        if (!value) {
            this.newPart = null;
        }
    }

    @Nullable
    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(@Nullable String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public void unsetValidWriteIdList() {
        this.validWriteIdList = null;
    }

    public boolean isSetValidWriteIdList() {
        return this.validWriteIdList != null;
    }

    public void setValidWriteIdListIsSet(boolean value) {
        if (!value) {
            this.validWriteIdList = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case CAT_NAME: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case PART_VALS: {
                if (value == null) {
                    this.unsetPartVals();
                    break;
                }
                this.setPartVals((List)value);
                break;
            }
            case NEW_PART: {
                if (value == null) {
                    this.unsetNewPart();
                    break;
                }
                this.setNewPart((Partition)value);
                break;
            }
            case VALID_WRITE_ID_LIST: {
                if (value == null) {
                    this.unsetValidWriteIdList();
                    break;
                }
                this.setValidWriteIdList((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CAT_NAME: {
                return this.getCatName();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case PART_VALS: {
                return this.getPartVals();
            }
            case NEW_PART: {
                return this.getNewPart();
            }
            case VALID_WRITE_ID_LIST: {
                return this.getValidWriteIdList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CAT_NAME: {
                return this.isSetCatName();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case PART_VALS: {
                return this.isSetPartVals();
            }
            case NEW_PART: {
                return this.isSetNewPart();
            }
            case VALID_WRITE_ID_LIST: {
                return this.isSetValidWriteIdList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof RenamePartitionRequest) {
            return this.equals((RenamePartitionRequest)that);
        }
        return false;
    }

    public boolean equals(RenamePartitionRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_partVals = this.isSetPartVals();
        boolean that_present_partVals = that.isSetPartVals();
        if (this_present_partVals || that_present_partVals) {
            if (!this_present_partVals || !that_present_partVals) {
                return false;
            }
            if (!this.partVals.equals(that.partVals)) {
                return false;
            }
        }
        boolean this_present_newPart = this.isSetNewPart();
        boolean that_present_newPart = that.isSetNewPart();
        if (this_present_newPart || that_present_newPart) {
            if (!this_present_newPart || !that_present_newPart) {
                return false;
            }
            if (!this.newPart.equals(that.newPart)) {
                return false;
            }
        }
        boolean this_present_validWriteIdList = this.isSetValidWriteIdList();
        boolean that_present_validWriteIdList = that.isSetValidWriteIdList();
        if (this_present_validWriteIdList || that_present_validWriteIdList) {
            if (!this_present_validWriteIdList || !that_present_validWriteIdList) {
                return false;
            }
            if (!this.validWriteIdList.equals(that.validWriteIdList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartVals() ? 131071 : 524287);
        if (this.isSetPartVals()) {
            hashCode = hashCode * 8191 + this.partVals.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetNewPart() ? 131071 : 524287);
        if (this.isSetNewPart()) {
            hashCode = hashCode * 8191 + this.newPart.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValidWriteIdList() ? 131071 : 524287);
        if (this.isSetValidWriteIdList()) {
            hashCode = hashCode * 8191 + this.validWriteIdList.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(RenamePartitionRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartVals(), other.isSetPartVals());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartVals() && (lastComparison = TBaseHelper.compareTo(this.partVals, other.partVals)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNewPart(), other.isSetNewPart());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNewPart() && (lastComparison = TBaseHelper.compareTo((Comparable)this.newPart, (Comparable)other.newPart)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetValidWriteIdList(), other.isSetValidWriteIdList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidWriteIdList() && (lastComparison = TBaseHelper.compareTo((String)this.validWriteIdList, (String)other.validWriteIdList)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        RenamePartitionRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        RenamePartitionRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RenamePartitionRequest(");
        boolean first = true;
        if (this.isSetCatName()) {
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partVals:");
        if (this.partVals == null) {
            sb.append("null");
        } else {
            sb.append(this.partVals);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("newPart:");
        if (this.newPart == null) {
            sb.append("null");
        } else {
            sb.append(this.newPart);
        }
        first = false;
        if (this.isSetValidWriteIdList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("validWriteIdList:");
            if (this.validWriteIdList == null) {
                sb.append("null");
            } else {
                sb.append(this.validWriteIdList);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTableName()) {
            throw new TProtocolException("Required field 'tableName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetPartVals()) {
            throw new TProtocolException("Required field 'partVals' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNewPart()) {
            throw new TProtocolException("Required field 'newPart' is unset! Struct:" + this.toString());
        }
        if (this.newPart != null) {
            this.newPart.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PART_VALS, new FieldMetaData("partVals", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.NEW_PART, new FieldMetaData("newPart", 1, (FieldValueMetaData)new StructMetaData(12, Partition.class)));
        tmpMap.put(_Fields.VALID_WRITE_ID_LIST, new FieldMetaData("validWriteIdList", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(RenamePartitionRequest.class, metaDataMap);
    }

    private static class RenamePartitionRequestTupleScheme
    extends TupleScheme<RenamePartitionRequest> {
        private RenamePartitionRequestTupleScheme() {
        }

        public void write(TProtocol prot, RenamePartitionRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tableName);
            oprot.writeI32(struct.partVals.size());
            for (String _iter1290 : struct.partVals) {
                oprot.writeString(_iter1290);
            }
            struct.newPart.write((TProtocol)oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetCatName()) {
                optionals.set(0);
            }
            if (struct.isSetValidWriteIdList()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetValidWriteIdList()) {
                oprot.writeString(struct.validWriteIdList);
            }
        }

        public void read(TProtocol prot, RenamePartitionRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tableName = iprot.readString();
            struct.setTableNameIsSet(true);
            TList _list1291 = iprot.readListBegin((byte)11);
            struct.partVals = new ArrayList(_list1291.size);
            for (int _i1293 = 0; _i1293 < _list1291.size; ++_i1293) {
                String _elem1292 = iprot.readString();
                struct.partVals.add(_elem1292);
            }
            struct.setPartValsIsSet(true);
            struct.newPart = new Partition();
            struct.newPart.read((TProtocol)iprot);
            struct.setNewPartIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.validWriteIdList = iprot.readString();
                struct.setValidWriteIdListIsSet(true);
            }
        }
    }

    private static class RenamePartitionRequestTupleSchemeFactory
    implements SchemeFactory {
        private RenamePartitionRequestTupleSchemeFactory() {
        }

        public RenamePartitionRequestTupleScheme getScheme() {
            return new RenamePartitionRequestTupleScheme();
        }
    }

    private static class RenamePartitionRequestStandardScheme
    extends StandardScheme<RenamePartitionRequest> {
        private RenamePartitionRequestStandardScheme() {
        }

        public void read(TProtocol iprot, RenamePartitionRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list1286 = iprot.readListBegin();
                            struct.partVals = new ArrayList(_list1286.size);
                            for (int _i1288 = 0; _i1288 < _list1286.size; ++_i1288) {
                                String _elem1287 = iprot.readString();
                                struct.partVals.add(_elem1287);
                            }
                            iprot.readListEnd();
                            struct.setPartValsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.newPart = new Partition();
                            struct.newPart.read(iprot);
                            struct.setNewPartIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.validWriteIdList = iprot.readString();
                            struct.setValidWriteIdListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, RenamePartitionRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.partVals != null) {
                oprot.writeFieldBegin(PART_VALS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.partVals.size()));
                for (String _iter1289 : struct.partVals) {
                    oprot.writeString(_iter1289);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.newPart != null) {
                oprot.writeFieldBegin(NEW_PART_FIELD_DESC);
                struct.newPart.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.validWriteIdList != null && struct.isSetValidWriteIdList()) {
                oprot.writeFieldBegin(VALID_WRITE_ID_LIST_FIELD_DESC);
                oprot.writeString(struct.validWriteIdList);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class RenamePartitionRequestStandardSchemeFactory
    implements SchemeFactory {
        private RenamePartitionRequestStandardSchemeFactory() {
        }

        public RenamePartitionRequestStandardScheme getScheme() {
            return new RenamePartitionRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CAT_NAME(1, "catName"),
        DB_NAME(2, "dbName"),
        TABLE_NAME(3, "tableName"),
        PART_VALS(4, "partVals"),
        NEW_PART(5, "newPart"),
        VALID_WRITE_ID_LIST(6, "validWriteIdList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CAT_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return TABLE_NAME;
                }
                case 4: {
                    return PART_VALS;
                }
                case 5: {
                    return NEW_PART;
                }
                case 6: {
                    return VALID_WRITE_ID_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

