/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Warehouse {
    public static final String DEFAULT_CATALOG_NAME = "hive";
    public static final String DEFAULT_CATALOG_COMMENT = "Default catalog, for Hive";
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final String DEFAULT_DATABASE_COMMENT = "Default Hive database";
    public static final String DEFAULT_SERIALIZATION_FORMAT = "1";
    public static final String DATABASE_WAREHOUSE_SUFFIX = ".db";
    private static final String CAT_DB_TABLE_SEPARATOR = ".";
    private Path whRoot;
    private Path whRootExternal;
    private final Configuration conf;
    private final String whRootString;
    private final String whRootExternalString;
    private final boolean isTenantBasedStorage;
    public static final Logger LOG = LoggerFactory.getLogger((String)"hive.metastore.warehouse");
    private MetaStoreFS fsHandler = null;
    private boolean storageAuthCheck = false;
    private ReplChangeManager cm = null;
    static final Pattern pat = Pattern.compile("([^/]+)=([^/]+)");
    private static final Pattern slash = Pattern.compile("/");

    public Warehouse(Configuration conf) throws MetaException {
        this.conf = conf;
        this.whRootString = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.WAREHOUSE);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.whRootString)) {
            throw new MetaException(MetastoreConf.ConfVars.WAREHOUSE.getVarname() + " is not set in the config or blank");
        }
        this.whRootExternalString = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL);
        this.fsHandler = this.getMetaStoreFsHandler(conf);
        this.cm = ReplChangeManager.getInstance(conf);
        this.storageAuthCheck = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.AUTHORIZATION_STORAGE_AUTH_CHECKS);
        this.isTenantBasedStorage = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.ALLOW_TENANT_BASED_STORAGE);
    }

    private MetaStoreFS getMetaStoreFsHandler(Configuration conf) throws MetaException {
        String handlerClassStr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.FS_HANDLER_CLS);
        try {
            Class<?> handlerClass = Class.forName(handlerClassStr, true, JavaUtils.getClassLoader());
            MetaStoreFS handler = (MetaStoreFS)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return handler;
        }
        catch (ClassNotFoundException e) {
            throw new MetaException("Error in loading MetaStoreFS handler." + e.getMessage());
        }
    }

    public static FileSystem getFs(Path f, Configuration conf) throws MetaException {
        try {
            return f.getFileSystem(conf);
        }
        catch (IOException e) {
            MetaStoreUtils.throwMetaException(e);
            return null;
        }
    }

    public FileSystem getFs(Path f) throws MetaException {
        return Warehouse.getFs(f, this.conf);
    }

    public static Path getDnsPath(Path path, Configuration conf) throws MetaException {
        if (Warehouse.isBlobStorageScheme(conf, path.toUri().getScheme())) {
            String scheme = path.toUri().getScheme();
            String authority = path.toUri().getAuthority();
            URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
            if (authority == null && scheme == null || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)scheme, (CharSequence)defaultUri.getScheme())) {
                String uriPath;
                if (authority == null) {
                    authority = defaultUri.getAuthority();
                }
                if (scheme == null) {
                    scheme = defaultUri.getScheme();
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(uriPath = path.toUri().getPath()))) {
                    uriPath = "/";
                }
                return new Path(scheme, authority, uriPath);
            }
            return path;
        }
        FileSystem fs = Warehouse.getFs(path, conf);
        String uriPath = path.toUri().getPath();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)uriPath)) {
            uriPath = "/";
        }
        return new Path(fs.getUri().getScheme(), fs.getUri().getAuthority(), uriPath);
    }

    private static boolean isBlobStorageScheme(Configuration conf, String scheme) {
        String uriScheme = scheme == null ? FileSystem.getDefaultUri((Configuration)conf).getScheme() : scheme;
        return MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.HIVE_BLOBSTORE_SUPPORTED_SCHEMES).stream().anyMatch(each -> each.equalsIgnoreCase(uriScheme));
    }

    public Path getDnsPath(Path path) throws MetaException {
        return Warehouse.getDnsPath(path, this.conf);
    }

    public Path getWhRoot() throws MetaException {
        if (this.whRoot != null) {
            return this.whRoot;
        }
        this.whRoot = this.getDnsPath(new Path(this.whRootString));
        return this.whRoot;
    }

    public Path getWhRootExternal() throws MetaException {
        if (this.whRootExternal != null) {
            return this.whRootExternal;
        }
        this.whRootExternal = !this.hasExternalWarehouseRoot() ? this.getWhRoot() : this.getDnsPath(new Path(this.whRootExternalString));
        return this.whRootExternal;
    }

    public Path determineDatabasePath(Catalog cat, Database db) throws MetaException {
        if (db.getType() == DatabaseType.REMOTE) {
            return this.getDefaultDatabasePath(db.getName(), true);
        }
        if (db.isSetLocationUri()) {
            return this.getDnsPath(new Path(db.getLocationUri()));
        }
        if (cat == null || cat.getName().equalsIgnoreCase(DEFAULT_CATALOG_NAME)) {
            if (db.getName().equalsIgnoreCase(DEFAULT_DATABASE_NAME)) {
                return this.getWhRootExternal();
            }
            return new Path(this.getWhRootExternal(), this.dbDirFromDbName(db));
        }
        return new Path(this.getDnsPath(new Path(cat.getLocationUri())), this.dbDirFromDbName(db));
    }

    private String dbDirFromDbName(Database db) throws MetaException {
        return db.getName().toLowerCase() + DATABASE_WAREHOUSE_SUFFIX;
    }

    public Path getDatabasePath(Database db) throws MetaException {
        if (db.getManagedLocationUri() != null) {
            return this.getDnsPath(new Path(db.getManagedLocationUri()));
        }
        if (db.getCatalogName().equalsIgnoreCase(DEFAULT_CATALOG_NAME) && db.getName().equalsIgnoreCase(DEFAULT_DATABASE_NAME)) {
            return this.getWhRoot();
        }
        return new Path(db.getLocationUri());
    }

    public Path getDatabaseExternalPath(Database db) throws MetaException {
        Path dbPath = new Path(db.getLocationUri());
        if (FileUtils.isSubdirectory(this.getWhRoot().toString(), dbPath.toString() + "/")) {
            dbPath = this.getDefaultExternalDatabasePath(db.getName());
        }
        return this.getDnsPath(dbPath);
    }

    public Path getDatabaseManagedPath(Database db) throws MetaException {
        if (db.getManagedLocationUri() != null) {
            return this.getDnsPath(new Path(db.getManagedLocationUri()));
        }
        if (!db.getCatalogName().equalsIgnoreCase(DEFAULT_CATALOG_NAME)) {
            return new Path(db.getLocationUri());
        }
        if (db.getName().equalsIgnoreCase(DEFAULT_DATABASE_NAME)) {
            return this.getWhRoot();
        }
        return new Path(this.getWhRoot(), db.getName().toLowerCase() + DATABASE_WAREHOUSE_SUFFIX);
    }

    public Path getDefaultDatabasePath(String dbName) throws MetaException {
        return this.getDefaultDatabasePath(dbName, false);
    }

    public Path getDefaultExternalDatabasePath(String dbName) throws MetaException {
        return this.getDefaultDatabasePath(dbName, true);
    }

    public Path getDefaultDatabasePath(String dbName, boolean inExternalWH) throws MetaException {
        if (inExternalWH) {
            if (dbName.equalsIgnoreCase(DEFAULT_DATABASE_NAME)) {
                return this.getWhRootExternal();
            }
            return new Path(this.getWhRootExternal(), dbName.toLowerCase() + DATABASE_WAREHOUSE_SUFFIX);
        }
        if (dbName.equalsIgnoreCase(DEFAULT_DATABASE_NAME)) {
            return this.getWhRoot();
        }
        return new Path(this.getWhRoot(), dbName.toLowerCase() + DATABASE_WAREHOUSE_SUFFIX);
    }

    private boolean hasExternalWarehouseRoot() {
        return !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.whRootExternalString);
    }

    @Deprecated
    public Path getDefaultTablePath(Database db, String tableName) throws MetaException {
        return this.getDefaultTablePath(db, tableName, true);
    }

    public Path getDefaultTablePath(Database db, String tableName, boolean isExternal) throws MetaException {
        Path dbPath = null;
        if (isExternal) {
            dbPath = new Path(db.getLocationUri());
            if (FileUtils.isSubdirectory(this.getWhRoot().toString(), dbPath.toString()) || this.getWhRoot().equals((Object)dbPath)) {
                dbPath = this.getDefaultExternalDatabasePath(db.getName());
            }
        } else {
            dbPath = this.getDatabaseManagedPath(db);
        }
        if (!isExternal && tableName.matches("(.*)\\.v\\d+")) {
            String[] groups = tableName.split("\\.v");
            tableName = String.join((CharSequence)".v", MetaStoreUtils.encodeTableName(groups[0].toLowerCase()), groups[1]);
        } else {
            tableName = MetaStoreUtils.encodeTableName(tableName.toLowerCase());
        }
        return this.getDnsPath(new Path(dbPath, tableName));
    }

    public Path getDefaultManagedTablePath(Database db, String tableName) throws MetaException {
        Path dbPath = this.getDatabaseManagedPath(db);
        return this.getDnsPath(new Path(dbPath, MetaStoreUtils.encodeTableName(tableName.toLowerCase())));
    }

    public Path getDefaultTablePath(String dbName, String tableName, boolean isExternal) throws MetaException {
        Path dbPath = null;
        dbPath = isExternal && this.hasExternalWarehouseRoot() ? this.getDefaultExternalDatabasePath(dbName) : this.getDefaultDatabasePath(dbName);
        return this.getDnsPath(new Path(dbPath, MetaStoreUtils.encodeTableName(tableName.toLowerCase())));
    }

    public Path getDefaultTablePath(Database db, Table table) throws MetaException {
        return this.getDefaultTablePath(db, table.getTableName(), MetaStoreUtils.isExternalTable(table));
    }

    @Deprecated
    public static String getQualifiedName(Table table) {
        return TableName.getDbTable((String)table.getDbName(), (String)table.getTableName());
    }

    @Deprecated
    public static String getQualifiedName(String dbName, String tableName) {
        return TableName.getDbTable((String)dbName, (String)tableName);
    }

    public static String getQualifiedName(Partition partition) {
        return partition.getDbName() + CAT_DB_TABLE_SEPARATOR + partition.getTableName() + partition.getValues();
    }

    public static String getCatalogQualifiedTableName(Table table) {
        return TableName.getQualified((String)table.getCatName(), (String)table.getDbName(), (String)table.getTableName());
    }

    public boolean mkdirs(Path f) throws MetaException {
        try {
            FileSystem fs = this.getFs(f);
            return FileUtils.mkdir(fs, f);
        }
        catch (IOException e) {
            MetaStoreUtils.throwMetaException(e);
            return false;
        }
    }

    public boolean renameDir(Path sourcePath, Path destPath, boolean needCmRecycle) throws MetaException {
        try {
            if (needCmRecycle) {
                this.cm.recycle(sourcePath, ReplChangeManager.RecycleType.COPY, true);
            }
            FileSystem srcFs = this.getFs(sourcePath);
            FileSystem destFs = this.getFs(destPath);
            return FileUtils.rename(srcFs, destFs, sourcePath, destPath);
        }
        catch (Exception ex) {
            MetaStoreUtils.throwMetaException(ex);
            return false;
        }
    }

    public boolean copyDir(Path sourcePath, Path destPath, boolean needCmRecycle) throws MetaException {
        try {
            if (needCmRecycle) {
                this.cm.recycle(sourcePath, ReplChangeManager.RecycleType.COPY, true);
            }
            FileSystem srcFs = this.getFs(sourcePath);
            FileSystem destFs = this.getFs(destPath);
            return FileUtils.copy(srcFs, sourcePath, destFs, destPath, false, false, this.conf);
        }
        catch (Exception ex) {
            MetaStoreUtils.throwMetaException(ex);
            return false;
        }
    }

    void addToChangeManagement(Path file) throws MetaException {
        try {
            this.cm.recycle(file, ReplChangeManager.RecycleType.COPY, true);
        }
        catch (IOException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
    }

    public boolean deleteDir(Path f, boolean recursive, Database db) throws MetaException {
        return this.deleteDir(f, recursive, false, db);
    }

    public boolean deleteDir(Path f, boolean recursive, boolean ifPurge, Database db) throws MetaException {
        return this.deleteDir(f, recursive, ifPurge, ReplChangeManager.isSourceOfReplication(db));
    }

    public boolean deleteDir(Path f, boolean recursive, boolean ifPurge, boolean needCmRecycle) throws MetaException {
        if (needCmRecycle) {
            try {
                this.cm.recycle(f, ReplChangeManager.RecycleType.MOVE, ifPurge);
            }
            catch (IOException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
        }
        FileSystem fs = this.getFs(f);
        return this.fsHandler.deleteDir(fs, f, recursive, ifPurge, this.conf);
    }

    public void recycleDirToCmPath(Path f, boolean ifPurge) throws MetaException {
        try {
            this.cm.recycle(f, ReplChangeManager.RecycleType.MOVE, ifPurge);
        }
        catch (IOException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
    }

    public boolean isEmptyDir(Path path) throws IOException, MetaException {
        try {
            int listCount = this.getFs(path).listStatus(path).length;
            if (listCount == 0) {
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        return false;
    }

    public boolean isWritable(Path path) throws IOException {
        if (!this.storageAuthCheck) {
            return true;
        }
        if (path == null) {
            return false;
        }
        try {
            FileSystem fs = this.getFs(path);
            FileStatus stat = fs.getFileStatus(path);
            HdfsUtils.checkFileAccess(fs, stat, FsAction.WRITE);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception when checking if path (" + path + ")", (Throwable)e);
            }
            return false;
        }
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path);
    }

    private static String unescapePathName(String path) {
        return FileUtils.unescapePathName(path);
    }

    public static String makePartPath(Map<String, String> spec) throws MetaException {
        return Warehouse.makePartName(spec, true);
    }

    public static String makePartNameUtil(Map<String, String> spec, boolean addTrailingSeperator, boolean dynamic) throws MetaException {
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() == 0) {
                if (dynamic) break;
                throw new MetaException("Partition spec is incorrect. " + spec);
            }
            if (i > 0) {
                suffixBuf.append("/");
            }
            suffixBuf.append(Warehouse.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(Warehouse.escapePathName(e.getValue()));
            ++i;
        }
        if (addTrailingSeperator && i > 0) {
            suffixBuf.append("/");
        }
        return suffixBuf.toString();
    }

    public static String makePartName(Map<String, String> spec, boolean addTrailingSeperator) throws MetaException {
        return Warehouse.makePartNameUtil(spec, addTrailingSeperator, false);
    }

    public static String makeDynamicPartName(Map<String, String> spec) {
        String partName = null;
        try {
            partName = Warehouse.makePartNameUtil(spec, true, true);
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        return partName;
    }

    public static String makeDynamicPartNameNoTrailingSeperator(Map<String, String> spec) {
        String partName = null;
        try {
            partName = Warehouse.makePartNameUtil(spec, false, true);
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        return partName;
    }

    public static AbstractList<String> makeValsFromName(String name, AbstractList<String> result) throws MetaException {
        int i;
        assert (name != null);
        String[] parts = slash.split(name, 0);
        if (result == null) {
            result = new ArrayList<String>(parts.length);
            for (i = 0; i < parts.length; ++i) {
                result.add(null);
            }
        } else if (parts.length != result.size()) {
            throw new MetaException("Expected " + result.size() + " components, got " + parts.length + " (" + name + ")");
        }
        for (i = 0; i < parts.length; ++i) {
            int eq = parts[i].indexOf(61);
            if (eq <= 0) {
                throw new MetaException("Unexpected component " + parts[i]);
            }
            result.set(i, Warehouse.unescapePathName(parts[i].substring(eq + 1)));
        }
        return result;
    }

    public static LinkedHashMap<String, String> makeSpecFromName(String name) throws MetaException {
        if (name == null || name.isEmpty()) {
            throw new MetaException("Partition name is invalid. " + name);
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        Warehouse.makeSpecFromName(partSpec, new Path(name), null);
        return partSpec;
    }

    public static boolean makeSpecFromName(Map<String, String> partSpec, Path currPath, Set<String> requiredKeys) {
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        do {
            String component;
            Matcher m;
            if (!(m = pat.matcher(component = currPath.getName())).matches()) continue;
            String k = Warehouse.unescapePathName(m.group(1));
            String v = Warehouse.unescapePathName(m.group(2));
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            String key = ((String[])kvs.get(i - 1))[0];
            if (requiredKeys != null) {
                requiredKeys.remove(key);
            }
            partSpec.put(key, ((String[])kvs.get(i - 1))[1]);
        }
        if (requiredKeys == null || requiredKeys.isEmpty()) {
            return true;
        }
        LOG.warn("Cannot create partition spec from " + currPath + "; missing keys " + requiredKeys);
        return false;
    }

    public static Map<String, String> makeEscSpecFromName(String name) throws MetaException {
        if (name == null || name.isEmpty()) {
            throw new MetaException("Partition name is invalid. " + name);
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        Path currPath = new Path(name);
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        do {
            String component;
            Matcher m;
            if (!(m = pat.matcher(component = currPath.getName())).matches()) continue;
            String k = m.group(1);
            String v = m.group(2);
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            partSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
        return partSpec;
    }

    public Path getDefaultPartitionPath(Database db, Table table, Map<String, String> pm) throws MetaException {
        return this.getPartitionPath(this.getDefaultTablePath(db, table), pm);
    }

    public Path getPartitionPath(Path tblPath, Map<String, String> pm) throws MetaException {
        return new Path(tblPath, Warehouse.makePartPath(pm));
    }

    public Path getPartitionPath(Database db, Table table, List<String> vals) throws MetaException {
        List<FieldSchema> partKeys = table.getPartitionKeys();
        if (partKeys == null || partKeys.size() != vals.size()) {
            throw new MetaException("Invalid number of partition keys found for " + table.getTableName());
        }
        LinkedHashMap<String, String> pm = new LinkedHashMap<String, String>(vals.size());
        int i = 0;
        for (FieldSchema key : partKeys) {
            pm.put(key.getName(), vals.get(i));
            ++i;
        }
        if (table.getSd().getLocation() != null) {
            return this.getPartitionPath(this.getDnsPath(new Path(table.getSd().getLocation())), pm);
        }
        return this.getDefaultPartitionPath(db, table, pm);
    }

    public boolean isDir(Path f) throws MetaException {
        try {
            FileSystem fs = this.getFs(f);
            FileStatus fstatus = fs.getFileStatus(f);
            if (!fstatus.isDir()) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            MetaStoreUtils.throwMetaException(e);
        }
        return true;
    }

    public static String makePartName(List<FieldSchema> partCols, List<String> vals) throws MetaException {
        return Warehouse.makePartName(partCols, vals, null);
    }

    public List<FileStatus> getFileStatusesForSD(StorageDescriptor desc) throws MetaException {
        return this.getFileStatusesForLocation(desc.getLocation());
    }

    public List<FileStatus> getFileStatusesForLocation(String location) throws MetaException {
        try {
            Path path = new Path(location);
            FileSystem fileSys = path.getFileSystem(this.conf);
            return FileUtils.getFileStatusRecurse(path, fileSys);
        }
        catch (IOException ioe) {
            MetaStoreUtils.throwMetaException(ioe);
            return null;
        }
    }

    public List<FileStatus> getFileStatusesForUnpartitionedTable(Database db, Table table) throws MetaException {
        Path tablePath = this.getDnsPath(new Path(table.getSd().getLocation()));
        try {
            FileSystem fileSys = tablePath.getFileSystem(this.conf);
            return FileUtils.getFileStatusRecurse(tablePath, fileSys);
        }
        catch (IOException ioe) {
            MetaStoreUtils.throwMetaException(ioe);
            return null;
        }
    }

    public static String makePartName(List<FieldSchema> partCols, List<String> vals, String defaultStr) throws MetaException {
        if (partCols.size() != vals.size() || partCols.size() == 0) {
            StringBuilder errorStrBuilder = new StringBuilder("Invalid partition key & values; keys [");
            for (FieldSchema fs : partCols) {
                errorStrBuilder.append(fs.getName()).append(", ");
            }
            errorStrBuilder.append("], values [");
            for (String val : vals) {
                errorStrBuilder.append(val).append(", ");
            }
            throw new MetaException(errorStrBuilder.append("]").toString());
        }
        ArrayList<String> colNames = new ArrayList<String>();
        for (FieldSchema col : partCols) {
            colNames.add(col.getName());
        }
        return FileUtils.makePartName(colNames, vals, defaultStr);
    }

    public static List<String> getPartValuesFromPartName(String partName) throws MetaException {
        LinkedHashMap<String, String> partSpec = Warehouse.makeSpecFromName(partName);
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(partSpec.values());
        return values;
    }

    public static Map<String, String> makeSpecFromValues(List<FieldSchema> partCols, List<String> values) {
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        for (int i = 0; i < values.size(); ++i) {
            spec.put(partCols.get(i).getName(), values.get(i));
        }
        return spec;
    }
}

