/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JavaUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> clazz) throws MetaException {
        try {
            return Class.forName(className, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetaException(className + " class not found");
        }
    }

    public static <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        if (parameterTypes.length != initargs.length) {
            throw new IllegalArgumentException("Number of constructor parameter types doesn't match number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class clazz = ClassUtils.primitiveToWrapper(parameterTypes[i]);
            if (initargs[i] == null || clazz.isInstance(initargs[i])) continue;
            throw new IllegalArgumentException("Object : " + initargs[i] + " is not an instance of " + clazz);
        }
        try {
            Constructor<T> meth = theClass.getDeclaredConstructor(parameterTypes);
            meth.setAccessible(true);
            return meth.newInstance(initargs);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> theClass) {
        try {
            return theClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String lockIdToString(long extLockId) {
        return "lockid:" + extLockId;
    }

    public static String txnIdToString(long txnId) {
        return "txnid:" + txnId;
    }
}

