/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestAppendPartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "test_append_part_db";
    private static Table tableWithPartitions;
    private static Table externalTable;
    private static Table tableNoPartColumns;
    private static Table tableView;

    public TestAppendPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(DB_NAME).create(this.client, this.metaStore.getConf());
        tableWithPartitions = this.createTableWithPartitions();
        externalTable = this.createExternalTable();
        tableNoPartColumns = this.createTableNoPartitionColumns();
        tableView = this.createView();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testAppendPartition() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        Table table = tableWithPartitions;
        Partition appendedPart = this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
        Assert.assertNotNull((Object)appendedPart);
        Partition partition = this.client.getPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
        Assert.assertEquals((Object)partition, (Object)appendedPart);
        this.verifyPartition(partition, table, partitionValues, "year=2017/month=may");
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=march", "year=2017/month=april", "year=2018/month=march", "year=2017/month=may"}));
    }

    @Test
    public void testAppendPartitionToExternalTable() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        Table table = externalTable;
        Partition appendedPart = this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
        Assert.assertNotNull((Object)appendedPart);
        Partition partition = this.client.getPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
        Assert.assertEquals((Object)partition, (Object)appendedPart);
        this.verifyPartition(partition, table, partitionValues, "year=2017/month=may");
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=may"}));
    }

    @Test
    public void testAppendPartitionMultiplePartitions() throws Exception {
        ArrayList partitionValues1 = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        ArrayList partitionValues2 = Lists.newArrayList((Object[])new String[]{"2018", "may"});
        ArrayList partitionValues3 = Lists.newArrayList((Object[])new String[]{"2017", "june"});
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues1);
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues2);
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues3);
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=may", "year=2018/month=may", "year=2017/month=june", "year=2017/month=march", "year=2017/month=april", "year=2018/month=march"}));
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionToTableWithoutPartCols() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        Table table = tableNoPartColumns;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionToView() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        Table table = tableView;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testAppendPartitionAlreadyExists() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "april"});
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionNonExistingDB() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition("nonexistingdb", tableWithPartitions.getTableName(), (List)partitionValues);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionNonExistingTable() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition(tableWithPartitions.getDbName(), "nonexistingtable", (List)partitionValues);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionEmptyDB() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition("", tableWithPartitions.getTableName(), (List)partitionValues);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionEmptyTable() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition(tableWithPartitions.getDbName(), "", (List)partitionValues);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionNullDB() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition(null, tableWithPartitions.getTableName(), (List)partitionValues);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionNullTable() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2017", "may"});
        this.client.appendPartition(tableWithPartitions.getDbName(), null, (List)partitionValues);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionEmptyPartValues() throws Exception {
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), new ArrayList());
    }

    @Test(expected=MetaException.class)
    public void testAppendPartitionNullPartValues() throws Exception {
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (List)null);
    }

    @Test
    public void testAppendPartitionLessPartValues() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2019"});
        Table table = tableWithPartitions;
        try {
            this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=march", "year=2017/month=april", "year=2018/month=march"}));
        String partitionLocation = table.getSd().getLocation() + "/year=2019";
        Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partitionLocation)));
    }

    @Test
    public void testAppendPartitionMorePartValues() throws Exception {
        ArrayList partitionValues = Lists.newArrayList((Object[])new String[]{"2019", "march", "12"});
        Table table = tableWithPartitions;
        try {
            this.client.appendPartition(table.getDbName(), table.getTableName(), (List)partitionValues);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=march", "year=2017/month=april", "year=2018/month=march"}));
        String partitionLocation = tableWithPartitions.getSd().getLocation() + "/year=2019";
        Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partitionLocation)));
    }

    @Test
    public void testAppendPart() throws Exception {
        Table table = tableWithPartitions;
        String partitionName = "year=2017/month=may";
        Partition appendedPart = this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
        Assert.assertNotNull((Object)appendedPart);
        Partition partition = this.client.getPartition(table.getDbName(), table.getTableName(), TestAppendPartitions.getPartitionValues(partitionName));
        Assert.assertEquals((Object)partition, (Object)appendedPart);
        this.verifyPartition(partition, table, TestAppendPartitions.getPartitionValues(partitionName), partitionName);
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{"year=2017/month=march", "year=2017/month=april", "year=2018/month=march", partitionName}));
    }

    @Test
    public void testAppendPartToExternalTable() throws Exception {
        Table table = externalTable;
        String partitionName = "year=2017/month=may";
        Partition appendedPart = this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
        Assert.assertNotNull((Object)appendedPart);
        Partition partition = this.client.getPartition(table.getDbName(), table.getTableName(), TestAppendPartitions.getPartitionValues(partitionName));
        Assert.assertEquals((Object)partition, (Object)appendedPart);
        this.verifyPartition(partition, table, TestAppendPartitions.getPartitionValues(partitionName), partitionName);
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{partitionName}));
    }

    @Test
    public void testAppendPartMultiplePartitions() throws Exception {
        String partitionName1 = "year=2017/month=may";
        String partitionName2 = "year=2018/month=may";
        String partitionName3 = "year=2017/month=june";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName1);
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName2);
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName3);
        this.verifyPartitionNames(table, Lists.newArrayList((Object[])new String[]{partitionName1, partitionName2, partitionName3, "year=2017/month=march", "year=2017/month=april", "year=2018/month=march"}));
    }

    @Test(expected=MetaException.class)
    public void testAppendPartToTableWithoutPartCols() throws Exception {
        String partitionName = "year=2017/month=may";
        Table table = tableNoPartColumns;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartToView() throws Exception {
        String partitionName = "year=2017/month=may";
        Table table = tableView;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testAppendPartAlreadyExists() throws Exception {
        String partitionName = "year=2017/month=april";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartNonExistingDB() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition("nonexistingdb", tableWithPartitions.getTableName(), partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartNonExistingTable() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition(tableWithPartitions.getDbName(), "nonexistingtable", partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartEmptyDB() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition("", tableWithPartitions.getTableName(), partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartEmptyTable() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition(tableWithPartitions.getDbName(), "", partitionName);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartNullDB() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition(null, tableWithPartitions.getTableName(), partitionName);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartNullTable() throws Exception {
        String partitionName = "year=2017/month=april";
        this.client.appendPartition(tableWithPartitions.getDbName(), null, partitionName);
    }

    @Test(expected=MetaException.class)
    public void testAppendPartEmptyPartName() throws Exception {
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), "");
    }

    @Test(expected=MetaException.class)
    public void testAppendPartNullPartName() throws Exception {
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), (String)null);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartLessPartValues() throws Exception {
        String partitionName = "year=2019";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test
    public void testAppendPartMorePartValues() throws Exception {
        String partitionName = "year=2019/month=march/day=12";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartInvalidPartName() throws Exception {
        String partitionName = "invalidpartname";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartWrongColumnInPartName() throws Exception {
        String partitionName = "year=2019/honap=march";
        Table table = tableWithPartitions;
        this.client.appendPartition(table.getDbName(), table.getTableName(), partitionName);
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "append_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "append_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").create(this.client, this.metaStore.getConf());
        Partition created = this.client.appendPartition(catName, dbName, tableName, Collections.singletonList("a1"));
        Assert.assertEquals((long)1L, (long)created.getValuesSize());
        Assert.assertEquals((Object)"a1", created.getValues().get(0));
        Partition fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a1"));
        Assert.assertEquals((Object)created, (Object)fetched);
        created = this.client.appendPartition(catName, dbName, tableName, "partcol=a2");
        Assert.assertEquals((long)1L, (long)created.getValuesSize());
        Assert.assertEquals((Object)"a2", created.getValues().get(0));
        fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a2"));
        Assert.assertEquals((Object)created, (Object)fetched);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionBogusCatalog() throws Exception {
        this.client.appendPartition("nosuch", DB_NAME, tableWithPartitions.getTableName(), (List)Lists.newArrayList((Object[])new String[]{"2017", "may"}));
    }

    @Test(expected=InvalidObjectException.class)
    public void testAppendPartitionByNameBogusCatalog() throws Exception {
        this.client.appendPartition("nosuch", DB_NAME, tableWithPartitions.getTableName(), "year=2017/month=april");
    }

    private Table createTableWithPartitions() throws Exception {
        Table table = this.createTable("test_append_part_table_with_parts", TestAppendPartitions.getYearAndMonthPartCols(), null, TableType.MANAGED_TABLE.name(), this.metaStore.getWarehouseRoot() + "/test_append_part_table_with_parts");
        this.createPartition(table, Lists.newArrayList((Object[])new String[]{"2017", "march"}));
        this.createPartition(table, Lists.newArrayList((Object[])new String[]{"2017", "april"}));
        this.createPartition(table, Lists.newArrayList((Object[])new String[]{"2018", "march"}));
        return table;
    }

    private Table createTableNoPartitionColumns() throws Exception {
        Table table = this.createTable("test_append_part_table_no_part_columns", null, null, "MANAGED_TABLE", this.metaStore.getWarehouseRoot() + "/test_append_part_table_no_part_columns");
        return table;
    }

    private Table createExternalTable() throws Exception {
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "TRUE");
        Table table = this.createTable("test_append_part_external_table", TestAppendPartitions.getYearAndMonthPartCols(), tableParams, TableType.EXTERNAL_TABLE.name(), this.metaStore.getWarehouseRoot() + "/test_append_part_external_table");
        return table;
    }

    private Table createView() throws Exception {
        Table table = this.createTable("test_append_part_table_view", TestAppendPartitions.getYearAndMonthPartCols(), null, TableType.VIRTUAL_VIEW.name(), null);
        return table;
    }

    private Table createTable(String tableName, List<FieldSchema> partCols, Map<String, String> tableParams, String tableType, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).setPartCols(partCols).setTableParams(tableParams).setType(tableType).setLocation(location)).create(this.client, this.metaStore.getConf());
        return this.client.getTable(DB_NAME, tableName);
    }

    private void createPartition(Table table, List<String> values) throws Exception {
        new PartitionBuilder().inTable(table).setValues(values).addToTable(this.client, this.metaStore.getConf());
    }

    private static List<FieldSchema> getYearAndMonthPartCols() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("year", "string", "year part col"));
        cols.add(new FieldSchema("month", "string", "month part col"));
        return cols;
    }

    private static List<String> getPartitionValues(String partitionsName) {
        List<String> values = new ArrayList<String>();
        if (StringUtils.isEmpty((String)partitionsName)) {
            return values;
        }
        values = Arrays.stream(partitionsName.split("/")).map(v -> v.split("=")[1]).collect(Collectors.toList());
        return values;
    }

    private void verifyPartition(Partition partition, Table table, List<String> expectedPartValues, String partitionName) throws Exception {
        Assert.assertEquals((Object)table.getTableName(), (Object)partition.getTableName());
        Assert.assertEquals((Object)table.getDbName(), (Object)partition.getDbName());
        Assert.assertEquals(expectedPartValues, (Object)partition.getValues());
        Assert.assertNotEquals((long)0L, (long)partition.getCreateTime());
        Assert.assertEquals((long)0L, (long)partition.getLastAccessTime());
        Assert.assertEquals((long)1L, (long)partition.getParameters().size());
        Assert.assertTrue((boolean)partition.getParameters().containsKey("transient_lastDdlTime"));
        StorageDescriptor partitionSD = partition.getSd();
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/" + partitionName), (Object)partitionSD.getLocation());
        partition.getSd().setLocation(table.getSd().getLocation());
        Assert.assertEquals((Object)table.getSd(), (Object)partitionSD);
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(partitionSD.getLocation())));
    }

    private void verifyPartitionNames(Table table, List<String> expectedPartNames) throws Exception {
        List partitionNames = this.client.listPartitionNames(table.getDbName(), table.getTableName(), (short)-1);
        Assert.assertEquals((long)expectedPartNames.size(), (long)partitionNames.size());
        Assert.assertTrue((boolean)partitionNames.containsAll(expectedPartNames));
    }
}

