/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class DoubleColumnVector
extends ColumnVector {
    public double[] vector;
    public static final double NULL_VALUE = Double.NaN;

    public DoubleColumnVector() {
        this(1024);
    }

    public DoubleColumnVector(int len) {
        super(len);
        this.vector = new double[len];
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, DoubleColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void fill(double value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    public void fillWithNulls() {
        this.noNulls = false;
        this.isRepeating = true;
        this.vector[0] = Double.NaN;
        this.isNull[0] = true;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            double repeatVal = this.vector[0];
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    this.vector[i] = repeatVal;
                }
            } else {
                Arrays.fill(this.vector, 0, size, repeatVal);
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((DoubleColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append(this.vector[row]);
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size > this.vector.length) {
            double[] oldArray = this.vector;
            this.vector = new double[size];
            if (preserveData) {
                if (this.isRepeating) {
                    this.vector[0] = oldArray[0];
                } else {
                    System.arraycopy(oldArray, 0, this.vector, 0, oldArray.length);
                }
            }
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        DoubleColumnVector other = (DoubleColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

