/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;

public class LongColumnVector
extends ColumnVector {
    public long[] vector;
    public static final long NULL_VALUE = 1L;

    public LongColumnVector() {
        this(1024);
    }

    public LongColumnVector(int len) {
        super(len);
        this.vector = new long[len];
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, LongColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, DoubleColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            for (int i2 = 0; i2 < size; ++i2) {
                output.vector[i2] = this.vector[i2];
            }
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void fill(long value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    public void fillWithNulls() {
        this.noNulls = false;
        this.isRepeating = true;
        this.vector[0] = 1L;
        this.isNull[0] = true;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            long repeatVal = this.vector[0];
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    this.vector[i] = repeatVal;
                }
            } else {
                Arrays.fill(this.vector, 0, size, repeatVal);
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((LongColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append(this.vector[row]);
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size > this.vector.length) {
            long[] oldArray = this.vector;
            this.vector = new long[size];
            if (preserveData) {
                if (this.isRepeating) {
                    this.vector[0] = oldArray[0];
                } else {
                    System.arraycopy(oldArray, 0, this.vector, 0, oldArray.length);
                }
            }
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        LongColumnVector other = (LongColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

