/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafkaesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesque.common.protocol.Message;
import org.apache.kafkaesqueesque.common.protocol.MessageUtil;
import org.apache.kafkaesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesque.common.utils.ByteUtils;
import org.apache.kafkaesqueesque.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafkaesqueesque.common.utils.ImplicitLinkedHashMultiCollection;

public class OffsetDeleteRequestData
implements ApiMessage {
    private String groupId;
    private OffsetDeleteRequestTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("topics", new ArrayOf(OffsetDeleteRequestTopic.SCHEMA_0), "The topics to delete offsets for"));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public OffsetDeleteRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetDeleteRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public OffsetDeleteRequestData() {
        this.groupId = "";
        this.topics = new OffsetDeleteRequestTopicCollection(0);
    }

    @Override
    public short apiKey() {
        return 47;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        OffsetDeleteRequestTopicCollection newCollection = new OffsetDeleteRequestTopicCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OffsetDeleteRequestTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeShort((short)((byte[])_stringBytes).length);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.topics.size());
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            OffsetDeleteRequestTopic topicsElement = (OffsetDeleteRequestTopic)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.groupId = struct.getString("group_id");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new OffsetDeleteRequestTopicCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new OffsetDeleteRequestTopic((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("group_id", (Object)this.groupId);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetDeleteRequestTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size += _stringBytes.length + 2;
        int _arraySize = 0;
        _arraySize += 4;
        for (OffsetDeleteRequestTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetDeleteRequestData)) {
            return false;
        }
        OffsetDeleteRequestData other = (OffsetDeleteRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "OffsetDeleteRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public OffsetDeleteRequestTopicCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetDeleteRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public OffsetDeleteRequestData setTopics(OffsetDeleteRequestTopicCollection v) {
        this.topics = v;
        return this;
    }

    public static class OffsetDeleteRequestTopicCollection
    extends ImplicitLinkedHashMultiCollection<OffsetDeleteRequestTopic> {
        public OffsetDeleteRequestTopicCollection() {
        }

        public OffsetDeleteRequestTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public OffsetDeleteRequestTopicCollection(Iterator<OffsetDeleteRequestTopic> iterator) {
            super(iterator);
        }

        @Override
        public OffsetDeleteRequestTopic find(String name) {
            OffsetDeleteRequestTopic _key = new OffsetDeleteRequestTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<OffsetDeleteRequestTopic> findAll(String name) {
            OffsetDeleteRequestTopic _key = new OffsetDeleteRequestTopic();
            _key.setName(name);
            return this.findAll(_key);
        }
    }

    public static class OffsetDeleteRequestPartition
    implements Message {
        private int partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public OffsetDeleteRequestPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetDeleteRequestPartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public OffsetDeleteRequestPartition() {
            this.partitionIndex = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteRequestPartition");
            }
            this.partitionIndex = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetDeleteRequestPartition");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteRequestPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetDeleteRequestPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetDeleteRequestPartition");
            }
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetDeleteRequestPartition)) {
                return false;
            }
            OffsetDeleteRequestPartition other = (OffsetDeleteRequestPartition)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "OffsetDeleteRequestPartition(partitionIndex=" + this.partitionIndex + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetDeleteRequestPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }
    }

    public static class OffsetDeleteRequestTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private List<OffsetDeleteRequestPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetDeleteRequestPartition.SCHEMA_0), "Each partition to delete offsets for."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public OffsetDeleteRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetDeleteRequestTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetDeleteRequestTopic() {
            this.name = "";
            this.partitions = new ArrayList<OffsetDeleteRequestPartition>();
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteRequestTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<OffsetDeleteRequestPartition> newCollection = new ArrayList<OffsetDeleteRequestPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetDeleteRequestPartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetDeleteRequestTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                OffsetDeleteRequestPartition partitionsElement = (OffsetDeleteRequestPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteRequestTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetDeleteRequestPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new OffsetDeleteRequestPartition((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetDeleteRequestTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetDeleteRequestPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetDeleteRequestTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (OffsetDeleteRequestPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetDeleteRequestTopic)) {
                return false;
            }
            OffsetDeleteRequestTopic other = (OffsetDeleteRequestTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetDeleteRequestTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetDeleteRequestPartition> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetDeleteRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetDeleteRequestTopic setPartitions(List<OffsetDeleteRequestPartition> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

