/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.metrics.stats;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesqueesque.common.MetricName;
import org.apache.kafkaesqueesque.common.metrics.CompoundStat;
import org.apache.kafkaesqueesque.common.metrics.Measurable;
import org.apache.kafkaesqueesque.common.metrics.MetricConfig;
import org.apache.kafkaesqueesque.common.metrics.stats.Frequency;
import org.apache.kafkaesqueesque.common.metrics.stats.Histogram;
import org.apache.kafkaesqueesque.common.metrics.stats.SampledStat;

public class Frequencies
extends SampledStat
implements CompoundStat {
    private final Frequency[] frequencies;
    private final Histogram.BinScheme binScheme;

    public static Frequencies forBooleanValues(MetricName falseMetricName, MetricName trueMetricName) {
        ArrayList<Frequency> frequencies = new ArrayList<Frequency>();
        if (falseMetricName != null) {
            frequencies.add(new Frequency(falseMetricName, 0.0));
        }
        if (trueMetricName != null) {
            frequencies.add(new Frequency(trueMetricName, 1.0));
        }
        if (frequencies.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one metric name");
        }
        Frequency[] frequencyArray = frequencies.toArray(new Frequency[frequencies.size()]);
        return new Frequencies(2, 0.0, 1.0, frequencyArray);
    }

    public Frequencies(int buckets, double min, double max, Frequency ... frequencies) {
        super(0.0);
        if (max < min) {
            throw new IllegalArgumentException("The maximum value " + max + " must be greater than the minimum value " + min);
        }
        if (buckets < 1) {
            throw new IllegalArgumentException("Must be at least 1 bucket");
        }
        if (buckets < frequencies.length) {
            throw new IllegalArgumentException("More frequencies than buckets");
        }
        this.frequencies = frequencies;
        for (Frequency freq : frequencies) {
            if (!(min > freq.centerValue()) && !(max < freq.centerValue())) continue;
            throw new IllegalArgumentException("The frequency centered at '" + freq.centerValue() + "' is not within the range [" + min + "," + max + "]");
        }
        double halfBucketWidth = (max - min) / (double)(buckets - 1) / 2.0;
        this.binScheme = new Histogram.ConstantBinScheme(buckets, min - halfBucketWidth, max + halfBucketWidth);
    }

    @Override
    public List<CompoundStat.NamedMeasurable> stats() {
        ArrayList<CompoundStat.NamedMeasurable> ms = new ArrayList<CompoundStat.NamedMeasurable>(this.frequencies.length);
        for (Frequency frequency : this.frequencies) {
            final double center = frequency.centerValue();
            ms.add(new CompoundStat.NamedMeasurable(frequency.name(), new Measurable(){

                @Override
                public double measure(MetricConfig config, long now) {
                    return Frequencies.this.frequency(config, now, center);
                }
            }));
        }
        return ms;
    }

    public double frequency(MetricConfig config, long now, double centerValue) {
        this.purgeObsoleteSamples(config, now);
        long totalCount = 0L;
        for (SampledStat.Sample sample : this.samples) {
            totalCount += sample.eventCount;
        }
        if (totalCount == 0L) {
            return 0.0;
        }
        float count = 0.0f;
        int binNum = this.binScheme.toBin(centerValue);
        for (SampledStat.Sample s : this.samples) {
            HistogramSample sample = (HistogramSample)s;
            float[] hist = sample.histogram.counts();
            count += hist[binNum];
        }
        return (double)count / (double)totalCount;
    }

    double totalCount() {
        long count = 0L;
        for (SampledStat.Sample sample : this.samples) {
            count += sample.eventCount;
        }
        return count;
    }

    @Override
    public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
        return this.totalCount();
    }

    @Override
    protected HistogramSample newSample(long timeMs) {
        return new HistogramSample(this.binScheme, timeMs);
    }

    @Override
    protected void update(SampledStat.Sample sample, MetricConfig config, double value, long timeMs) {
        HistogramSample hist = (HistogramSample)sample;
        hist.histogram.record(value);
    }

    private static class HistogramSample
    extends SampledStat.Sample {
        private final Histogram histogram;

        private HistogramSample(Histogram.BinScheme scheme, long now) {
            super(0.0, now);
            this.histogram = new Histogram(scheme);
        }

        @Override
        public void reset(long now) {
            super.reset(now);
            this.histogram.clear();
        }
    }
}

