/*
 * Copyright 2019 and onwards Makoto Yui
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package matrix4j.matrix;

import javax.annotation.Nonnegative;

public abstract class ColumnMajorFloatMatrix extends ColumnMajorMatrix implements FloatMatrix {

    public ColumnMajorFloatMatrix() {
        super();
    }

    @Override
    public ColumnMajorFloatMatrix toColumnMajorMatrix() {
        return this;
    }

    @Override
    public double get(@Nonnegative final int row, @Nonnegative final int col,
            final double defaultValue) {
        return get(row, col, (float) defaultValue);
    }

    @Override
    public void set(@Nonnegative final int row, @Nonnegative final int col, final double value) {
        set(row, col, (float) value);
    }

    @Override
    public double getAndSet(@Nonnegative final int row, @Nonnegative final int col,
            final double value) {
        return getAndSet(row, col, (float) value);
    }

}
