/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hcatalog.data.transfer.state;

/**
 * If external system wants to communicate any state to slaves, they can do so
 * via this interface. One example of this in case of Map-Reduce is ids assigned
 * by JobTracker to TaskTracker.
 * @deprecated Use/modify {@link org.apache.hive.hcatalog.data.transfer.state.StateProvider} instead
 */
public interface StateProvider {

  /**
   * This method should return id assigned to slave node.
   *
   * @return id
   */
  public int getId();
}
