/*
 * Decompiled with CFR 0.152.
 */
package hivemall.anomaly;

import hivemall.anomaly.ChangeFinderUDF;
import hivemall.anomaly.SDAR1D;
import hivemall.utils.collections.DoubleRingBuffer;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

final class ChangeFinder1D
implements ChangeFinderUDF.ChangeFinder {
    @Nonnull
    private final PrimitiveObjectInspector oi;
    @Nonnull
    private final ChangeFinderUDF.LossFunction lossFunc1;
    @Nonnull
    private final ChangeFinderUDF.LossFunction lossFunc2;
    @Nonnull
    private final SDAR1D sdar1;
    @Nonnull
    private final SDAR1D sdar2;
    @Nonnull
    private final DoubleRingBuffer xRing;
    @Nonnull
    private final DoubleRingBuffer yRing;
    @Nonnull
    private final double[] xSeries;
    @Nonnull
    private final double[] ySeries;
    @Nonnull
    private final DoubleRingBuffer outlierScores;
    @Nonnull
    private final DoubleRingBuffer changepointScores;

    ChangeFinder1D(@Nonnull ChangeFinderUDF.Parameters params, @Nonnull PrimitiveObjectInspector oi) {
        this.oi = oi;
        this.lossFunc1 = params.lossFunc1;
        this.lossFunc2 = params.lossFunc2;
        int k = params.k;
        this.sdar1 = new SDAR1D(params.r1, k);
        this.sdar2 = new SDAR1D(params.r2, k);
        this.xRing = new DoubleRingBuffer(k + 1);
        this.yRing = new DoubleRingBuffer(k + 1);
        this.xSeries = new double[k + 1];
        this.ySeries = new double[k + 1];
        this.outlierScores = new DoubleRingBuffer(params.T1);
        this.changepointScores = new DoubleRingBuffer(params.T2);
    }

    @Override
    public void update(@Nonnull Object arg, @Nonnull double[] outScores) throws HiveException {
        double x = PrimitiveObjectInspectorUtils.getDouble((Object)arg, (PrimitiveObjectInspector)this.oi);
        this.xRing.add(x).toArray(this.xSeries, false);
        int k1 = this.xRing.size() - 1;
        double x_hat = this.sdar1.update(this.xSeries, k1);
        double scoreX = (double)k1 == 0.0 ? 0.0 : ChangeFinder1D.loss(this.sdar1, x, x_hat, this.lossFunc1);
        double y = ChangeFinderUDF.smoothing(this.outlierScores.add(scoreX));
        this.yRing.add(y).toArray(this.ySeries, false);
        int k2 = this.yRing.size() - 1;
        double y_hat = this.sdar2.update(this.ySeries, k2);
        double lossY = (double)k2 == 0.0 ? 0.0 : ChangeFinder1D.loss(this.sdar2, y, y_hat, this.lossFunc2);
        double scoreY = ChangeFinderUDF.smoothing(this.changepointScores.add(lossY));
        outScores[0] = scoreX;
        outScores[1] = scoreY;
    }

    private static double loss(@Nonnull SDAR1D sdar, @Nonnull double actual, @Nonnull double predicted, @Nonnull ChangeFinderUDF.LossFunction lossFunc) {
        double loss;
        switch (lossFunc) {
            case hellinger: {
                double h2d = sdar.hellingerDistance();
                loss = h2d * 100.0;
                break;
            }
            case logloss: {
                loss = sdar.logLoss(actual, predicted);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected loss function: " + (Object)((Object)lossFunc));
            }
        }
        return loss;
    }
}

