/*
 * Decompiled with CFR 0.152.
 */
package hivemall.anomaly;

import hivemall.anomaly.ChangeFinderUDF;
import hivemall.anomaly.SDAR1D;
import hivemall.anomaly.SDAR2D;
import hivemall.utils.collections.DoubleRingBuffer;
import hivemall.utils.collections.RingBuffer;
import hivemall.utils.hadoop.HiveUtils;
import javax.annotation.Nonnull;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

final class ChangeFinder2D
implements ChangeFinderUDF.ChangeFinder {
    @Nonnull
    private final ListObjectInspector listOI;
    @Nonnull
    private final PrimitiveObjectInspector elemOI;
    @Nonnull
    private final ChangeFinderUDF.LossFunction lossFunc1;
    @Nonnull
    private final ChangeFinderUDF.LossFunction lossFunc2;
    @Nonnull
    private final SDAR2D sdar1;
    @Nonnull
    private final SDAR1D sdar2;
    @Nonnull
    private final RingBuffer<ArrayRealVector> xRing;
    @Nonnull
    private final DoubleRingBuffer yRing;
    @Nonnull
    private final ArrayRealVector[] xSeries;
    @Nonnull
    private final double[] ySeries;
    @Nonnull
    private final DoubleRingBuffer outlierScores;
    @Nonnull
    private final DoubleRingBuffer changepointScores;

    ChangeFinder2D(@Nonnull ChangeFinderUDF.Parameters params, @Nonnull ListObjectInspector listOI) throws UDFArgumentTypeException {
        this.listOI = listOI;
        this.elemOI = HiveUtils.asDoubleCompatibleOI(listOI.getListElementObjectInspector());
        this.lossFunc1 = params.lossFunc1;
        this.lossFunc2 = params.lossFunc2;
        int k = params.k;
        this.sdar1 = new SDAR2D(params.r1, k);
        this.sdar2 = new SDAR1D(params.r2, k);
        this.xRing = new RingBuffer(k + 1);
        this.yRing = new DoubleRingBuffer(k + 1);
        this.xSeries = new ArrayRealVector[k + 1];
        this.ySeries = new double[k + 1];
        this.outlierScores = new DoubleRingBuffer(params.T1);
        this.changepointScores = new DoubleRingBuffer(params.T2);
    }

    @Override
    public void update(@Nonnull Object arg, @Nonnull double[] outScores) throws HiveException {
        ArrayRealVector x = this.parseX(arg);
        this.xRing.add(x).toArray((ArrayRealVector[])this.xSeries, false);
        int k1 = this.xRing.size() - 1;
        RealVector x_hat = this.sdar1.update(this.xSeries, k1);
        double scoreX = (double)k1 == 0.0 ? 0.0 : this.loss(x, x_hat, this.lossFunc1);
        double y = ChangeFinderUDF.smoothing(this.outlierScores.add(scoreX));
        this.yRing.add(y).toArray(this.ySeries, false);
        int k2 = this.yRing.size() - 1;
        double y_hat = this.sdar2.update(this.ySeries, k2);
        double lossY = (double)k2 == 0.0 ? 0.0 : this.loss(y, y_hat, this.lossFunc1);
        double scoreY = ChangeFinderUDF.smoothing(this.changepointScores.add(lossY));
        outScores[0] = scoreX;
        outScores[1] = scoreY;
    }

    private double loss(@Nonnull ArrayRealVector x, @Nonnull RealVector x_hat, @Nonnull ChangeFinderUDF.LossFunction lossFunc) {
        double loss;
        switch (lossFunc) {
            case hellinger: {
                double h2d = this.sdar1.hellingerDistance();
                loss = h2d * 100.0;
                break;
            }
            case logloss: {
                loss = this.sdar1.logLoss(x, x_hat);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected loss function: " + (Object)((Object)lossFunc));
            }
        }
        return loss;
    }

    private double loss(@Nonnull double y, @Nonnull double y_hat, @Nonnull ChangeFinderUDF.LossFunction lossFunc) {
        double loss;
        switch (lossFunc) {
            case hellinger: {
                double h2d = this.sdar2.hellingerDistance();
                loss = h2d * 100.0;
                break;
            }
            case logloss: {
                loss = this.sdar2.logLoss(y, y_hat);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected loss function: " + (Object)((Object)lossFunc));
            }
        }
        return loss;
    }

    @Nonnull
    private ArrayRealVector parseX(Object arg) throws UDFArgumentException {
        ArrayRealVector xVec = this.xRing.head();
        if (xVec == null) {
            double[] data = HiveUtils.asDoubleArray(arg, this.listOI, this.elemOI);
            if (data.length == 0) {
                throw new UDFArgumentException("Dimension of x SHOULD be more than zero");
            }
            xVec = new ArrayRealVector(data, false);
        } else {
            double[] ref = xVec.getDataRef();
            HiveUtils.toDoubleArray(arg, this.listOI, this.elemOI, ref, 0.0);
        }
        return xVec;
    }
}

