/*
 * Decompiled with CFR 0.152.
 */
package hivemall.anomaly;

import hivemall.utils.lang.Preconditions;
import hivemall.utils.math.MatrixUtils;
import hivemall.utils.math.StatsUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class SDAR1D {
    private final double _r;
    private final double[] _C;
    private final double[] _A;
    private double _mu;
    private double _sigma;
    private double _muOld;
    private double _sigmaOld;
    private boolean _initialized;

    public SDAR1D(double r, int k) {
        Preconditions.checkArgument(0.0 < r && r < 1.0, "Invalid forgetfullness parameter r: " + r);
        Preconditions.checkArgument(k >= 1, "Invalid smoothing parameter k: " + k);
        this._r = r;
        this._C = new double[k + 1];
        this._A = new double[k + 1];
        this._initialized = false;
    }

    public double update(@Nonnull double[] x, int k) {
        Preconditions.checkArgument(x.length >= 1, "x.length MUST be greater than 1: ", x.length);
        Preconditions.checkArgument(k >= 0, "k MUST be greater than or equals to 0: ", k);
        Preconditions.checkArgument(k < this._C.length, "k MUST be less than |C| but ", "k=", k + ", |C|=", this._C.length);
        double x_t = x[0];
        if (!this._initialized) {
            this._mu = x_t;
            this._sigma = 0.0;
            this._initialized = true;
            return 0.0;
        }
        Preconditions.checkArgument(k >= 1, "k MUST be greater than 0: ", k);
        this._muOld = this._mu;
        this._sigmaOld = this._sigma;
        this._mu = (1.0 - this._r) * this._mu + this._r * x_t;
        double[] C = this._C;
        for (int j = 0; j <= k; ++j) {
            C[j] = (1.0 - this._r) * C[j] + this._r * (x_t - this._mu) * (x[j] - this._mu);
        }
        double[] A = this._A;
        Arrays.fill(A, 0.0);
        MatrixUtils.aryule(C, A, k);
        double x_hat = this._mu;
        for (int i = 1; i <= k; ++i) {
            x_hat += A[i] * (x[i] - this._mu);
        }
        double diffx = x_t - x_hat;
        this._sigma = (1.0 - this._r) * this._sigma + this._r * diffx * diffx;
        return x_hat;
    }

    public double logLoss(double actual, double predicted) {
        return StatsUtils.logLoss(actual, predicted, this._sigma);
    }

    public double hellingerDistance() {
        return StatsUtils.hellingerDistance(this._muOld, this._sigmaOld, this._mu, this._sigma);
    }
}

