/*
 * Decompiled with CFR 0.152.
 */
package hivemall.anomaly;

import hivemall.anomaly.SingularSpectrumTransformUDF;
import hivemall.utils.collections.DoubleRingBuffer;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.math.MatrixUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

final class SingularSpectrumTransform
implements SingularSpectrumTransformUDF.SingularSpectrumTransformInterface {
    @Nonnull
    private final PrimitiveObjectInspector oi;
    @Nonnull
    private final SingularSpectrumTransformUDF.ScoreFunction scoreFunc;
    @Nonnull
    private final int window;
    @Nonnull
    private final int nPastWindow;
    @Nonnull
    private final int nCurrentWindow;
    @Nonnull
    private final int pastSize;
    @Nonnull
    private final int currentSize;
    @Nonnull
    private final int currentOffset;
    @Nonnull
    private final int r;
    @Nonnull
    private final int k;
    @Nonnull
    private final DoubleRingBuffer xRing;
    @Nonnull
    private final double[] xSeries;
    @Nonnull
    private final double[] q;

    SingularSpectrumTransform(@Nonnull SingularSpectrumTransformUDF.Parameters params, @Nonnull PrimitiveObjectInspector oi) {
        int i;
        this.oi = oi;
        this.scoreFunc = params.scoreFunc;
        this.window = params.w;
        this.nPastWindow = params.n;
        this.nCurrentWindow = params.m;
        this.pastSize = this.window + this.nPastWindow;
        this.currentSize = this.window + this.nCurrentWindow;
        this.currentOffset = params.g;
        this.r = params.r;
        this.k = params.k;
        Preconditions.checkArgument(params.k >= params.r);
        int holdSampleSize = this.pastSize + this.currentOffset + this.currentSize;
        this.xRing = new DoubleRingBuffer(holdSampleSize);
        this.xSeries = new double[holdSampleSize];
        this.q = new double[this.window];
        double norm = 0.0;
        for (i = 0; i < this.window; ++i) {
            this.q[i] = Math.random();
            norm += this.q[i] * this.q[i];
        }
        norm = Math.sqrt(norm);
        for (i = 0; i < this.window; ++i) {
            this.q[i] = this.q[i] / norm;
        }
    }

    @Override
    public void update(@Nonnull Object arg, @Nonnull double[] outScores) throws HiveException {
        double x = PrimitiveObjectInspectorUtils.getDouble((Object)arg, (PrimitiveObjectInspector)this.oi);
        this.xRing.add(x).toArray(this.xSeries, true);
        if (!this.xRing.isFull()) {
            outScores[0] = 0.0;
        } else {
            Array2DRowRealMatrix H = new Array2DRowRealMatrix(this.window, this.nPastWindow);
            for (int i = 0; i < this.nPastWindow; ++i) {
                H.setColumn(i, Arrays.copyOfRange(this.xSeries, i, i + this.window));
            }
            Array2DRowRealMatrix G = new Array2DRowRealMatrix(this.window, this.nCurrentWindow);
            int currentHead = this.pastSize + this.currentOffset;
            for (int i = 0; i < this.nCurrentWindow; ++i) {
                G.setColumn(i, Arrays.copyOfRange(this.xSeries, currentHead + i, currentHead + i + this.window));
            }
            switch (this.scoreFunc) {
                case svd: {
                    outScores[0] = this.computeScoreSVD(H, G);
                    break;
                }
                case ika: {
                    outScores[0] = this.computeScoreIKA(H, G);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected score function: " + (Object)((Object)this.scoreFunc));
                }
            }
        }
    }

    private double computeScoreSVD(@Nonnull RealMatrix H, @Nonnull RealMatrix G) {
        SingularValueDecomposition svdH = new SingularValueDecomposition(H);
        RealMatrix UT = svdH.getUT();
        SingularValueDecomposition svdG = new SingularValueDecomposition(G);
        RealMatrix Q = svdG.getU();
        RealMatrix UTQ = UT.getSubMatrix(0, this.r - 1, 0, this.window - 1).multiply(Q.getSubMatrix(0, this.window - 1, 0, this.r - 1));
        SingularValueDecomposition svdUTQ = new SingularValueDecomposition(UTQ);
        double[] s = svdUTQ.getSingularValues();
        return 1.0 - s[0];
    }

    private double computeScoreIKA(@Nonnull RealMatrix H, @Nonnull RealMatrix G) {
        MatrixUtils.power1(G, this.q, 1, this.q, new double[this.window]);
        Array2DRowRealMatrix T = new Array2DRowRealMatrix(this.k, this.k);
        MatrixUtils.lanczosTridiagonalization(H.multiply(H.transpose()), this.q, T);
        double[] eigvals = new double[this.k];
        Array2DRowRealMatrix eigvecs = new Array2DRowRealMatrix(this.k, this.k);
        MatrixUtils.tridiagonalEigen(T, 1, eigvals, eigvecs);
        TreeMap map = new TreeMap(Collections.reverseOrder());
        for (int i = 0; i < this.k; ++i) {
            map.put(eigvals[i], i);
        }
        Iterator indices = map.values().iterator();
        double s = 0.0;
        for (int i = 0; i < this.r; ++i) {
            if (!indices.hasNext()) {
                throw new IllegalStateException("Should not happen");
            }
            double v = eigvecs.getEntry(0, (Integer)indices.next());
            s += v * v;
        }
        return 1.0 - Math.sqrt(s);
    }
}

