/*
 * Decompiled with CFR 0.152.
 */
package hivemall.anomaly;

import hivemall.UDFWithOptions;
import hivemall.anomaly.SingularSpectrumTransform;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Preconditions;
import hivemall.utils.lang.Primitives;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="sst", value="_FUNC_(double|array<double> x [, const string options]) - Returns change-point scores and decisions using Singular Spectrum Transformation (SST). It will return a tuple <double changepoint_score [, boolean is_changepoint]>")
@UDFType(deterministic=false, stateful=true)
public final class SingularSpectrumTransformUDF
extends UDFWithOptions {
    private transient Parameters _params;
    private transient SingularSpectrumTransform _sst;
    private transient double[] _scores;
    private transient Object[] _result;
    private transient DoubleWritable _changepointScore;
    @Nullable
    private transient BooleanWritable _isChangepoint;

    Parameters getParameters() {
        return this._params;
    }

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("w", "window", true, "Number of samples which affects change-point score [default: 30]");
        opts.addOption("n", "n_past", true, "Number of past windows for change-point scoring [default: equal to `w` = 30]");
        opts.addOption("m", "n_current", true, "Number of current windows for change-point scoring [default: equal to `w` = 30]");
        opts.addOption("g", "current_offset", true, "Offset of the current windows from the updating sample [default: `-w` = -30]");
        opts.addOption("r", "n_component", true, "Number of singular vectors (i.e. principal components) [default: 3]");
        opts.addOption("k", "n_dim", true, "Number of dimensions for the Krylov subspaces [default: 5 (`2*r` if `r` is even, `2*r-1` otherwise)]");
        opts.addOption("score", "scorefunc", true, "Score function [default: svd, ika]");
        opts.addOption("th", "threshold", true, "Score threshold (inclusive) for determining change-point existence [default: -1, do not output decision]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(String optionValues) throws UDFArgumentException {
        CommandLine cl = this.parseOptions(optionValues);
        this._params.w = Primitives.parseInt(cl.getOptionValue("w"), this._params.w);
        this._params.n = Primitives.parseInt(cl.getOptionValue("n"), this._params.w);
        this._params.m = Primitives.parseInt(cl.getOptionValue("m"), this._params.w);
        this._params.g = Primitives.parseInt(cl.getOptionValue("g"), -1 * this._params.w);
        this._params.r = Primitives.parseInt(cl.getOptionValue("r"), this._params.r);
        this._params.k = Primitives.parseInt(cl.getOptionValue("k"), this._params.r % 2 == 0 ? 2 * this._params.r : 2 * this._params.r - 1);
        this._params.scoreFunc = ScoreFunction.resolve(cl.getOptionValue("scorefunc", ScoreFunction.svd.name()));
        if ((this._params.w != this._params.n || this._params.w != this._params.m) && this._params.scoreFunc == ScoreFunction.ika) {
            throw new UDFArgumentException("IKA-based efficient SST requires w = n = m");
        }
        this._params.changepointThreshold = Primitives.parseDouble(cl.getOptionValue("th"), this._params.changepointThreshold);
        Preconditions.checkArgument(this._params.w >= 2, UDFArgumentException.class, (Object)("w must be greater than 1: " + this._params.w));
        Preconditions.checkArgument(this._params.r >= 1, UDFArgumentException.class, (Object)("r must be greater than 0: " + this._params.r));
        Preconditions.checkArgument(this._params.k >= 1, UDFArgumentException.class, (Object)("k must be greater than 0: " + this._params.k));
        Preconditions.checkArgument(this._params.k >= this._params.r, UDFArgumentException.class, (Object)("k must be equals to or greater than r: k=" + this._params.k + ", r" + this._params.r));
        Preconditions.checkArgument(this._params.changepointThreshold > 0.0 && this._params.changepointThreshold < 1.0, UDFArgumentException.class, (Object)("changepointThreshold must be in range (0, 1): " + this._params.changepointThreshold));
        return cl;
    }

    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        Object[] result;
        if (argOIs.length < 1 || argOIs.length > 2) {
            throw new UDFArgumentException("_FUNC_(double|array<double> x [, const string options]) takes 1 or 2 arguments: " + Arrays.toString(argOIs));
        }
        this._params = new Parameters();
        if (argOIs.length == 2) {
            String options = HiveUtils.getConstString(argOIs[1]);
            this.processOptions(options);
        }
        ObjectInspector argOI0 = argOIs[0];
        PrimitiveObjectInspector xOI = HiveUtils.asDoubleCompatibleOI(argOI0);
        this._sst = new SingularSpectrumTransform(this._params, xOI);
        this._scores = new double[1];
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Object> fieldOIs = new ArrayList<Object>();
        fieldNames.add("changepoint_score");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        if (this._params.changepointThreshold != -1.0) {
            fieldNames.add("is_changepoint");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            result = new Object[2];
            this._isChangepoint = new BooleanWritable(false);
            result[1] = this._isChangepoint;
        } else {
            result = new Object[1];
        }
        this._changepointScore = new DoubleWritable(0.0);
        result[0] = this._changepointScore;
        this._result = result;
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public Object[] evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        Object x = args[0].get();
        if (x == null) {
            return this._result;
        }
        this._sst.update(x, this._scores);
        double changepointScore = this._scores[0];
        this._changepointScore.set(changepointScore);
        if (this._isChangepoint != null) {
            this._isChangepoint.set(changepointScore >= this._params.changepointThreshold);
        }
        return this._result;
    }

    public void close() throws IOException {
        this._result = null;
        this._changepointScore = null;
        this._isChangepoint = null;
    }

    public String getDisplayString(String[] children) {
        return "sst(" + Arrays.toString(children) + ")";
    }

    public static enum ScoreFunction {
        svd,
        ika;


        static ScoreFunction resolve(@Nullable String name) throws UDFArgumentException {
            if (svd.name().equalsIgnoreCase(name)) {
                return svd;
            }
            if (ika.name().equalsIgnoreCase(name)) {
                return ika;
            }
            throw new UDFArgumentException("Unsupported ScoreFunction: " + name);
        }
    }

    public static interface SingularSpectrumTransformInterface {
        public void update(@Nonnull Object var1, @Nonnull double[] var2) throws HiveException;
    }

    static final class Parameters {
        int w = 30;
        int n = 30;
        int m = 30;
        int g = -30;
        int r = 3;
        int k = 5;
        @Nonnull
        ScoreFunction scoreFunc = ScoreFunction.svd;
        double changepointThreshold = -1.0;

        Parameters() {
        }

        void set(@Nonnull ScoreFunction func) {
            this.scoreFunc = func;
        }
    }
}

