/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier;

import hivemall.classifier.BinaryOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.WeightValue;
import hivemall.optimizer.LossFunctions;
import hivemall.utils.lang.Primitives;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Deprecated
@Description(name="train_adagrad_rda", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight>", extended="Build a prediction model by Adagrad+RDA regularization binary classifier")
public final class AdaGradRDAUDTF
extends BinaryOnlineClassifierUDTF {
    private float eta;
    private float lambda;
    private float scaling;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<Text|Int|BitInt> features, int label [, constant string options]");
        }
        StructObjectInspector oi = super.initialize(argOIs);
        this.model.configureParams(true, false, true);
        return oi;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("eta", "eta0", true, "The learning rate \\eta [default 0.1]");
        opts.addOption("lambda", true, "lambda constant of RDA [default: 1E-6f]");
        opts.addOption("scale", true, "Internal scaling/descaling factor for cumulative weights [default: 100]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        if (cl == null) {
            this.eta = 0.1f;
            this.lambda = 1.0E-6f;
            this.scaling = 100.0f;
        } else {
            this.eta = Primitives.parseFloat(cl.getOptionValue("eta"), 0.1f);
            this.lambda = Primitives.parseFloat(cl.getOptionValue("lambda"), 1.0E-6f);
            this.scaling = Primitives.parseFloat(cl.getOptionValue("scale"), 100.0f);
        }
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, int label) {
        float y = label > 0 ? 1.0f : -1.0f;
        float p = this.predict(features);
        float loss = LossFunctions.hingeLoss(p, y);
        if (loss <= 0.0f) {
            return;
        }
        this.update(features, y, this.count);
    }

    protected void update(@Nonnull FeatureValue[] features, float y, int t) {
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object x = f.getFeature();
            float xi = f.getValueAsFloat();
            this.updateWeight(x, xi, y, t);
        }
    }

    protected void updateWeight(@Nonnull Object x, float xi, float y, float t) {
        float gradient = -y * xi;
        float scaled_gradient = gradient * this.scaling;
        float scaled_sum_sqgrad = 0.0f;
        float scaled_sum_grad = 0.0f;
        Object old = this.model.get(x);
        if (old != null) {
            scaled_sum_sqgrad = old.getSumOfSquaredGradients();
            scaled_sum_grad = old.getSumOfGradients();
        }
        float sum_grad = (scaled_sum_grad += scaled_gradient) * this.scaling;
        double sum_sqgrad = (scaled_sum_sqgrad += scaled_gradient * scaled_gradient) * this.scaling;
        float sign = sum_grad > 0.0f ? 1.0f : -1.0f;
        float meansOfGradients = sign * sum_grad / t - this.lambda;
        if (meansOfGradients < 0.0f) {
            this.model.delete(x);
        } else {
            float weight = -1.0f * sign * this.eta * t * meansOfGradients / (float)Math.sqrt(sum_sqgrad);
            WeightValue.WeightValueParamsF2 new_w = new WeightValue.WeightValueParamsF2(weight, scaled_sum_sqgrad, scaled_sum_grad);
            this.model.set(x, new_w);
        }
    }
}

