/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier;

import hivemall.classifier.BinaryOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.PredictionResult;
import hivemall.model.WeightValue;
import hivemall.utils.math.StatsUtils;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_cw", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight, float covar>", extended="Build a prediction model by Confidence-Weighted (CW) binary classifier")
public final class ConfidenceWeightedUDTF
extends BinaryOnlineClassifierUDTF {
    protected float phi;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            this.showHelp("_FUNC_ takes 2 or 3 arguments: List<String|Int|BitInt> features, Int label [, constant String options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected boolean useCovariance() {
        return true;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("phi", "confidence", true, "Confidence parameter [default 1.0]");
        opts.addOption("eta", "hyper_c", true, "Confidence hyperparameter eta in range (0.5, 1] [default 0.85]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        float phi = 1.0f;
        if (cl != null) {
            String phi_str = cl.getOptionValue("phi");
            if (phi_str == null) {
                String eta_str = cl.getOptionValue("eta");
                if (eta_str != null) {
                    double eta = Double.parseDouble(eta_str);
                    if (eta <= 0.5 || eta > 1.0) {
                        throw new UDFArgumentException("Confidence hyperparameter eta must be in range (0.5, 1]: " + eta_str);
                    }
                    phi = (float)StatsUtils.probit(eta, 5.0);
                }
            } else {
                phi = Float.parseFloat(phi_str);
            }
        }
        this.phi = phi;
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, int label) {
        int y = label > 0 ? 1 : -1;
        PredictionResult margin = this.calcScoreAndVariance(features);
        float gamma = this.getGamma(margin, y);
        if (gamma > 0.0f) {
            float coeff = gamma * (float)y;
            this.update(features, coeff, gamma);
        }
    }

    protected final float getGamma(PredictionResult margin, int y) {
        float score = margin.getScore() * (float)y;
        float var = margin.getVariance();
        float b = 1.0f + 2.0f * this.phi * score;
        float gamma_numer = -b + (float)Math.sqrt(b * b - 8.0f * this.phi * (score - this.phi * var));
        float gamma_denom = 4.0f * this.phi * var;
        if (gamma_denom == 0.0f) {
            return 0.0f;
        }
        return gamma_numer / gamma_denom;
    }

    @Override
    protected void update(@Nonnull FeatureValue[] features, float coeff, float alpha) {
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_w = this.model.get(k);
            IWeightValue new_w = ConfidenceWeightedUDTF.getNewWeight(old_w, v, coeff, alpha, this.phi);
            this.model.set(k, new_w);
        }
    }

    private static IWeightValue getNewWeight(IWeightValue old, float x, float coeff, float alpha, float phi) {
        float old_cov;
        float old_w;
        if (old == null) {
            old_w = 0.0f;
            old_cov = 1.0f;
        } else {
            old_w = old.get();
            old_cov = old.getCovariance();
        }
        float new_w = old_w + coeff * old_cov * x;
        float new_cov = 1.0f / (1.0f / old_cov + 2.0f * alpha * phi * x * x);
        return new WeightValue.WeightValueWithCovar(new_w, new_cov);
    }
}

