/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier;

import hivemall.classifier.BinaryOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.PredictionResult;
import hivemall.optimizer.LossFunctions;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_pa", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight>", extended="Build a prediction model by Passive-Aggressive (PA) binary classifier")
public class PassiveAggressiveUDTF
extends BinaryOnlineClassifierUDTF {
    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<Text|Int|BitInt> features, int label [, constant string options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, int label) {
        float y = label > 0 ? 1.0f : -1.0f;
        PredictionResult margin = this.calcScoreAndNorm(features);
        float p = margin.getScore();
        float loss = LossFunctions.hingeLoss(p, y);
        if (loss > 0.0f) {
            float eta = this.eta(loss, margin);
            float coeff = eta * y;
            this.update(features, coeff);
        }
    }

    protected float eta(float loss, PredictionResult margin) {
        return loss / margin.getSquaredNorm();
    }

    @Description(name="train_pa2", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight>", extended="Build a prediction model by Passive-Aggressive 2 (PA-2) binary classifier")
    public static class PA2
    extends PA1 {
        @Override
        protected float eta(float loss, PredictionResult margin) {
            float squared_norm = margin.getSquaredNorm();
            float eta = loss / (squared_norm + 0.5f / this.c);
            return eta;
        }
    }

    @Description(name="train_pa1", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight>", extended="Build a prediction model by Passive-Aggressive 1 (PA-1) binary classifier")
    public static class PA1
    extends PassiveAggressiveUDTF {
        protected float c;

        @Override
        protected Options getOptions() {
            Options opts = super.getOptions();
            opts.addOption("c", "aggressiveness", true, "Aggressiveness parameter C [default 1.0]");
            return opts;
        }

        @Override
        protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
            String c_str;
            CommandLine cl = super.processOptions(argOIs);
            float c = 1.0f;
            if (cl != null && (c_str = cl.getOptionValue("c")) != null && !((c = Float.parseFloat(c_str)) > 0.0f)) {
                throw new UDFArgumentException("Aggressiveness parameter C must be C > 0: " + c);
            }
            this.c = c;
            return cl;
        }

        @Override
        protected float eta(float loss, PredictionResult margin) {
            float squared_norm = margin.getSquaredNorm();
            float eta = loss / squared_norm;
            return Math.min(this.c, eta);
        }
    }
}

