/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier.multiclass;

import hivemall.classifier.multiclass.MulticlassOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.Margin;
import hivemall.model.PredictionModel;
import hivemall.model.WeightValue;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_multiclass_arow", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight, float covar>", extended="Build a prediction model by Adaptive Regularization of Weight Vectors (AROW) multiclass classifier")
public class MulticlassAROWClassifierUDTF
extends MulticlassOnlineClassifierUDTF {
    protected float r;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<String|Int|BitInt> features, {Int|String} label [, constant String options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected boolean useCovariance() {
        return true;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("r", "regularization", true, "Regularization parameter for some r > 0 [default 0.1]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        String r_str;
        CommandLine cl = super.processOptions(argOIs);
        float r = 0.1f;
        if (cl != null && (r_str = cl.getOptionValue("r")) != null && !((r = Float.parseFloat(r_str)) > 0.0f)) {
            throw new UDFArgumentException("Regularization parameter must be greater than 0: " + r_str);
        }
        this.r = r;
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, @Nonnull Object actual_label) {
        Margin margin = this.getMarginAndVariance(features, actual_label);
        float m = margin.get();
        if (m >= 1.0f) {
            return;
        }
        float var = margin.getVariance();
        float beta = 1.0f / (var + this.r);
        float alpha = (1.0f - m) * beta;
        Object missed_label = margin.getMaxIncorrectLabel();
        this.update(features, actual_label, missed_label, alpha, beta);
    }

    protected void update(@Nonnull FeatureValue[] features, Object actual_label, Object missed_label, float alpha, float beta) {
        assert (actual_label != null);
        if (actual_label.equals(missed_label)) {
            throw new IllegalArgumentException("Actual label equals to missed label: " + actual_label);
        }
        PredictionModel model2add = (PredictionModel)this.label2model.get(actual_label);
        if (model2add == null) {
            model2add = this.createModel();
            this.label2model.put(actual_label, model2add);
        }
        PredictionModel model2sub = null;
        if (missed_label != null && (model2sub = (PredictionModel)this.label2model.get(missed_label)) == null) {
            model2sub = this.createModel();
            this.label2model.put(missed_label, model2sub);
        }
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_correctclass_w = model2add.get(k);
            IWeightValue new_correctclass_w = MulticlassAROWClassifierUDTF.getNewWeight(old_correctclass_w, v, alpha, beta, true);
            model2add.set(k, new_correctclass_w);
            if (model2sub == null) continue;
            Object old_wrongclass_w = model2sub.get(k);
            IWeightValue new_wrongclass_w = MulticlassAROWClassifierUDTF.getNewWeight(old_wrongclass_w, v, alpha, beta, false);
            model2sub.set(k, new_wrongclass_w);
        }
    }

    private static IWeightValue getNewWeight(IWeightValue old, float v, float alpha, float beta, boolean positive) {
        float old_cov;
        float old_v;
        if (old == null) {
            old_v = 0.0f;
            old_cov = 1.0f;
        } else {
            old_v = old.get();
            old_cov = old.getCovariance();
        }
        float cv = old_cov * v;
        float new_w = positive ? old_v + alpha * cv : old_v - alpha * cv;
        float new_cov = old_cov - beta * cv * cv;
        return new WeightValue.WeightValueWithCovar(new_w, new_cov);
    }

    @Description(name="train_multiclass_arowh", value="_FUNC_(list<string|int|bigint> features, int|string label [, const string options]) - Returns a relation consists of <int|string label, string|int|bigint feature, float weight, float covar>", extended="Build a prediction model by Adaptive Regularization of Weight Vectors (AROW) multiclass classifier using hinge loss")
    public static final class AROWh
    extends MulticlassAROWClassifierUDTF {
        protected float c;

        @Override
        protected Options getOptions() {
            Options opts = super.getOptions();
            opts.addOption("c", "aggressiveness", true, "Aggressiveness parameter C [default 1.0]");
            return opts;
        }

        @Override
        protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
            String c_str;
            CommandLine cl = super.processOptions(argOIs);
            float c = 1.0f;
            if (cl != null && (c_str = cl.getOptionValue("c")) != null && !((c = Float.parseFloat(c_str)) > 0.0f)) {
                throw new UDFArgumentException("Aggressiveness parameter C must be C > 0: " + c);
            }
            this.c = c;
            return cl;
        }

        @Override
        protected void train(@Nonnull FeatureValue[] features, @Nonnull Object actual_label) {
            Margin margin = this.getMarginAndVariance(features, actual_label);
            float loss = this.loss(margin);
            if (loss > 0.0f) {
                float var = margin.getVariance();
                float beta = 1.0f / (var + this.r);
                float alpha = loss * beta;
                Object missed_label = margin.getMaxIncorrectLabel();
                this.update(features, actual_label, missed_label, alpha, beta);
            }
        }

        protected float loss(Margin margin) {
            return this.c - margin.get();
        }
    }
}

