/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier.multiclass;

import hivemall.classifier.multiclass.MulticlassOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.Margin;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_multiclass_pa", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight>", extended="Build a prediction model by Passive-Aggressive (PA) multiclass classifier")
public class MulticlassPassiveAggressiveUDTF
extends MulticlassOnlineClassifierUDTF {
    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("MulticlassPassiveAggressiveUDTF takes 2 or 3 arguments: List<Text|Int|BitInt> features, {Int|Text} label [, constant text options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, @Nonnull Object actual_label) {
        Margin margin = this.getMargin(features, actual_label);
        float loss = this.loss(margin);
        if (loss > 0.0f) {
            float sqnorm = this.squaredNorm(features);
            if (sqnorm == 0.0f) {
                return;
            }
            float coeff = this.eta(loss, sqnorm);
            Object missed_label = margin.getMaxIncorrectLabel();
            this.update(features, coeff, actual_label, missed_label);
        }
    }

    protected float loss(Margin margin) {
        return 1.0f - margin.get();
    }

    protected float eta(float loss, float sqnorm) {
        return loss / (2.0f * sqnorm);
    }

    @Description(name="train_multiclass_pa2", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight>", extended="Build a prediction model by Passive-Aggressive 2 (PA-2) multiclass classifier")
    public static final class PA2
    extends PA1 {
        @Override
        protected float eta(float loss, float sqnorm) {
            float eta = loss / (2.0f * sqnorm + 0.5f / this.c);
            return eta;
        }
    }

    @Description(name="train_multiclass_pa1", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight>", extended="Build a prediction model by Passive-Aggressive 1 (PA-1) multiclass classifier")
    public static class PA1
    extends MulticlassPassiveAggressiveUDTF {
        protected float c;

        @Override
        protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
            String c_str;
            CommandLine cl = super.processOptions(argOIs);
            float c = 1.0f;
            if (cl != null && (c_str = cl.getOptionValue("c")) != null && !((c = Float.parseFloat(c_str)) > 0.0f)) {
                throw new UDFArgumentException("Aggressiveness parameter C must be C > 0: " + c);
            }
            this.c = c;
            return cl;
        }

        @Override
        protected float eta(float loss, float sqnorm) {
            float eta = loss / (2.0f * sqnorm);
            return Math.min(this.c, eta);
        }
    }
}

