/*
 * Decompiled with CFR 0.152.
 */
package hivemall.common;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConversionState {
    private static final Log logger = LogFactory.getLog(ConversionState.class);
    private final boolean conversionCheck;
    private final double convergenceRate;
    private boolean readyToFinishIterations;
    private double totalErrors;
    private double currLosses;
    private double prevLosses;
    private int curIter;

    public ConversionState() {
        this(true, 0.005);
    }

    public ConversionState(boolean conversionCheck, double convergenceRate) {
        this.conversionCheck = conversionCheck;
        this.convergenceRate = convergenceRate;
        this.readyToFinishIterations = false;
        this.totalErrors = 0.0;
        this.currLosses = 0.0;
        this.prevLosses = Double.POSITIVE_INFINITY;
        this.curIter = 1;
    }

    public double getTotalErrors() {
        return this.totalErrors;
    }

    public double getCumulativeLoss() {
        return this.currLosses;
    }

    public double getAverageLoss(@Nonnegative long numInstances) {
        if (numInstances == 0L) {
            return 0.0;
        }
        return this.currLosses / (double)numInstances;
    }

    public double getPreviousLoss() {
        return this.prevLosses;
    }

    public void incrError(double error) {
        this.totalErrors += error;
    }

    public void incrLoss(double loss) {
        this.currLosses += loss;
    }

    public void multiplyLoss(double multi) {
        this.currLosses *= multi;
    }

    public boolean isLossIncreased() {
        return this.currLosses > this.prevLosses;
    }

    public boolean isConverged(long observedTrainingExamples) {
        if (!this.conversionCheck) {
            return false;
        }
        if (this.currLosses > this.prevLosses) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Iteration #" + this.curIter + " current cumulative loss `" + this.currLosses + "` > previous cumulative loss `" + this.prevLosses + '`'));
            }
            this.readyToFinishIterations = false;
            return false;
        }
        double changeRate = this.getChangeRate();
        if (changeRate < this.convergenceRate) {
            if (this.readyToFinishIterations) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Training converged at " + this.curIter + "-th iteration!\n" + this.getInfo(observedTrainingExamples)));
                }
                return true;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.getInfo(observedTrainingExamples));
            }
            this.readyToFinishIterations = true;
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.getInfo(observedTrainingExamples));
            }
            this.readyToFinishIterations = false;
        }
        return false;
    }

    double getChangeRate() {
        return (this.prevLosses - this.currLosses) / this.prevLosses;
    }

    public void next() {
        this.prevLosses = this.currLosses;
        this.currLosses = 0.0;
        ++this.curIter;
    }

    public int getCurrentIteration() {
        return this.curIter;
    }

    @Nonnull
    public String getInfo(@Nonnegative long observedTrainingExamples) {
        StringBuilder buf = new StringBuilder();
        buf.append("Iteration #").append(this.curIter).append(" | ");
        buf.append("average loss=").append(this.getAverageLoss(observedTrainingExamples)).append(", ");
        buf.append("current cumulative loss=").append(this.currLosses).append(", ");
        buf.append("previous cumulative loss=").append(this.prevLosses).append(", ");
        buf.append("change rate=").append(this.getChangeRate()).append(", ");
        buf.append("#trainingExamples=").append(observedTrainingExamples);
        return buf.toString();
    }
}

