/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ensemble;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.io.FloatWritable;

@Description(name="argmin_kld", value="_FUNC_(float mean, float covar) - Returns mean or covar that minimize a KL-distance among distributions", extended="The returned value is (1.0 / (sum(1.0 / covar))) * (sum(mean / covar)")
public final class ArgminKLDistanceUDAF
extends UDAF {

    public static class ArgminMeanUDAFEvaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(FloatWritable mean, FloatWritable covar) {
            float covar_f;
            if (mean == null || covar == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            if ((covar_f = covar.get()) == 0.0f) {
                return true;
            }
            this.partial.sum_mean_div_covar += mean.get() / covar_f;
            this.partial.sum_inv_covar += 1.0f / covar_f;
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult o) {
            if (o == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.sum_mean_div_covar += o.sum_mean_div_covar;
            this.partial.sum_inv_covar += o.sum_inv_covar;
            return true;
        }

        public FloatWritable terminate() {
            if (this.partial == null) {
                return null;
            }
            if (this.partial.sum_inv_covar == 0.0f) {
                return new FloatWritable(0.0f);
            }
            float mean = 1.0f / this.partial.sum_inv_covar * this.partial.sum_mean_div_covar;
            return new FloatWritable(mean);
        }

        public static class PartialResult {
            float sum_mean_div_covar = 0.0f;
            float sum_inv_covar = 0.0f;

            PartialResult() {
            }
        }
    }
}

