/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ensemble;

import hivemall.utils.hadoop.WritableUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.io.Text;

@Description(name="max_label", value="_FUNC_(double value, string label) - Returns a label that has the maximum value")
public final class MaxValueLabelUDAF
extends UDAF {

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(double v, String label) {
            if (this.partial == null) {
                this.partial = new PartialResult();
                this.partial.init();
            }
            if (v >= this.partial.maxValue) {
                this.partial.maxValue = v;
                this.partial.label = label;
            }
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
                this.partial.init();
            }
            if (other.maxValue < this.partial.maxValue) {
                return true;
            }
            this.partial.maxValue = other.maxValue;
            this.partial.label = other.label;
            return true;
        }

        public Text terminate() {
            if (this.partial == null) {
                return null;
            }
            return WritableUtils.val(this.partial.label);
        }

        public static class PartialResult {
            double maxValue;
            String label;

            void init() {
                this.maxValue = Double.NEGATIVE_INFINITY;
                this.label = null;
            }

            public String toString() {
                return "PartialResult [maxValue=" + this.maxValue + ", label=" + this.label + "]";
            }
        }
    }
}

