/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import hivemall.evaluation.BinaryResponsesMeasures;
import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="auc", value="_FUNC_(array rankItems | double score, array correctItems | int label [, const int recommendSize = rankItems.size ]) - Returns AUC")
public final class AUCUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(@Nonnull TypeInfo[] typeInfo) throws SemanticException {
        if (typeInfo.length != 2 && typeInfo.length != 3) {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "_FUNC_ takes two or three arguments");
        }
        if (HiveUtils.isNumberTypeInfo(typeInfo[0]) && HiveUtils.isIntegerTypeInfo(typeInfo[1])) {
            return new ClassificationEvaluator();
        }
        ListTypeInfo arg1type = HiveUtils.asListTypeInfo(typeInfo[0]);
        if (!HiveUtils.isPrimitiveTypeInfo(arg1type.getListElementTypeInfo())) {
            throw new UDFArgumentTypeException(0, "The first argument `array rankItems` is invalid form: " + typeInfo[0]);
        }
        ListTypeInfo arg2type = HiveUtils.asListTypeInfo(typeInfo[1]);
        if (!HiveUtils.isPrimitiveTypeInfo(arg2type.getListElementTypeInfo())) {
            throw new UDFArgumentTypeException(1, "The second argument `array correctItems` is invalid form: " + typeInfo[1]);
        }
        return new RankingEvaluator();
    }

    public static class RankingAUCAggregationBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        double sum;
        long count;

        void reset() {
            this.sum = 0.0;
            this.count = 0L;
        }

        void merge(double o_sum, long o_count) {
            this.sum += o_sum;
            this.count += o_count;
        }

        double get() {
            if (this.count == 0L) {
                return 0.0;
            }
            return this.sum / (double)this.count;
        }

        void iterate(@Nonnull List<?> recommendList, @Nonnull List<?> truthList, @Nonnull int recommendSize) {
            this.sum += BinaryResponsesMeasures.AUC(recommendList, truthList, recommendSize);
            ++this.count;
        }
    }

    public static class RankingEvaluator
    extends GenericUDAFEvaluator {
        private ListObjectInspector recommendListOI;
        private ListObjectInspector truthListOI;
        private PrimitiveObjectInspector recommendSizeOI;
        private StructObjectInspector internalMergeOI;
        private StructField countField;
        private StructField sumField;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            assert (0 < parameters.length && parameters.length <= 3) : parameters.length;
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.recommendListOI = (ListObjectInspector)parameters[0];
                this.truthListOI = (ListObjectInspector)parameters[1];
                if (parameters.length == 3) {
                    this.recommendSizeOI = HiveUtils.asIntegerOI(parameters[2]);
                }
            } else {
                StructObjectInspector soi;
                this.internalMergeOI = soi = (StructObjectInspector)parameters[0];
                this.countField = soi.getStructFieldRef("count");
                this.sumField = soi.getStructFieldRef("sum");
            }
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? RankingEvaluator.internalMergeOI() : PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            return outputOI;
        }

        private static StructObjectInspector internalMergeOI() {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Object> fieldOIs = new ArrayList<Object>();
            fieldNames.add("sum");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            fieldNames.add("count");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            RankingAUCAggregationBuffer myAggr = new RankingAUCAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myAggr);
            return myAggr;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            RankingAUCAggregationBuffer myAggr = (RankingAUCAggregationBuffer)agg;
            myAggr.reset();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            List truthList;
            RankingAUCAggregationBuffer myAggr = (RankingAUCAggregationBuffer)agg;
            List recommendList = this.recommendListOI.getList(parameters[0]);
            if (recommendList == null) {
                recommendList = Collections.emptyList();
            }
            if ((truthList = this.truthListOI.getList(parameters[1])) == null) {
                return;
            }
            int recommendSize = recommendList.size();
            if (parameters.length == 3 && (recommendSize = PrimitiveObjectInspectorUtils.getInt((Object)parameters[2], (PrimitiveObjectInspector)this.recommendSizeOI)) < 0) {
                throw new UDFArgumentException("The third argument `int recommendSize` must be in greater than or equals to 0: " + recommendSize);
            }
            myAggr.iterate(recommendList, truthList, recommendSize);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            RankingAUCAggregationBuffer myAggr = (RankingAUCAggregationBuffer)agg;
            Object[] partialResult = new Object[]{new DoubleWritable(myAggr.sum), new LongWritable(myAggr.count)};
            return partialResult;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            Object sumObj = this.internalMergeOI.getStructFieldData(partial, this.sumField);
            Object countObj = this.internalMergeOI.getStructFieldData(partial, this.countField);
            double sum = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector.get(sumObj);
            long count = PrimitiveObjectInspectorFactory.writableLongObjectInspector.get(countObj);
            RankingAUCAggregationBuffer myAggr = (RankingAUCAggregationBuffer)agg;
            myAggr.merge(sum, count);
        }

        public DoubleWritable terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            RankingAUCAggregationBuffer myAggr = (RankingAUCAggregationBuffer)agg;
            double result = myAggr.get();
            return new DoubleWritable(result);
        }
    }

    public static class ClassificationAUCAggregationBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        double area;
        double scorePrev;
        double indexScore;
        long fp;
        long tp;
        long fpPrev;
        long tpPrev;
        Map<Double, Double> areaPartialMap;
        Map<Double, Long> fpPartialMap;
        Map<Double, Long> tpPartialMap;
        Map<Double, Long> fpPrevPartialMap;
        Map<Double, Long> tpPrevPartialMap;

        void reset() {
            this.area = 0.0;
            this.scorePrev = Double.POSITIVE_INFINITY;
            this.indexScore = 0.0;
            this.fp = 0L;
            this.tp = 0L;
            this.fpPrev = 0L;
            this.tpPrev = 0L;
            this.areaPartialMap = new HashMap<Double, Double>();
            this.fpPartialMap = new HashMap<Double, Long>();
            this.tpPartialMap = new HashMap<Double, Long>();
            this.fpPrevPartialMap = new HashMap<Double, Long>();
            this.tpPrevPartialMap = new HashMap<Double, Long>();
        }

        void merge(double o_indexScore, double o_area, long o_fp, long o_tp, long o_fpPrev, long o_tpPrev, Map<Double, Double> o_areaPartialMap, Map<Double, Long> o_fpPartialMap, Map<Double, Long> o_tpPartialMap, Map<Double, Long> o_fpPrevPartialMap, Map<Double, Long> o_tpPrevPartialMap) {
            this.areaPartialMap.putAll(o_areaPartialMap);
            this.fpPartialMap.putAll(o_fpPartialMap);
            this.tpPartialMap.putAll(o_tpPartialMap);
            this.fpPrevPartialMap.putAll(o_fpPrevPartialMap);
            this.tpPrevPartialMap.putAll(o_tpPrevPartialMap);
            this.areaPartialMap.put(o_indexScore, o_area += this.trapezoidArea(o_fp, o_fpPrev, o_tp, o_tpPrev));
            this.fpPartialMap.put(o_indexScore, o_fp);
            this.tpPartialMap.put(o_indexScore, o_tp);
            this.fpPrevPartialMap.put(o_indexScore, o_fpPrev);
            this.tpPrevPartialMap.put(o_indexScore, o_tpPrev);
        }

        double get() throws HiveException {
            this.areaPartialMap.put(this.indexScore, this.area);
            this.fpPartialMap.put(this.indexScore, this.fp);
            this.tpPartialMap.put(this.indexScore, this.tp);
            this.fpPrevPartialMap.put(this.indexScore, this.fpPrev);
            this.tpPrevPartialMap.put(this.indexScore, this.tpPrev);
            TreeMap areaPartialSortedMap = new TreeMap(Collections.reverseOrder());
            areaPartialSortedMap.putAll(this.areaPartialMap);
            double firstKey = (Double)areaPartialSortedMap.firstKey();
            double res = (Double)areaPartialSortedMap.get(firstKey);
            long fpAccum = this.fpPartialMap.get(firstKey);
            long tpAccum = this.tpPartialMap.get(firstKey);
            long fpPrevAccum = this.fpPrevPartialMap.get(firstKey);
            long tpPrevAccum = this.tpPrevPartialMap.get(firstKey);
            Iterator iterator = areaPartialSortedMap.keySet().iterator();
            while (iterator.hasNext()) {
                double k = (Double)iterator.next();
                if (k == firstKey) continue;
                res += ((Double)areaPartialSortedMap.get(k)).doubleValue();
                res += this.trapezoidArea(0.0, this.fpPartialMap.get(k).longValue(), tpAccum, tpAccum);
                fpPrevAccum = fpAccum + this.fpPrevPartialMap.get(k);
                tpPrevAccum = tpAccum + this.tpPrevPartialMap.get(k);
                fpAccum += this.fpPartialMap.get(k).longValue();
                tpAccum += this.tpPartialMap.get(k).longValue();
            }
            if (tpAccum == 0L || fpAccum == 0L) {
                throw new HiveException("AUC score is not defined because there is only one class in `label`.");
            }
            return (res += this.trapezoidArea(fpAccum, fpPrevAccum, tpAccum, tpPrevAccum)) / (double)(tpAccum * fpAccum);
        }

        void iterate(double score, int label) {
            if (score != this.scorePrev) {
                if (this.scorePrev == Double.POSITIVE_INFINITY) {
                    this.indexScore = score;
                }
                this.area += this.trapezoidArea(this.fp, this.fpPrev, this.tp, this.tpPrev);
                this.scorePrev = score;
                this.fpPrev = this.fp;
                this.tpPrev = this.tp;
            }
            if (label == 1) {
                ++this.tp;
            } else {
                ++this.fp;
            }
        }

        private double trapezoidArea(double x1, double x2, double y1, double y2) {
            double base = Math.abs(x1 - x2);
            double height = (y1 + y2) / 2.0;
            return base * height;
        }
    }

    public static class ClassificationEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector scoreOI;
        private PrimitiveObjectInspector labelOI;
        private StructObjectInspector internalMergeOI;
        private StructField indexScoreField;
        private StructField areaField;
        private StructField fpField;
        private StructField tpField;
        private StructField fpPrevField;
        private StructField tpPrevField;
        private StructField areaPartialMapField;
        private StructField fpPartialMapField;
        private StructField tpPartialMapField;
        private StructField fpPrevPartialMapField;
        private StructField tpPrevPartialMapField;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1 || parameters.length == 2) : parameters.length;
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.scoreOI = HiveUtils.asDoubleCompatibleOI(parameters[0]);
                this.labelOI = HiveUtils.asIntegerOI(parameters[1]);
            } else {
                StructObjectInspector soi;
                this.internalMergeOI = soi = (StructObjectInspector)parameters[0];
                this.indexScoreField = soi.getStructFieldRef("indexScore");
                this.areaField = soi.getStructFieldRef("area");
                this.fpField = soi.getStructFieldRef("fp");
                this.tpField = soi.getStructFieldRef("tp");
                this.fpPrevField = soi.getStructFieldRef("fpPrev");
                this.tpPrevField = soi.getStructFieldRef("tpPrev");
                this.areaPartialMapField = soi.getStructFieldRef("areaPartialMap");
                this.fpPartialMapField = soi.getStructFieldRef("fpPartialMap");
                this.tpPartialMapField = soi.getStructFieldRef("tpPartialMap");
                this.fpPrevPartialMapField = soi.getStructFieldRef("fpPrevPartialMap");
                this.tpPrevPartialMapField = soi.getStructFieldRef("tpPrevPartialMap");
            }
            Object outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? ClassificationEvaluator.internalMergeOI() : PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            return outputOI;
        }

        private static StructObjectInspector internalMergeOI() {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Object> fieldOIs = new ArrayList<Object>();
            fieldNames.add("indexScore");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            fieldNames.add("area");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            fieldNames.add("fp");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            fieldNames.add("tp");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            fieldNames.add("fpPrev");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            fieldNames.add("tpPrev");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            StandardMapObjectInspector areaPartialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
            fieldNames.add("areaPartialMap");
            fieldOIs.add(areaPartialMapOI);
            StandardMapObjectInspector fpPartialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            fieldNames.add("fpPartialMap");
            fieldOIs.add(fpPartialMapOI);
            StandardMapObjectInspector tpPartialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            fieldNames.add("tpPartialMap");
            fieldOIs.add(tpPartialMapOI);
            StandardMapObjectInspector fpPrevPartialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            fieldNames.add("fpPrevPartialMap");
            fieldOIs.add(fpPrevPartialMapOI);
            StandardMapObjectInspector tpPrevPartialMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            fieldNames.add("tpPrevPartialMap");
            fieldOIs.add(tpPrevPartialMapOI);
            return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            ClassificationAUCAggregationBuffer myAggr = new ClassificationAUCAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myAggr);
            return myAggr;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ClassificationAUCAggregationBuffer myAggr = (ClassificationAUCAggregationBuffer)agg;
            myAggr.reset();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            ClassificationAUCAggregationBuffer myAggr = (ClassificationAUCAggregationBuffer)agg;
            if (parameters[0] == null) {
                return;
            }
            if (parameters[1] == null) {
                return;
            }
            double score = HiveUtils.getDouble(parameters[0], this.scoreOI);
            if (score < 0.0 || score > 1.0) {
                throw new UDFArgumentException("score value MUST be in range [0,1]: " + score);
            }
            int label = PrimitiveObjectInspectorUtils.getInt((Object)parameters[1], (PrimitiveObjectInspector)this.labelOI);
            if (label == -1) {
                label = 0;
            } else if (label != 0 && label != 1) {
                throw new UDFArgumentException("label MUST be 0/1 or -1/1: " + label);
            }
            myAggr.iterate(score, label);
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ClassificationAUCAggregationBuffer myAggr = (ClassificationAUCAggregationBuffer)agg;
            Object[] partialResult = new Object[]{new DoubleWritable(myAggr.indexScore), new DoubleWritable(myAggr.area), new LongWritable(myAggr.fp), new LongWritable(myAggr.tp), new LongWritable(myAggr.fpPrev), new LongWritable(myAggr.tpPrev), myAggr.areaPartialMap, myAggr.fpPartialMap, myAggr.tpPartialMap, myAggr.fpPrevPartialMap, myAggr.tpPrevPartialMap};
            return partialResult;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            Object indexScoreObj = this.internalMergeOI.getStructFieldData(partial, this.indexScoreField);
            Object areaObj = this.internalMergeOI.getStructFieldData(partial, this.areaField);
            Object fpObj = this.internalMergeOI.getStructFieldData(partial, this.fpField);
            Object tpObj = this.internalMergeOI.getStructFieldData(partial, this.tpField);
            Object fpPrevObj = this.internalMergeOI.getStructFieldData(partial, this.fpPrevField);
            Object tpPrevObj = this.internalMergeOI.getStructFieldData(partial, this.tpPrevField);
            Object areaPartialMapObj = this.internalMergeOI.getStructFieldData(partial, this.areaPartialMapField);
            Object fpPartialMapObj = this.internalMergeOI.getStructFieldData(partial, this.fpPartialMapField);
            Object tpPartialMapObj = this.internalMergeOI.getStructFieldData(partial, this.tpPartialMapField);
            Object fpPrevPartialMapObj = this.internalMergeOI.getStructFieldData(partial, this.fpPrevPartialMapField);
            Object tpPrevPartialMapObj = this.internalMergeOI.getStructFieldData(partial, this.tpPrevPartialMapField);
            double indexScore = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector.get(indexScoreObj);
            double area = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector.get(areaObj);
            long fp = PrimitiveObjectInspectorFactory.writableLongObjectInspector.get(fpObj);
            long tp = PrimitiveObjectInspectorFactory.writableLongObjectInspector.get(tpObj);
            long fpPrev = PrimitiveObjectInspectorFactory.writableLongObjectInspector.get(fpPrevObj);
            long tpPrev = PrimitiveObjectInspectorFactory.writableLongObjectInspector.get(tpPrevObj);
            StandardMapObjectInspector ddMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
            StandardMapObjectInspector dlMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector);
            Map areaPartialMap = ddMapOI.getMap(HiveUtils.castLazyBinaryObject(areaPartialMapObj));
            Map fpPartialMap = dlMapOI.getMap(HiveUtils.castLazyBinaryObject(fpPartialMapObj));
            Map tpPartialMap = dlMapOI.getMap(HiveUtils.castLazyBinaryObject(tpPartialMapObj));
            Map fpPrevPartialMap = dlMapOI.getMap(HiveUtils.castLazyBinaryObject(fpPrevPartialMapObj));
            Map tpPrevPartialMap = dlMapOI.getMap(HiveUtils.castLazyBinaryObject(tpPrevPartialMapObj));
            ClassificationAUCAggregationBuffer myAggr = (ClassificationAUCAggregationBuffer)agg;
            myAggr.merge(indexScore, area, fp, tp, fpPrev, tpPrev, areaPartialMap, fpPartialMap, tpPartialMap, fpPrevPartialMap, tpPrevPartialMap);
        }

        public DoubleWritable terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ClassificationAUCAggregationBuffer myAggr = (ClassificationAUCAggregationBuffer)agg;
            double result = myAggr.get();
            return new DoubleWritable(result);
        }
    }
}

