/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import hivemall.utils.lang.Preconditions;
import hivemall.utils.math.MathUtils;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class BinaryResponsesMeasures {
    private BinaryResponsesMeasures() {
    }

    public static double nDCG(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        double dcg = 0.0;
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            int rank = i + 1;
            dcg += 1.0 / MathUtils.log2(rank + 1);
        }
        double idcg = BinaryResponsesMeasures.IDCG(Math.min(groundTruth.size(), k));
        if (idcg == 0.0) {
            return 0.0;
        }
        return dcg / idcg;
    }

    public static double IDCG(@Nonnegative int n) {
        Preconditions.checkArgument(n >= 0);
        double idcg = 0.0;
        for (int i = 0; i < n; ++i) {
            idcg += 1.0 / MathUtils.log2(i + 2);
        }
        return idcg;
    }

    public static double Precision(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        if (rankedList.isEmpty()) {
            if (groundTruth.isEmpty()) {
                return 1.0;
            }
            return 0.0;
        }
        int nTruePositive = 0;
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            ++nTruePositive;
        }
        return (double)nTruePositive / (double)k;
    }

    public static double Recall(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        if (groundTruth.isEmpty()) {
            if (rankedList.isEmpty()) {
                return 1.0;
            }
            return 0.0;
        }
        return (double)BinaryResponsesMeasures.TruePositives(rankedList, groundTruth, recommendSize) / (double)groundTruth.size();
    }

    public static double Hit(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            return 1.0;
        }
        return 0.0;
    }

    public static int TruePositives(List<?> rankedList, List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        int nTruePositive = 0;
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            ++nTruePositive;
        }
        return nTruePositive;
    }

    public static double ReciprocalRank(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            return 1.0 / (double)(i + 1);
        }
        return 0.0;
    }

    public static double AveragePrecision(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        if (groundTruth.isEmpty()) {
            if (rankedList.isEmpty()) {
                return 1.0;
            }
            return 0.0;
        }
        int nTruePositive = 0;
        double sumPrecision = 0.0;
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            sumPrecision += (double)(++nTruePositive) / ((double)i + 1.0);
        }
        if (nTruePositive == 0) {
            return 0.0;
        }
        return sumPrecision / (double)nTruePositive;
    }

    public static double AUC(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        int nTruePositive = 0;
        int nCorrectPairs = 0;
        int k = Math.min(rankedList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            Object item_id = rankedList.get(i);
            if (groundTruth.contains(item_id)) {
                ++nTruePositive;
                continue;
            }
            nCorrectPairs += nTruePositive;
        }
        int nPairs = nTruePositive * (recommendSize - nTruePositive);
        if (nPairs == 0) {
            return 0.5;
        }
        return (double)nCorrectPairs / (double)nPairs;
    }
}

