/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import hivemall.utils.lang.Preconditions;
import hivemall.utils.math.MathUtils;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class GradedResponsesMeasures {
    private GradedResponsesMeasures() {
    }

    public static double nDCG(@Nonnull List<Double> recommendTopRelScoreList, @Nonnull List<Double> truthTopRelScoreList, @Nonnegative int recommendSize) {
        double dcg = GradedResponsesMeasures.DCG(recommendTopRelScoreList, recommendSize);
        double idcg = GradedResponsesMeasures.DCG(truthTopRelScoreList, recommendSize);
        return dcg / idcg;
    }

    public static double DCG(@Nonnull List<Double> topRelScoreList, @Nonnegative int recommendSize) {
        Preconditions.checkArgument(recommendSize >= 0);
        double dcg = 0.0;
        int k = Math.min(topRelScoreList.size(), recommendSize);
        for (int i = 0; i < k; ++i) {
            double relScore = topRelScoreList.get(i);
            dcg += (Math.pow(2.0, relScore) - 1.0) * MathUtils.LOG2 / Math.log(i + 2);
        }
        return dcg;
    }
}

