/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="mae", value="_FUNC_(double predicted, double actual) - Return a Mean Absolute Error")
public final class MeanAbsoluteErrorUDAF
extends UDAF {

    public static class PartialResult {
        double diff_sum = 0.0;
        long count = 0L;

        PartialResult() {
        }

        void iterate(double predicted, double actual) {
            this.diff_sum += Math.abs(predicted - actual);
            ++this.count;
        }

        void merge(PartialResult other) {
            this.diff_sum += other.diff_sum;
            this.count += other.count;
        }

        double getMAE() {
            return this.diff_sum / (double)this.count;
        }
    }

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(DoubleWritable predicted, DoubleWritable actual) throws HiveException {
            if (predicted == null || actual == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.iterate(predicted.get(), actual.get());
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) throws HiveException {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.merge(other);
            return true;
        }

        public double terminate() {
            if (this.partial == null) {
                return 0.0;
            }
            return this.partial.getMAE();
        }
    }
}

