/*
 * Decompiled with CFR 0.152.
 */
package hivemall.factorization.fm;

import hivemall.factorization.fm.Entry;
import hivemall.factorization.fm.FMHyperParameters;
import hivemall.factorization.fm.Feature;
import hivemall.factorization.fm.FieldAwareFactorizationMachineModel;
import hivemall.utils.buffer.HeapBuffer;
import hivemall.utils.collections.lists.LongArrayList;
import hivemall.utils.lang.NumberUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.roaringbitmap.RoaringBitmap;

public final class FFMStringFeatureMapModel
extends FieldAwareFactorizationMachineModel {
    private static final int DEFAULT_MAPSIZE = 65536;
    private float _w0 = 0.0f;
    @Nonnull
    final Int2LongMap _map = new Int2LongOpenHashMap(65536);
    @Nonnull
    final HeapBuffer _buf;
    @Nonnull
    private final LongArrayList _freelistW;
    @Nonnull
    private final LongArrayList _freelistV;
    private boolean _initV;
    @Nonnull
    private RoaringBitmap _removedV;
    private final int _numFields;
    private final int _entrySizeW;
    private final int _entrySizeV;
    private long _bytesAllocated;
    private long _bytesUsed;
    private int _numAllocatedW;
    private int _numReusedW;
    private int _numRemovedW;
    private int _numAllocatedV;
    private int _numReusedV;
    private int _numRemovedV;

    public FFMStringFeatureMapModel(@Nonnull FMHyperParameters.FFMHyperParameters params) {
        super(params);
        this._map.defaultReturnValue(-1L);
        this._buf = new HeapBuffer(0x400000);
        this._freelistW = new LongArrayList();
        this._freelistV = new LongArrayList();
        this._initV = true;
        this._removedV = new RoaringBitmap();
        this._numFields = params.numFields;
        this._entrySizeW = FFMStringFeatureMapModel.entrySize(1, this._useFTRL, this._useAdaGrad);
        this._entrySizeV = FFMStringFeatureMapModel.entrySize(this._factor, this._useFTRL, this._useAdaGrad);
    }

    private static int entrySize(@Nonnegative int factors, boolean ftrl, boolean adagrad) {
        if (ftrl) {
            return Entry.FTRLEntry.sizeOf(factors);
        }
        if (adagrad) {
            return Entry.AdaGradEntry.sizeOf(factors);
        }
        return Entry.sizeOf(factors);
    }

    void disableInitV() {
        this._initV = false;
    }

    @Override
    public int getSize() {
        return this._map.size();
    }

    @Override
    public float getW0() {
        return this._w0;
    }

    @Override
    protected void setW0(float nextW0) {
        this._w0 = nextW0;
    }

    @Override
    public float getW(@Nonnull Feature x) {
        int j = Feature.toIntFeature(x);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            return 0.0f;
        }
        return entry.getW();
    }

    @Override
    protected void setW(@Nonnull Feature x, float nextWi) {
        int j = Feature.toIntFeature(x);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            entry = this.newEntry(j, nextWi);
            long ptr = entry.getOffset();
            this._map.put(j, ptr);
        } else {
            entry.setW(nextWi);
        }
    }

    @Override
    public float getV(@Nonnull Feature x, @Nonnull int yField, int f) {
        int j = Feature.toIntFeature(x, yField, this._numFields);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            if (!this._initV) {
                return 0.0f;
            }
            if (this._removedV.contains(j)) {
                return 0.0f;
            }
            float[] V = this.initV();
            entry = this.newEntry(j, V);
            long ptr = entry.getOffset();
            this._map.put(j, ptr);
            return V[f];
        }
        return entry.getV(f);
    }

    @Override
    protected void setV(@Nonnull Feature x, @Nonnull int yField, int f, float nextVif) {
        int j = Feature.toIntFeature(x, yField, this._numFields);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            if (!this._initV) {
                return;
            }
            if (this._removedV.contains(j)) {
                return;
            }
            float[] V = this.initV();
            entry = this.newEntry(j, V);
            long ptr = entry.getOffset();
            this._map.put(j, ptr);
        }
        entry.setV(f, nextVif);
    }

    @Override
    protected Entry getEntryW(@Nonnull Feature x) {
        int j = Feature.toIntFeature(x);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            entry = this.newEntry(j, 0.0f);
            long ptr = entry.getOffset();
            this._map.put(j, ptr);
        }
        return entry;
    }

    @Override
    protected Entry getEntryV(@Nonnull Feature x, @Nonnull int yField) {
        int j = Feature.toIntFeature(x, yField, this._numFields);
        Entry entry = this.getEntry(j);
        if (entry == null) {
            if (!this._initV) {
                return null;
            }
            if (this._removedV.contains(j)) {
                return null;
            }
            float[] V = this.initV();
            entry = this.newEntry(j, V);
            long ptr = entry.getOffset();
            this._map.put(j, ptr);
        }
        return entry;
    }

    @Override
    protected void removeEntry(@Nonnull Entry entry) {
        int j = entry.getKey();
        long ptr = this._map.remove(j);
        if (ptr == -1L) {
            return;
        }
        entry.clear();
        if (Entry.isEntryW(j)) {
            this._freelistW.add(ptr);
            ++this._numRemovedW;
            this._bytesUsed -= (long)this._entrySizeW;
        } else {
            this._removedV.add(j);
            this._freelistV.add(ptr);
            ++this._numRemovedV;
            this._bytesUsed -= (long)this._entrySizeV;
        }
    }

    @Nonnull
    protected final Entry newEntry(int key, float W) {
        long ptr;
        if (this._freelistW.isEmpty()) {
            ptr = this._buf.allocate(this._entrySizeW);
            ++this._numAllocatedW;
            this._bytesAllocated += (long)this._entrySizeW;
            this._bytesUsed += (long)this._entrySizeW;
        } else {
            ptr = this._freelistW.remove();
            ++this._numReusedW;
        }
        Entry entry = this._useFTRL ? new Entry.FTRLEntry(this._buf, key, ptr) : (this._useAdaGrad ? new Entry.AdaGradEntry(this._buf, key, ptr) : new Entry(this._buf, key, ptr));
        entry.setW(W);
        return entry;
    }

    @Nonnull
    protected final Entry newEntry(int key, @Nonnull float[] V) {
        long ptr;
        if (this._freelistV.isEmpty()) {
            ptr = this._buf.allocate(this._entrySizeV);
            ++this._numAllocatedV;
            this._bytesAllocated += (long)this._entrySizeV;
            this._bytesUsed += (long)this._entrySizeV;
        } else {
            ptr = this._freelistV.remove();
            ++this._numReusedV;
        }
        Entry entry = this._useFTRL ? new Entry.FTRLEntry(this._buf, this._factor, key, ptr) : (this._useAdaGrad ? new Entry.AdaGradEntry(this._buf, this._factor, key, ptr) : new Entry(this._buf, this._factor, key, ptr));
        entry.setV(V);
        return entry;
    }

    @Nullable
    private Entry getEntry(int key) {
        long ptr = this._map.get(key);
        if (ptr == -1L) {
            return null;
        }
        return this.getEntry(key, ptr);
    }

    @Nonnull
    private Entry getEntry(int key, @Nonnegative long ptr) {
        if (Entry.isEntryW(key)) {
            if (this._useFTRL) {
                return new Entry.FTRLEntry(this._buf, key, ptr);
            }
            if (this._useAdaGrad) {
                return new Entry.AdaGradEntry(this._buf, key, ptr);
            }
            return new Entry(this._buf, key, ptr);
        }
        if (this._useFTRL) {
            return new Entry.FTRLEntry(this._buf, this._factor, key, ptr);
        }
        if (this._useAdaGrad) {
            return new Entry.AdaGradEntry(this._buf, this._factor, key, ptr);
        }
        return new Entry(this._buf, this._factor, key, ptr);
    }

    @Nonnull
    String getStatistics() {
        NumberFormat fmt = NumberFormat.getIntegerInstance(Locale.US);
        return "FFMStringFeatureMapModel [bytesAllocated=" + NumberUtils.prettySize(this._bytesAllocated) + ", bytesUsed=" + NumberUtils.prettySize(this._bytesUsed) + ", numAllocatedW=" + fmt.format(this._numAllocatedW) + ", numReusedW=" + fmt.format(this._numReusedW) + ", numRemovedW=" + fmt.format(this._numRemovedW) + ", numAllocatedV=" + fmt.format(this._numAllocatedV) + ", numReusedV=" + fmt.format(this._numReusedV) + ", numRemovedV=" + fmt.format(this._numRemovedV) + "]";
    }

    public String toString() {
        return this.getStatistics();
    }
}

